/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.generation;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.TrackingPhase;
import org.spongepowered.common.event.tracking.phase.TrackingPhases;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;

class GeneralGenerationPhaseState
implements IPhaseState {
    private Set<IPhaseState> compatibleStates = new HashSet<IPhaseState>();
    private boolean isBaked = false;
    private final String id;

    GeneralGenerationPhaseState(String id) {
        this.id = id;
    }

    final GeneralGenerationPhaseState addCompatibleState(IPhaseState state) {
        if (this.isBaked) {
            throw new IllegalStateException("This state is already baked! " + this.id);
        }
        this.compatibleStates.add(state);
        return this;
    }

    final GeneralGenerationPhaseState bake() {
        if (this.isBaked) {
            throw new IllegalStateException("This state is already baked! " + this.id);
        }
        this.compatibleStates = ImmutableSet.copyOf(this.compatibleStates);
        this.isBaked = true;
        return this;
    }

    @Override
    public final TrackingPhase getPhase() {
        return TrackingPhases.GENERATION;
    }

    @Override
    public final boolean canSwitchTo(IPhaseState state) {
        return this.compatibleStates.contains(state);
    }

    @Override
    public final boolean isExpectedForReEntrance() {
        return true;
    }

    Cause provideSpawnCause(PhaseContext context) {
        return Cause.source(InternalSpawnTypes.SpawnCauses.WORLD_SPAWNER_CAUSE).named("World", context.firstNamed("World", World.class).orElseThrow(TrackingUtil.throwWithContext("Expected a world during generation!", context))).build();
    }

    public final void unwind(PhaseContext context) {
        World world = context.firstNamed("World", World.class).orElseThrow(TrackingUtil.throwWithContext("Expected a world during generation!", context));
        List<Entity> spawnedEntities = context.getCapturedEntitySupplier().orEmptyList();
        if (spawnedEntities.isEmpty()) {
            return;
        }
        Cause cause = this.provideSpawnCause(context);
        SpawnEntityEvent.Spawner event = SpongeEventFactory.createSpawnEntityEventSpawner(cause, spawnedEntities, world);
        SpongeImpl.postEvent(event);
        if (!event.isCancelled()) {
            for (Entity entity : event.getEntities()) {
                EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeneralGenerationPhaseState that = (GeneralGenerationPhaseState)o;
        return Objects.equal((Object)this.id, (Object)that.id);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).toString();
    }
}

