/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.generation;

import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.phase.generation.GeneralGenerationPhaseState;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;
import org.spongepowered.common.world.gen.InternalPopulatorTypes;

final class PopulatorGenerationPhaseState
extends GeneralGenerationPhaseState {
    PopulatorGenerationPhaseState(String id) {
        super(id);
    }

    @Override
    Cause provideSpawnCause(PhaseContext context) {
        PopulatorType runningGenerator = context.firstNamed("PopulatorType", PopulatorType.class).orElse(null);
        World world = context.firstNamed("World", World.class).orElse(null);
        Cause.Builder causeBuilder = Cause.builder();
        Cause.source(InternalSpawnTypes.SpawnCauses.WORLD_SPAWNER_CAUSE).named("World", world);
        if (InternalPopulatorTypes.ANIMAL.equals(runningGenerator)) {
            causeBuilder.named(NamedCause.source(InternalSpawnTypes.SpawnCauses.WORLD_SPAWNER_CAUSE)).named(NamedCause.of("AnimalSpawner", runningGenerator));
        } else if (runningGenerator != null) {
            causeBuilder.named(NamedCause.source(InternalSpawnTypes.SpawnCauses.STRUCTURE_SPAWNING)).named(NamedCause.of("Structure", runningGenerator));
        } else {
            causeBuilder.named(NamedCause.source(InternalSpawnTypes.SpawnCauses.STRUCTURE_SPAWNING));
        }
        return causeBuilder.build();
    }
}

