/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import com.flowpowered.math.vector.Vector3d;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.event.cause.entity.spawn.LocatableBlockSpawnCause;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.CauseTracker;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.tick.LocationBasedTickPhaseState;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.block.IMixinBlockEventData;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;
import org.spongepowered.common.util.VecHelper;

class BlockTickPhaseState
extends LocationBasedTickPhaseState {
    private final String name;

    BlockTickPhaseState(String name) {
        this.name = name;
    }

    @Override
    LocatableBlock getLocatableBlockSourceFromContext(PhaseContext context) {
        return context.getSource(LocatableBlock.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be ticking over at a location!", context));
    }

    @Override
    Location<World> getLocationSourceFromContext(PhaseContext context) {
        return context.getSource(LocatableBlock.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be ticking over at a location!", context)).getLocation();
    }

    @Override
    public void processPostTick(PhaseContext context) {
        LocatableBlock locatableBlock = this.getLocatableBlockSourceFromContext(context);
        Optional<User> owner = context.getOwner();
        Optional<User> notifier = context.getNotifier();
        User entityCreator = notifier.orElseGet(() -> owner.orElse(null));
        context.getCapturedBlockSupplier().ifPresentAndNotEmpty(blockSnapshots -> TrackingUtil.processBlockCaptures(blockSnapshots, this, context));
        context.getCapturedItemsSupplier().ifPresentAndNotEmpty(items -> {
            Cause cause = Cause.source(((LocatableBlockSpawnCause.Builder)((LocatableBlockSpawnCause.Builder)LocatableBlockSpawnCause.builder().locatableBlock(locatableBlock)).type(InternalSpawnTypes.DROPPED_ITEM)).build()).build();
            ArrayList<org.spongepowered.api.entity.Entity> capturedEntities = new ArrayList<org.spongepowered.api.entity.Entity>();
            for (EntityItem entity : items) {
                capturedEntities.add(EntityUtil.fromNative((Entity)entity));
            }
            SpawnEntityEvent spawnEntityEvent = SpongeEventFactory.createSpawnEntityEvent(cause, capturedEntities, locatableBlock.getWorld());
            SpongeImpl.postEvent(spawnEntityEvent);
            for (org.spongepowered.api.entity.Entity entity : spawnEntityEvent.getEntities()) {
                if (entityCreator != null) {
                    EntityUtil.toMixin(entity).setCreator(entityCreator.getUniqueId());
                }
                EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
            }
        });
    }

    @Override
    public void associateAdditionalBlockChangeCauses(PhaseContext context, Cause.Builder builder) {
        builder.named(NamedCause.notifier(this.getLocatableBlockSourceFromContext(context)));
    }

    @Override
    public void associateBlockEventNotifier(PhaseContext context, BlockPos pos, IMixinBlockEventData blockEvent) {
        LocatableBlock locatableBlock = this.getLocatableBlockSourceFromContext(context);
        blockEvent.setTickBlock(locatableBlock);
        Location<World> location = locatableBlock.getLocation();
        WorldServer worldServer = (WorldServer)location.getExtent();
        Vector3d blockPosition = location.getPosition();
        BlockPos blockPos = VecHelper.toBlockPos(blockPosition);
        IMixinChunk mixinChunk = (IMixinChunk)worldServer.func_175726_f(blockPos);
        mixinChunk.getBlockNotifier(blockPos).ifPresent(blockEvent::setSourceUser);
        context.firstNamed("Notifier", User.class).ifPresent(blockEvent::setSourceUser);
    }

    @Override
    public void appendExplosionContext(PhaseContext explosionContext, PhaseContext context) {
        context.getOwner().ifPresent(explosionContext::owner);
        context.getNotifier().ifPresent(explosionContext::notifier);
        LocatableBlock locatableBlock = this.getLocatableBlockSourceFromContext(context);
        explosionContext.add(NamedCause.source(locatableBlock));
    }

    @Override
    public boolean spawnEntityOrCapture(PhaseContext context, org.spongepowered.api.entity.Entity entity, int chunkX, int chunkZ) {
        LocatableBlock locatableBlock = this.getLocatableBlockSourceFromContext(context);
        Optional<User> owner = context.getOwner();
        Optional<User> notifier = context.getNotifier();
        User entityCreator = notifier.orElseGet(() -> owner.orElse(null));
        if (entity instanceof EntityXPOrb) {
            ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>(1);
            entities.add(entity);
            Cause.Builder builder = Cause.builder();
            builder.named(NamedCause.source(((LocatableBlockSpawnCause.Builder)((LocatableBlockSpawnCause.Builder)LocatableBlockSpawnCause.builder().locatableBlock(locatableBlock)).type(InternalSpawnTypes.EXPERIENCE)).build()));
            notifier.ifPresent(builder::notifier);
            owner.ifPresent(builder::owner);
            SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(builder.build(), entities, locatableBlock.getWorld());
            SpongeImpl.postEvent(event);
            if (!event.isCancelled()) {
                for (org.spongepowered.api.entity.Entity anEntity : event.getEntities()) {
                    if (entityCreator != null) {
                        EntityUtil.toMixin(anEntity).setCreator(entityCreator.getUniqueId());
                    }
                    EntityUtil.getMixinWorld(entity).forceSpawnEntity(anEntity);
                }
                return true;
            }
            return false;
        }
        ArrayList<org.spongepowered.api.entity.Entity> nonExpEntities = new ArrayList<org.spongepowered.api.entity.Entity>(1);
        nonExpEntities.add(entity);
        Cause.Builder builder = Cause.source(((LocatableBlockSpawnCause.Builder)((LocatableBlockSpawnCause.Builder)LocatableBlockSpawnCause.builder().locatableBlock(locatableBlock)).type(InternalSpawnTypes.BLOCK_SPAWNING)).build());
        notifier.ifPresent(builder::notifier);
        owner.ifPresent(builder::owner);
        Cause cause = builder.build();
        SpawnEntityEvent spawnEntityEvent = SpongeEventFactory.createSpawnEntityEvent(cause, nonExpEntities, locatableBlock.getWorld());
        SpongeImpl.postEvent(spawnEntityEvent);
        if (!spawnEntityEvent.isCancelled()) {
            for (org.spongepowered.api.entity.Entity anEntity : spawnEntityEvent.getEntities()) {
                if (entityCreator != null) {
                    EntityUtil.toMixin(anEntity).setCreator(entityCreator.getUniqueId());
                }
                EntityUtil.getMixinWorld(entity).forceSpawnEntity(anEntity);
            }
            return true;
        }
        return false;
    }

    @Override
    public void postTrackBlock(BlockSnapshot snapshot, CauseTracker tracker, PhaseContext context) {
        boolean processImmediately = context.firstNamed("ProcessImmediately", Boolean.class).get();
        if (processImmediately) {
            TrackingUtil.processBlockCaptures(context.getCapturedBlocks(), this, context);
            context.getCapturedBlockSupplier().get().remove(snapshot);
        }
    }

    public String toString() {
        return this.name;
    }
}

