/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.entity.spawn.SpawnCause;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.TrackingPhases;
import org.spongepowered.common.event.tracking.phase.tick.TickPhaseState;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;

class DimensionTickPhaseState
extends TickPhaseState {
    DimensionTickPhaseState() {
    }

    @Override
    public boolean canSwitchTo(IPhaseState state) {
        return super.canSwitchTo(state) || state.getPhase() == TrackingPhases.DRAGON;
    }

    @Override
    public void processPostTick(PhaseContext phaseContext) {
        World spongeWorld = phaseContext.firstNamed("World", World.class).orElseThrow(TrackingUtil.throwWithContext("Expected a world during dimension tick!", phaseContext));
        phaseContext.getCapturedBlockSupplier().ifPresentAndNotEmpty(blockSnapshots -> TrackingUtil.processBlockCaptures(blockSnapshots, this, phaseContext));
        phaseContext.getCapturedEntitySupplier().ifPresentAndNotEmpty(entities -> {
            Cause cause = Cause.source(((SpawnCause.Builder)SpawnCause.builder().type(InternalSpawnTypes.PLACEMENT)).build()).build();
            SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(cause, entities, spongeWorld);
            SpongeImpl.postEvent(event);
            if (!event.isCancelled()) {
                for (org.spongepowered.api.entity.Entity entity : event.getEntities()) {
                    EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                }
            }
        });
        phaseContext.getCapturedItemsSupplier().ifPresentAndNotEmpty(entities -> {
            Cause cause = Cause.source(((SpawnCause.Builder)SpawnCause.builder().type(InternalSpawnTypes.PLACEMENT)).build()).build();
            ArrayList<org.spongepowered.api.entity.Entity> capturedEntities = new ArrayList<org.spongepowered.api.entity.Entity>();
            for (EntityItem entity : entities) {
                capturedEntities.add(EntityUtil.fromNative((Entity)entity));
            }
            SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(cause, capturedEntities, spongeWorld);
            SpongeImpl.postEvent(event);
            if (!event.isCancelled()) {
                for (org.spongepowered.api.entity.Entity entity : event.getEntities()) {
                    EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                }
            }
        });
    }

    @Override
    public void associateAdditionalBlockChangeCauses(PhaseContext context, Cause.Builder builder) {
    }

    @Override
    public boolean spawnEntityOrCapture(PhaseContext context, org.spongepowered.api.entity.Entity entity, int chunkX, int chunkZ) {
        Entity minecraftEntity = (Entity)entity;
        WorldServer minecraftWorld = (WorldServer)minecraftEntity.field_70170_p;
        User user = context.getNotifier().orElseGet(() -> context.getOwner().orElse(null));
        if (user != null) {
            entity.setCreator(user.getUniqueId());
        }
        ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>(1);
        entities.add(entity);
        Cause cause = Cause.source(((SpawnCause.Builder)SpawnCause.builder().type(InternalSpawnTypes.PLACEMENT)).build()).build();
        SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(cause, entities, (World)minecraftWorld);
        SpongeImpl.postEvent(event);
        if (!event.isCancelled() && event.getEntities().size() > 0) {
            for (org.spongepowered.api.entity.Entity item : event.getEntities()) {
                EntityUtil.getMixinWorld(entity).forceSpawnEntity(item);
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "DimensionTickPhase";
    }
}

