/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import com.flowpowered.math.vector.Vector3d;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.event.cause.entity.spawn.LocatableBlockSpawnCause;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.tick.LocationBasedTickPhaseState;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.block.IMixinBlockEventData;
import org.spongepowered.common.interfaces.block.tile.IMixinTileEntity;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;
import org.spongepowered.common.util.VecHelper;

class TileEntityTickPhaseState
extends LocationBasedTickPhaseState {
    TileEntityTickPhaseState() {
    }

    @Override
    Location<World> getLocationSourceFromContext(PhaseContext context) {
        return context.getSource(TileEntity.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be ticking over a TileEntity!", context)).getLocation();
    }

    @Override
    LocatableBlock getLocatableBlockSourceFromContext(PhaseContext context) {
        return context.getSource(TileEntity.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be ticking over a TileEntity!", context)).getLocatableBlock();
    }

    @Override
    public void processPostTick(PhaseContext phaseContext) {
        TileEntity tickingTile = phaseContext.getSource(TileEntity.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on a TileEntity!", phaseContext));
        World spongeWorld = tickingTile.getWorld();
        Optional<User> notifier = phaseContext.getNotifier();
        Optional<User> owner = phaseContext.getOwner();
        User entityCreator = notifier.orElseGet(() -> owner.orElse(null));
        try {
            phaseContext.getCapturedBlockSupplier().ifPresentAndNotEmpty(blockSnapshots -> TrackingUtil.processBlockCaptures(blockSnapshots, this, phaseContext));
            phaseContext.getCapturedItemsSupplier().ifPresentAndNotEmpty(entities -> {
                Cause cause = Cause.source(((LocatableBlockSpawnCause.Builder)((LocatableBlockSpawnCause.Builder)LocatableBlockSpawnCause.builder().locatableBlock(tickingTile.getLocatableBlock())).type(InternalSpawnTypes.BLOCK_SPAWNING)).build()).build();
                ArrayList<org.spongepowered.api.entity.Entity> capturedEntities = new ArrayList<org.spongepowered.api.entity.Entity>();
                for (EntityItem entity : entities) {
                    capturedEntities.add(EntityUtil.fromNative((Entity)entity));
                }
                SpawnEntityEvent spawnEntityEvent = SpongeEventFactory.createSpawnEntityEvent(cause, capturedEntities, spongeWorld);
                SpongeImpl.postEvent(spawnEntityEvent);
                if (!spawnEntityEvent.isCancelled()) {
                    for (org.spongepowered.api.entity.Entity entity : spawnEntityEvent.getEntities()) {
                        if (entityCreator != null) {
                            EntityUtil.toMixin(entity).setCreator(entityCreator.getUniqueId());
                        }
                        EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                    }
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Exception occured while processing tile entity %s at %s", tickingTile, tickingTile.getLocation()), e);
        }
    }

    @Override
    public void associateAdditionalBlockChangeCauses(PhaseContext context, Cause.Builder builder) {
        TileEntity tickingTile = context.getSource(TileEntity.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on a TileEntity!", context));
        builder.named(NamedCause.notifier(tickingTile));
    }

    @Override
    public void associateBlockEventNotifier(PhaseContext context, BlockPos pos, IMixinBlockEventData blockEvent) {
        TileEntity tickingTile = context.getSource(TileEntity.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be ticking a block, but found none!", context));
        blockEvent.setTickTileEntity(tickingTile);
        Location<World> blockLocation = tickingTile.getLocation();
        WorldServer worldServer = (WorldServer)blockLocation.getExtent();
        Vector3d blockPosition = blockLocation.getPosition();
        BlockPos blockPos = VecHelper.toBlockPos(blockPosition);
        IMixinChunk mixinChunk = (IMixinChunk)worldServer.func_175726_f(blockPos);
        mixinChunk.getBlockNotifier(blockPos).ifPresent(blockEvent::setSourceUser);
        context.firstNamed("Notifier", User.class).ifPresent(blockEvent::setSourceUser);
    }

    @Override
    public void appendExplosionContext(PhaseContext explosionContext, PhaseContext context) {
        context.getOwner().ifPresent(explosionContext::owner);
        context.getNotifier().ifPresent(explosionContext::notifier);
        TileEntity tickingTile = context.getSource(TileEntity.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be processing over a ticking TileEntity!", context));
        explosionContext.add(NamedCause.source(tickingTile));
    }

    @Override
    public boolean spawnEntityOrCapture(PhaseContext context, org.spongepowered.api.entity.Entity entity, int chunkX, int chunkZ) {
        TileEntity tickingTile = context.getSource(TileEntity.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on a TileEntity!", context));
        World spongeWorld = tickingTile.getWorld();
        Optional<User> notifier = context.getNotifier();
        Optional<User> owner = context.getOwner();
        User entityCreator = notifier.orElseGet(() -> owner.orElse(null));
        IMixinTileEntity mixinTileEntity = (IMixinTileEntity)((Object)tickingTile);
        if (entity instanceof EntityXPOrb) {
            Cause.Builder builder = Cause.builder();
            builder.named(NamedCause.source(((LocatableBlockSpawnCause.Builder)((LocatableBlockSpawnCause.Builder)LocatableBlockSpawnCause.builder().locatableBlock(tickingTile.getLocatableBlock())).type(InternalSpawnTypes.EXPERIENCE)).build()));
            notifier.ifPresent(builder::notifier);
            owner.ifPresent(builder::owner);
            ArrayList<org.spongepowered.api.entity.Entity> exp = new ArrayList<org.spongepowered.api.entity.Entity>();
            exp.add(entity);
            SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(builder.build(), exp, spongeWorld);
            SpongeImpl.postEvent(event);
            if (!event.isCancelled()) {
                for (org.spongepowered.api.entity.Entity anEntity : event.getEntities()) {
                    if (entityCreator != null) {
                        EntityUtil.toMixin(anEntity).setCreator(entityCreator.getUniqueId());
                    }
                    EntityUtil.getMixinWorld(entity).forceSpawnEntity(anEntity);
                }
                return true;
            }
            return false;
        }
        ArrayList<org.spongepowered.api.entity.Entity> nonExpEntities = new ArrayList<org.spongepowered.api.entity.Entity>(1);
        nonExpEntities.add(entity);
        Cause.Builder builder = Cause.source(((LocatableBlockSpawnCause.Builder)((LocatableBlockSpawnCause.Builder)LocatableBlockSpawnCause.builder().locatableBlock(tickingTile.getLocatableBlock())).type(mixinTileEntity.getTickedSpawnType())).build());
        notifier.ifPresent(builder::notifier);
        owner.ifPresent(builder::owner);
        Cause cause = builder.build();
        SpawnEntityEvent spawnEntityEvent = SpongeEventFactory.createSpawnEntityEvent(cause, nonExpEntities, spongeWorld);
        SpongeImpl.postEvent(spawnEntityEvent);
        if (!spawnEntityEvent.isCancelled()) {
            for (org.spongepowered.api.entity.Entity anEntity : spawnEntityEvent.getEntities()) {
                if (entityCreator != null) {
                    EntityUtil.toMixin(anEntity).setCreator(entityCreator.getUniqueId());
                }
                EntityUtil.getMixinWorld(entity).forceSpawnEntity(anEntity);
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "TileEntityTickPhase";
    }
}

