/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.io.File;
import java.nio.file.Path;
import javax.inject.Inject;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import org.slf4j.Logger;
import org.spongepowered.api.Game;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.config.DefaultConfig;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.AsynchronousExecutor;
import org.spongepowered.api.scheduler.Scheduler;
import org.spongepowered.api.scheduler.SpongeExecutorService;
import org.spongepowered.api.scheduler.SynchronousExecutor;
import org.spongepowered.common.config.SpongeConfigManager;
import org.spongepowered.common.guice.ConfigDirAnnotation;
import org.spongepowered.common.guice.ConfigFileAnnotation;

public class SpongePluginGuiceModule
extends AbstractModule {
    private final PluginContainer container;
    private final Class<?> pluginClass;

    public SpongePluginGuiceModule(PluginContainer container, Class<?> pluginClass) {
        this.container = container;
        this.pluginClass = pluginClass;
    }

    @Override
    protected void configure() {
        ConfigDirAnnotation privateConfigDir = new ConfigDirAnnotation(false);
        ConfigFileAnnotation sharedConfigFile = new ConfigFileAnnotation(true);
        ConfigFileAnnotation privateConfigFile = new ConfigFileAnnotation(false);
        this.bind(this.pluginClass).in(Scopes.SINGLETON);
        this.bind(PluginContainer.class).toInstance(this.container);
        this.bind(Logger.class).toInstance(this.container.getLogger());
        this.bind(Path.class).annotatedWith(privateConfigDir).toProvider(PrivateConfigDirProvider.class);
        this.bind(File.class).annotatedWith(privateConfigDir).toProvider(FilePrivateConfigDirProvider.class);
        this.bind(Path.class).annotatedWith(sharedConfigFile).toProvider(SharedConfigFileProvider.class);
        this.bind(File.class).annotatedWith(sharedConfigFile).toProvider(FileSharedConfigFileProvider.class);
        this.bind(Path.class).annotatedWith(privateConfigFile).toProvider(PrivateConfigFileProvider.class);
        this.bind(File.class).annotatedWith(privateConfigFile).toProvider(FilePrivateConfigFileProvider.class);
        this.bind(new TypeLiteral<ConfigurationLoader<CommentedConfigurationNode>>(){}).annotatedWith(sharedConfigFile).toProvider(SharedHoconConfigProvider.class);
        this.bind(new TypeLiteral<ConfigurationLoader<CommentedConfigurationNode>>(){}).annotatedWith(privateConfigFile).toProvider(PrivateHoconConfigProvider.class);
        this.bind(SpongeExecutorService.class).annotatedWith(SynchronousExecutor.class).toProvider(SynchronousExecutorProvider.class);
        this.bind(SpongeExecutorService.class).annotatedWith(AsynchronousExecutor.class).toProvider(AsynchronousExecutorProvider.class);
    }

    private static class AsynchronousExecutorProvider
    implements Provider<SpongeExecutorService> {
        private final PluginContainer container;
        private final Scheduler schedulerService;

        @Inject
        private AsynchronousExecutorProvider(PluginContainer container, Game game) {
            this.container = container;
            this.schedulerService = game.getScheduler();
        }

        @Override
        public SpongeExecutorService get() {
            return this.schedulerService.createAsyncExecutor(this.container);
        }
    }

    private static class SynchronousExecutorProvider
    implements Provider<SpongeExecutorService> {
        private final PluginContainer container;
        private final Scheduler schedulerService;

        @Inject
        private SynchronousExecutorProvider(PluginContainer container, Game game) {
            this.container = container;
            this.schedulerService = game.getScheduler();
        }

        @Override
        public SpongeExecutorService get() {
            return this.schedulerService.createSyncExecutor(this.container);
        }
    }

    private static class FileSharedConfigFileProvider
    implements Provider<File> {
        private final Path configPath;

        @Inject
        private FileSharedConfigFileProvider(@DefaultConfig(sharedRoot=true) Path configPath) {
            this.configPath = configPath;
        }

        @Override
        public File get() {
            return this.configPath.toFile();
        }
    }

    private static class FilePrivateConfigFileProvider
    implements Provider<File> {
        private final Path configPath;

        @Inject
        private FilePrivateConfigFileProvider(@DefaultConfig(sharedRoot=false) Path configPath) {
            this.configPath = configPath;
        }

        @Override
        public File get() {
            return this.configPath.toFile();
        }
    }

    private static class FilePrivateConfigDirProvider
    implements Provider<File> {
        private final Path configDir;

        @Inject
        private FilePrivateConfigDirProvider(@ConfigDir(sharedRoot=false) Path configDir) {
            this.configDir = configDir;
        }

        @Override
        public File get() {
            return this.configDir.toFile();
        }
    }

    private static class PrivateHoconConfigProvider
    implements Provider<ConfigurationLoader<CommentedConfigurationNode>> {
        private final PluginContainer container;

        @Inject
        private PrivateHoconConfigProvider(PluginContainer container) {
            this.container = container;
        }

        @Override
        public ConfigurationLoader<CommentedConfigurationNode> get() {
            return SpongeConfigManager.getPrivateRoot(this.container).getConfig();
        }
    }

    private static class SharedHoconConfigProvider
    implements Provider<ConfigurationLoader<CommentedConfigurationNode>> {
        private final PluginContainer container;

        @Inject
        private SharedHoconConfigProvider(PluginContainer container) {
            this.container = container;
        }

        @Override
        public ConfigurationLoader<CommentedConfigurationNode> get() {
            return SpongeConfigManager.getSharedRoot(this.container).getConfig();
        }
    }

    private static class SharedConfigFileProvider
    implements Provider<Path> {
        private final PluginContainer container;

        @Inject
        private SharedConfigFileProvider(PluginContainer container) {
            this.container = container;
        }

        @Override
        public Path get() {
            return SpongeConfigManager.getSharedRoot(this.container).getConfigPath();
        }
    }

    private static class PrivateConfigFileProvider
    implements Provider<Path> {
        private final PluginContainer container;

        @Inject
        private PrivateConfigFileProvider(PluginContainer container) {
            this.container = container;
        }

        @Override
        public Path get() {
            return SpongeConfigManager.getPrivateRoot(this.container).getConfigPath();
        }
    }

    private static class PrivateConfigDirProvider
    implements Provider<Path> {
        private final PluginContainer container;

        @Inject
        private PrivateConfigDirProvider(PluginContainer container) {
            this.container = container;
        }

        @Override
        public Path get() {
            return SpongeConfigManager.getPrivateRoot(this.container).getDirectory();
        }
    }
}

