/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.interfaces.entity.explosive;

import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.explosive.FusedExplosive;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.event.entity.explosive.DefuseExplosiveEvent;
import org.spongepowered.api.event.entity.explosive.PrimeExplosiveEvent;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.interfaces.entity.explosive.IMixinExplosive;

public interface IMixinFusedExplosive
extends IMixinExplosive {
    public int getFuseDuration();

    public void setFuseDuration(int var1);

    public int getFuseTicksRemaining();

    public void setFuseTicksRemaining(int var1);

    default public boolean shouldPrime(@Nullable Cause cause) {
        if (ShouldFire.PRIME_EXPLOSIVE_EVENT_PRE) {
            PrimeExplosiveEvent.Pre event = SpongeEventFactory.createPrimeExplosiveEventPre(cause != null ? cause : Cause.of(NamedCause.source(this)), (FusedExplosive)((Object)this));
            return !Sponge.getEventManager().post(event);
        }
        return true;
    }

    default public void postPrime(@Nullable Cause cause) {
        if (ShouldFire.PRIME_EXPLOSIVE_EVENT_POST) {
            PrimeExplosiveEvent.Post event = SpongeEventFactory.createPrimeExplosiveEventPost(cause != null ? cause : Cause.of(NamedCause.source(this)), (FusedExplosive)((Object)this));
            Sponge.getEventManager().post(event);
        }
    }

    default public boolean shouldDefuse(@Nullable Cause cause) {
        if (ShouldFire.DEFUSE_EXPLOSIVE_EVENT_PRE) {
            DefuseExplosiveEvent.Pre event = SpongeEventFactory.createDefuseExplosiveEventPre(cause != null ? cause : Cause.of(NamedCause.source(this)), (FusedExplosive)((Object)this));
            return !Sponge.getEventManager().post(event);
        }
        return true;
    }

    default public void postDefuse(@Nullable Cause cause) {
        if (ShouldFire.DEFUSE_EXPLOSIVE_EVENT_POST) {
            DefuseExplosiveEvent.Post event = SpongeEventFactory.createDefuseExplosiveEventPost(cause != null ? cause : Cause.of(NamedCause.source(this)), (FusedExplosive)((Object)this));
            Sponge.getEventManager().post(event);
        }
    }
}

