/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.adapter.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.inventory.IInventory;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryArchetype;
import org.spongepowered.api.item.inventory.InventoryArchetypes;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.common.item.inventory.InventoryIterator;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.Adapter;
import org.spongepowered.common.item.inventory.query.Query;

public interface MinecraftInventoryAdapter
extends InventoryAdapter<IInventory, net.minecraft.item.ItemStack> {
    @Override
    default public Translation getName() {
        return this.getRootLens().getName(this.getInventory());
    }

    @Override
    default public Optional<ItemStack> poll() {
        return Adapter.Logic.pollSequential(this);
    }

    @Override
    default public Optional<ItemStack> poll(int limit) {
        return Adapter.Logic.pollSequential(this, limit);
    }

    @Override
    default public Optional<ItemStack> peek() {
        return Adapter.Logic.peekSequential(this);
    }

    @Override
    default public Optional<ItemStack> peek(int limit) {
        return Adapter.Logic.peekSequential(this, limit);
    }

    @Override
    default public InventoryTransactionResult offer(ItemStack stack) {
        return Adapter.Logic.appendSequential(this, stack);
    }

    @Override
    default public InventoryTransactionResult set(ItemStack stack) {
        return Adapter.Logic.insertSequential(this, stack);
    }

    @Override
    default public int size() {
        return Adapter.Logic.countStacks(this);
    }

    @Override
    default public int totalItems() {
        return Adapter.Logic.countItems(this);
    }

    @Override
    default public int capacity() {
        return Adapter.Logic.getCapacity(this);
    }

    @Override
    default public boolean hasChildren() {
        return this.getRootLens().getChildren().size() != 0;
    }

    @Override
    default public boolean contains(ItemStack stack) {
        return Adapter.Logic.contains((InventoryAdapter<IInventory, net.minecraft.item.ItemStack>)this, stack);
    }

    @Override
    default public boolean contains(ItemType type) {
        return Adapter.Logic.contains((InventoryAdapter<IInventory, net.minecraft.item.ItemStack>)this, type);
    }

    @Override
    default public int getMaxStackSize() {
        return this.getRootLens().getMaxStackSize(this.getInventory());
    }

    @Override
    default public void setMaxStackSize(int size) {
        throw new UnsupportedOperationException("This inventory does not support stack limit adjustment");
    }

    @Override
    default public <T extends InventoryProperty<?, ?>> Collection<T> getProperties(Inventory child, Class<T> property) {
        return Adapter.Logic.getProperties(this, child, property);
    }

    @Override
    default public <T extends InventoryProperty<?, ?>> Collection<T> getProperties(Class<T> property) {
        if (this.parent() == this) {
            return Collections.emptyList();
        }
        return this.parent().getProperties(this, property);
    }

    @Override
    default public <T extends InventoryProperty<?, ?>> Optional<T> getProperty(Inventory child, Class<T> property, Object key) {
        for (InventoryProperty<?, ?> prop : Adapter.Logic.getProperties(this, child, property)) {
            if (!key.equals(prop.getKey())) continue;
            return Optional.of(prop);
        }
        return Optional.empty();
    }

    @Override
    default public <T extends InventoryProperty<?, ?>> Optional<T> getProperty(Class<T> property, Object key) {
        if (this.parent() == this) {
            return Optional.empty();
        }
        return this.parent().getProperty(this, property, key);
    }

    @Override
    default public Iterator<Inventory> iterator() {
        return new InventoryIterator(this.getRootLens(), this.getInventory(), this);
    }

    @Override
    default public <T extends Inventory> T query(Class<?> ... types) {
        return (T)Query.compile(this, types).execute();
    }

    @Override
    default public <T extends Inventory> T query(ItemType ... types) {
        return (T)Query.compile(this, types).execute();
    }

    @Override
    default public <T extends Inventory> T query(ItemStack ... types) {
        return (T)Query.compile(this, types).execute();
    }

    @Override
    default public <T extends Inventory> T query(InventoryProperty<?, ?> ... props) {
        return (T)Query.compile(this, props).execute();
    }

    @Override
    default public <T extends Inventory> T query(Translation ... names) {
        return (T)Query.compile(this, names).execute();
    }

    @Override
    default public <T extends Inventory> T query(String ... args) {
        return (T)Query.compile(this, args).execute();
    }

    @Override
    default public <T extends Inventory> T query(Object ... args) {
        return (T)Query.compile(this, args).execute();
    }

    @Override
    default public InventoryArchetype getArchetype() {
        return InventoryArchetypes.UNKNOWN;
    }
}

