/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.lens.impl.minecraft.container;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.impl.comp.CraftingInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.comp.EquipmentInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.comp.GridInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.comp.HotbarLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.comp.OrderedInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.minecraft.container.ContainerLens;

public class ContainerPlayerInventoryLens
extends ContainerLens {
    private static final int CRAFTING_OUTPUT = 1;
    private static final int CRAFTING_GRID = 2;
    private static final int EQUIPMENT = 4;
    private static final int INVENTORY_WIDTH = 9;
    private static final int MAIN_INVENTORY_HEIGHT = 3;
    private static final int HOTBAR = 1;
    private static final int OFFHAND = 1;

    public ContainerPlayerInventoryLens(InventoryAdapter<IInventory, ItemStack> adapter, SlotProvider<IInventory, ItemStack> slots) {
        super(adapter, slots);
        this.init(slots);
    }

    @Override
    protected void init(SlotProvider<IInventory, ItemStack> slots) {
        int additionalSlots;
        int base = 1;
        CraftingInventoryLensImpl crafting = new CraftingInventoryLensImpl(0, base, 2, 2, 2, slots);
        EquipmentInventoryLensImpl armor = new EquipmentInventoryLensImpl(null, base += 4, 4, 1, slots);
        GridInventoryLensImpl main = new GridInventoryLensImpl(base += 4, 9, 3, 9, slots);
        HotbarLensImpl hotbar = new HotbarLensImpl(base += 27, 9, slots);
        OrderedInventoryLensImpl offHand = new OrderedInventoryLensImpl(base += 9, 1, 1, slots);
        this.viewedInventories = new ArrayList<OrderedInventoryLensImpl>(Arrays.asList(hotbar, main, armor, crafting, offHand));
        if ((additionalSlots = this.size - ++base) > 0) {
            this.viewedInventories.add(new OrderedInventoryLensImpl(base, additionalSlots, 1, slots));
        }
        super.init(slots);
    }
}

