/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.query;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Map;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.common.item.inventory.EmptyInventoryImpl;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.MutableLensSet;
import org.spongepowered.common.item.inventory.lens.impl.collections.MutableLensSetImpl;
import org.spongepowered.common.item.inventory.query.InvalidQueryStrategyException;
import org.spongepowered.common.item.inventory.query.QueryStrategy;
import org.spongepowered.common.item.inventory.query.result.MinecraftResultAdapterProvider;
import org.spongepowered.common.item.inventory.query.result.QueryResult;
import org.spongepowered.common.item.inventory.query.strategy.ClassStrategy;
import org.spongepowered.common.item.inventory.query.strategy.CompoundStrategy;
import org.spongepowered.common.item.inventory.query.strategy.GenericStrategy;
import org.spongepowered.common.item.inventory.query.strategy.ItemStackStrategy;
import org.spongepowered.common.item.inventory.query.strategy.ItemTypeStrategy;
import org.spongepowered.common.item.inventory.query.strategy.NameStrategy;
import org.spongepowered.common.item.inventory.query.strategy.PropertyStrategy;
import org.spongepowered.common.item.inventory.query.strategy.expression.ExpressionStrategy;

public class Query<TInventory, TStack> {
    private static final Map<String, Class<? extends QueryStrategy<?, ?, ?>>> strategies = Maps.newHashMap();
    private static ResultAdapterProvider<?, ?> defaultResultProvider;
    private final InventoryAdapter<TInventory, TStack> adapter;
    private final Fabric<TInventory> inventory;
    private final Lens<TInventory, TStack> lens;
    private final QueryStrategy<TInventory, TStack, ?> strategy;

    private Query(InventoryAdapter<TInventory, TStack> adapter, Type type, Object ... args) {
        QueryStrategy strategy = Query.getStrategy(type).with(ImmutableSet.copyOf((Object[])args));
        this.adapter = adapter;
        this.inventory = adapter.getInventory();
        this.lens = adapter.getRootLens();
        this.strategy = strategy;
    }

    public Inventory execute() {
        return this.execute(defaultResultProvider);
    }

    public Inventory execute(ResultAdapterProvider<TInventory, TStack> resultProvider) {
        if (this.strategy.matches(this.lens, null, this.inventory)) {
            return this.lens.getAdapter(this.inventory, null);
        }
        return this.toResult(resultProvider, this.depthFirstSearch(this.lens));
    }

    private Inventory toResult(ResultAdapterProvider<TInventory, TStack> resultProvider, MutableLensSet<TInventory, TStack> matches) {
        if (matches.size() == 0) {
            return new EmptyInventoryImpl(this.adapter);
        }
        if (matches.size() == 1) {
            InventoryAdapter ada = matches.getLens(0).getAdapter(this.inventory, this.adapter);
            return ada;
        }
        if (resultProvider != null) {
            return resultProvider.getResultAdapter(this.inventory, matches, this.adapter);
        }
        return defaultResultProvider.getResultAdapter(this.inventory, matches, this.adapter);
    }

    private MutableLensSet<TInventory, TStack> depthFirstSearch(Lens<TInventory, TStack> lens) {
        MutableLensSetImpl matches = new MutableLensSetImpl(true);
        for (Lens<TInventory, TStack> child : lens.getChildren()) {
            if (child == null) continue;
            if (child.getChildren().size() > 0) {
                matches.addAll(this.depthFirstSearch(child));
            }
            if (!this.strategy.matches(child, lens, this.inventory)) continue;
            matches.add(child);
        }
        if (matches.size() < 2) {
            return matches;
        }
        return this.reduce(lens, matches);
    }

    private MutableLensSet<TInventory, TStack> reduce(Lens<TInventory, TStack> lens, MutableLensSet<TInventory, TStack> matches) {
        if (lens.getSlots().equals(this.getSlots(matches))) {
            matches.clear();
            matches.add(lens);
            return matches;
        }
        for (Lens<TInventory, TStack> child : lens.getChildren()) {
            if (child == null || !child.isSubsetOf(matches)) continue;
            matches.removeAll(child.getChildren());
            matches.add(child);
        }
        return matches;
    }

    private IntSet getSlots(Collection<Lens<TInventory, TStack>> lenses) {
        IntOpenHashSet slots = new IntOpenHashSet();
        for (Lens<TInventory, TStack> lens : lenses) {
            slots.addAll(lens.getSlots());
        }
        return slots;
    }

    public static <TInventory, TStack> Query<TInventory, TStack> compile(InventoryAdapter<TInventory, TStack> adapter, Class<?> ... types) {
        return new Query<TInventory, TStack>(adapter, Type.CLASS, types);
    }

    public static <TInventory, TStack> Query<TInventory, TStack> compile(InventoryAdapter<TInventory, TStack> adapter, ItemType ... types) {
        return new Query<TInventory, TStack>(adapter, Type.TYPE, types);
    }

    public static <TInventory, TStack> Query<TInventory, TStack> compile(InventoryAdapter<TInventory, TStack> adapter, ItemStack ... types) {
        return new Query<TInventory, TStack>(adapter, Type.STACK, types);
    }

    public static <TInventory, TStack> Query<TInventory, TStack> compile(InventoryAdapter<TInventory, TStack> adapter, InventoryProperty<?, ?> ... props) {
        return new Query<TInventory, TStack>(adapter, Type.PROPERTIES, props);
    }

    public static <TInventory, TStack> Query<TInventory, TStack> compile(InventoryAdapter<TInventory, TStack> adapter, Translation ... names) {
        return new Query<TInventory, TStack>(adapter, Type.NAME, names);
    }

    public static <TInventory, TStack> Query<TInventory, TStack> compile(InventoryAdapter<TInventory, TStack> adapter, String ... expression) {
        return new Query<TInventory, TStack>(adapter, Type.EXPRESSION, expression);
    }

    public static <TInventory, TStack> Query<TInventory, TStack> compile(InventoryAdapter<TInventory, TStack> adapter, Object ... args) {
        return new Query<TInventory, TStack>(adapter, Type.COMPOUND, args);
    }

    public static <TInventory, TStack, TArgs> QueryStrategy<TInventory, TStack, TArgs> getStrategy(Type type) {
        return Query.getStrategy(type.getKey());
    }

    public static <TInventory, TStack, TArgs> QueryStrategy<TInventory, TStack, TArgs> getStrategy(String key) {
        Class strategyClass = (Class)Preconditions.checkNotNull(strategies.get(key), (String)"The specified query strategy [%s], was not registered", (Object[])new Object[]{key});
        try {
            return (QueryStrategy)strategyClass.newInstance();
        }
        catch (Exception ex) {
            throw new InvalidQueryStrategyException("The query strategy class %s does not provide a noargs ctor", strategyClass);
        }
    }

    public static void registerStrategy(String key, Class<? extends QueryStrategy<?, ?, ?>> strategyClass) {
        try {
            Constructor constructor = ((Class)Preconditions.checkNotNull(strategyClass, (Object)"strategyClass")).getConstructor(new Class[0]);
        }
        catch (Exception ex) {
            throw new InvalidQueryStrategyException("The query strategy class %s does not provide a noargs ctor", strategyClass);
        }
        strategies.put(key, strategyClass);
    }

    public static void setDefaultResultProvider(ResultAdapterProvider<?, ?> defaultResultProvider) {
        Query.defaultResultProvider = defaultResultProvider;
    }

    public static Type getType(Object argument) {
        if (argument instanceof Class) {
            return Type.CLASS;
        }
        if (argument instanceof ItemType) {
            return Type.TYPE;
        }
        if (argument instanceof ItemStack) {
            return Type.STACK;
        }
        if (argument instanceof InventoryProperty) {
            return Type.PROPERTIES;
        }
        if (argument instanceof Translation) {
            return Type.NAME;
        }
        if (argument instanceof String) {
            return Type.EXPRESSION;
        }
        return Type.GENERIC;
    }

    private static void registerDefaultStrategies() {
        for (Type type : Type.values()) {
            Query.registerStrategy(type.getKey(), type.getDefaultStrategyClass());
        }
    }

    static {
        Query.registerDefaultStrategies();
        Query.setDefaultResultProvider(new MinecraftResultAdapterProvider());
    }

    public static interface ResultAdapterProvider<TInventory, TStack> {
        public QueryResult<TInventory, TStack> getResultAdapter(Fabric<TInventory> var1, MutableLensSet<TInventory, TStack> var2, Inventory var3);
    }

    public static enum Type {
        CLASS("class", ClassStrategy.class),
        TYPE("type", ItemTypeStrategy.class),
        STACK("stack", ItemStackStrategy.class),
        PROPERTIES("property", PropertyStrategy.class),
        NAME("name", NameStrategy.class),
        EXPRESSION("expr", ExpressionStrategy.class),
        GENERIC("args", GenericStrategy.class),
        COMPOUND("compound", CompoundStrategy.class);

        private final String key;
        private final Class<? extends QueryStrategy<?, ?, ?>> defaultStrategyClass;

        private Type(String key, Class<? extends QueryStrategy> defaultStrategyClass) {
            this.key = key;
            this.defaultStrategyClass = defaultStrategyClass;
        }

        public String getKey() {
            return this.key;
        }

        public Class<? extends QueryStrategy<?, ?, ?>> getDefaultStrategyClass() {
            return this.defaultStrategyClass;
        }
    }
}

