/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.query.result;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.lang.reflect.Constructor;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.Adapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.MutableLensSet;
import org.spongepowered.common.item.inventory.query.Query;
import org.spongepowered.common.item.inventory.query.result.QueryResult;

public class MinecraftResultAdapterProvider
implements Query.ResultAdapterProvider<IInventory, ItemStack> {
    private MutableLensSet<IInventory, ItemStack> resultSet;

    @Override
    public QueryResult<IInventory, ItemStack> getResultAdapter(Fabric<IInventory> inventory, MutableLensSet<IInventory, ItemStack> matches, Inventory parent) {
        this.resultSet = matches;
        return new MinecraftQueryResultAdapter(inventory, parent);
    }

    protected MutableLensSet<IInventory, ItemStack> getResultSet() {
        return this.resultSet;
    }

    protected int getResultSize() {
        IntOpenHashSet slots = new IntOpenHashSet();
        for (Lens lens : this.getResultSet()) {
            slots.addAll(lens.getSlots());
        }
        return slots.size();
    }

    public class MinecraftQueryResultAdapter
    extends Adapter
    implements QueryResult<IInventory, ItemStack> {
        public MinecraftQueryResultAdapter(Fabric<IInventory> inventory, Inventory parent) {
            super(inventory, null, parent);
        }

        @Override
        protected Lens<IInventory, ItemStack> initRootLens() {
            return new MinecraftQueryLens(MinecraftResultAdapterProvider.this.getResultSize(), MinecraftResultAdapterProvider.this.getResultSet());
        }

        public class MinecraftQueryLens
        extends QueryResult.QueryLens<IInventory, ItemStack> {
            public MinecraftQueryLens(int size, MutableLensSet<IInventory, ItemStack> resultSet) {
                super(size, resultSet);
            }

            @Override
            public InventoryAdapter<IInventory, ItemStack> getAdapter(Fabric<IInventory> inv, Inventory parent) {
                return MinecraftQueryResultAdapter.this;
            }

            @Override
            protected Constructor<InventoryAdapter<IInventory, ItemStack>> getAdapterCtor() throws NoSuchMethodException {
                try {
                    return this.adapterType.getConstructor(Fabric.class, this.getClass(), Inventory.class);
                }
                catch (Exception ex1) {
                    return this.adapterType.getConstructor(Fabric.class, Lens.class, Inventory.class);
                }
            }

            @Override
            public int getMaxStackSize(Fabric<IInventory> inv) {
                return inv.getMaxStackSize();
            }

            @Override
            public void invalidate(Fabric<IInventory> inv) {
                super.invalidate(inv);
            }
        }
    }
}

