/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.query.strategy;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.slots.SlotLens;
import org.spongepowered.common.item.inventory.query.QueryStrategy;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

public class ItemStackStrategy<TInventory>
extends QueryStrategy<TInventory, ItemStack, ItemStack> {
    private Set<ItemStack> stacks;

    @Override
    public QueryStrategy<TInventory, ItemStack, ItemStack> with(ImmutableSet<ItemStack> types) {
        this.stacks = types;
        return this;
    }

    @Override
    public boolean matches(Lens<TInventory, ItemStack> lens, Lens<TInventory, ItemStack> parent, Fabric<TInventory> inventory) {
        if (this.stacks.isEmpty()) {
            return true;
        }
        if (lens instanceof SlotLens) {
            ItemStack stack = (ItemStack)((SlotLens)lens).getStack(inventory);
            if (stack == null) {
                return false;
            }
            for (ItemStack candidate : this.stacks) {
                if (!ItemStackUtil.compare(stack, candidate)) continue;
                return true;
            }
        }
        return false;
    }
}

