/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.query.strategy;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.slots.SlotLens;
import org.spongepowered.common.item.inventory.query.QueryStrategy;

public class ItemTypeStrategy<TInventory>
extends QueryStrategy<TInventory, ItemStack, ItemType> {
    private Set<ItemType> types;

    @Override
    public QueryStrategy<TInventory, ItemStack, ItemType> with(ImmutableSet<ItemType> types) {
        this.types = types;
        return this;
    }

    @Override
    public boolean matches(Lens<TInventory, ItemStack> lens, Lens<TInventory, ItemStack> parent, Fabric<TInventory> inventory) {
        if (this.types.isEmpty()) {
            return true;
        }
        if (lens instanceof SlotLens) {
            ItemStack stack = (ItemStack)((SlotLens)lens).getStack(inventory);
            if (stack == null) {
                return false;
            }
            for (ItemType type : this.types) {
                if (!stack.getItem().equals(type)) continue;
                return true;
            }
        }
        return false;
    }
}

