/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.query.strategy;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Set;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.query.QueryStrategy;

public class PropertyStrategy<TInventory, TStack>
extends QueryStrategy<TInventory, TStack, InventoryProperty<?, ?>> {
    private Set<InventoryProperty<?, ?>> properties;

    @Override
    public QueryStrategy<TInventory, TStack, InventoryProperty<?, ?>> with(ImmutableSet<InventoryProperty<?, ?>> args) {
        this.properties = ImmutableSet.copyOf(args);
        return this;
    }

    @Override
    public boolean matches(Lens<TInventory, TStack> lens, Lens<TInventory, TStack> parent, Fabric<TInventory> inventory) {
        if (this.properties.isEmpty()) {
            return true;
        }
        if (parent == null) {
            return false;
        }
        try {
            Collection<InventoryProperty<?, ?>> lensProperties = parent.getProperties(lens);
            for (InventoryProperty<?, ?> lensProperty : lensProperties) {
                for (InventoryProperty<?, ?> property : this.properties) {
                    if (!property.matches(lensProperty)) continue;
                    return true;
                }
            }
        }
        catch (NoSuchElementException ex) {
            return false;
        }
        return false;
    }
}

