/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.util;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.common.item.inventory.util.NativeStackException;

public abstract class ItemStackUtil {
    private ItemStackUtil() {
    }

    public static NBTTagCompound getTagCompound(net.minecraft.item.ItemStack itemStack) {
        NBTTagCompound compound = itemStack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
            itemStack.func_77982_d(compound);
        }
        return compound;
    }

    @Nullable
    public static net.minecraft.item.ItemStack toNative(@Nullable ItemStack stack) {
        if (stack instanceof net.minecraft.item.ItemStack || stack == null) {
            return (net.minecraft.item.ItemStack)stack;
        }
        throw new NativeStackException("The supplied item stack was not native to the current platform");
    }

    @Nullable
    public static ItemStack fromNative(@Nullable net.minecraft.item.ItemStack stack) {
        if (stack instanceof ItemStack || stack == null) {
            return (ItemStack)stack;
        }
        throw new NativeStackException("The supplied native item stack was not compatible with the target environment");
    }

    @Nullable
    public static net.minecraft.item.ItemStack cloneDefensiveNative(@Nullable net.minecraft.item.ItemStack stack) {
        return net.minecraft.item.ItemStack.func_77944_b((net.minecraft.item.ItemStack)stack);
    }

    @Nullable
    public static net.minecraft.item.ItemStack cloneDefensiveNative(@Nullable net.minecraft.item.ItemStack stack, int newSize) {
        net.minecraft.item.ItemStack clone = net.minecraft.item.ItemStack.func_77944_b((net.minecraft.item.ItemStack)stack);
        if (clone != null) {
            clone.field_77994_a = newSize;
        }
        return clone;
    }

    @Nullable
    public static ItemStack cloneDefensive(@Nullable net.minecraft.item.ItemStack stack) {
        return (ItemStack)ItemStackUtil.cloneDefensiveNative(stack);
    }

    @Nullable
    public static ItemStack cloneDefensive(@Nullable ItemStack stack) {
        return ItemStackUtil.cloneDefensive(ItemStackUtil.toNative(stack));
    }

    @Nullable
    public static ItemStack cloneDefensive(net.minecraft.item.ItemStack stack, int newSize) {
        return (ItemStack)ItemStackUtil.cloneDefensiveNative(stack, newSize);
    }

    @Nullable
    public static ItemStack cloneDefensive(@Nullable ItemStack stack, int newSize) {
        return ItemStackUtil.cloneDefensive(ItemStackUtil.toNative(stack), newSize);
    }

    public static Optional<ItemStack> cloneDefensiveOptional(@Nullable net.minecraft.item.ItemStack stack) {
        return Optional.ofNullable(ItemStackUtil.cloneDefensive(stack));
    }

    public static Optional<ItemStack> cloneDefensiveOptional(@Nullable net.minecraft.item.ItemStack stack, int withdraw) {
        return Optional.ofNullable(ItemStackUtil.cloneDefensive(stack));
    }

    public static boolean compare(net.minecraft.item.ItemStack stack1, net.minecraft.item.ItemStack stack2) {
        return stack1.func_77969_a(stack2) && net.minecraft.item.ItemStack.func_77970_a((net.minecraft.item.ItemStack)stack1, (net.minecraft.item.ItemStack)stack2);
    }

    public static boolean compare(net.minecraft.item.ItemStack stack1, ItemStack stack2) {
        return ItemStackUtil.compare(stack1, ItemStackUtil.toNative(stack2));
    }

    public static boolean compare(ItemStack stack1, ItemStack stack2) {
        return ItemStackUtil.compare(ItemStackUtil.toNative(stack1), ItemStackUtil.toNative(stack2));
    }

    public static boolean compare(ItemStack stack1, net.minecraft.item.ItemStack stack2) {
        return ItemStackUtil.compare(ItemStackUtil.toNative(stack1), stack2);
    }

    public static ItemStackSnapshot createSnapshot(net.minecraft.item.ItemStack item) {
        return ItemStackUtil.fromNative(item).createSnapshot();
    }

    public static ItemStackSnapshot snapshotOf(@Nullable net.minecraft.item.ItemStack itemStack) {
        return itemStack == null ? ItemStackSnapshot.NONE : ItemStackUtil.fromNative(itemStack).createSnapshot();
    }

    public static ItemStackSnapshot snapshotOf(@Nullable ItemStack itemStack) {
        return itemStack == null ? ItemStackSnapshot.NONE : itemStack.createSnapshot();
    }

    @Nullable
    public static net.minecraft.item.ItemStack fromSnapshotToNative(@Nullable ItemStackSnapshot snapshot) {
        return snapshot == null ? null : (snapshot == ItemStackSnapshot.NONE ? null : ItemStackUtil.toNative(snapshot.createStack()));
    }

    @Nullable
    public static ItemStack fromSnapshot(@Nullable ItemStackSnapshot snapshot) {
        return snapshot == null ? null : (snapshot == ItemStackSnapshot.NONE ? null : snapshot.createStack());
    }
}

