/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.merchant;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.village.MerchantRecipe;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.merchant.TradeOffer;
import org.spongepowered.common.data.util.DataQueries;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

public class SpongeTradeOfferBuilder
extends AbstractDataBuilder<TradeOffer>
implements TradeOffer.Builder,
DataBuilder<TradeOffer> {
    private ItemStackSnapshot firstItem;
    private ItemStackSnapshot secondItem;
    private ItemStackSnapshot sellingItem;
    private int useCount;
    private int maxUses;
    private boolean allowsExperience;

    public SpongeTradeOfferBuilder() {
        super(TradeOffer.class, 1);
        this.reset();
    }

    @Override
    public TradeOffer.Builder firstBuyingItem(ItemStack item) {
        Preconditions.checkNotNull((Object)item, (Object)"Buying item cannot be null");
        this.firstItem = item.createSnapshot();
        return this;
    }

    @Override
    public TradeOffer.Builder secondBuyingItem(ItemStack item) {
        this.secondItem = item.createSnapshot();
        return this;
    }

    @Override
    public TradeOffer.Builder sellingItem(ItemStack item) {
        Preconditions.checkNotNull((Object)item, (Object)"Selling item cannot be null");
        this.sellingItem = item.createSnapshot();
        return this;
    }

    @Override
    public TradeOffer.Builder uses(int uses) {
        Preconditions.checkArgument((uses >= 0 ? 1 : 0) != 0, (Object)"Usage count cannot be negative");
        this.useCount = uses;
        return this;
    }

    @Override
    public TradeOffer.Builder maxUses(int maxUses) {
        Preconditions.checkArgument((maxUses > 0 ? 1 : 0) != 0, (Object)"Max usage count must be greater than 0");
        this.maxUses = maxUses;
        return this;
    }

    @Override
    public TradeOffer.Builder canGrantExperience(boolean experience) {
        this.allowsExperience = experience;
        return this;
    }

    @Override
    public TradeOffer build() throws IllegalStateException {
        Preconditions.checkState((this.firstItem != null ? 1 : 0) != 0, (Object)"Trading item has not been set");
        Preconditions.checkState((this.sellingItem != null ? 1 : 0) != 0, (Object)"Selling item has not been set");
        Preconditions.checkState((this.useCount <= this.maxUses ? 1 : 0) != 0, (String)"Usage count cannot be greater than the max usage count (%s)", (Object[])new Object[]{this.maxUses});
        ItemStack first = this.firstItem.createStack();
        ItemStack second = this.secondItem == null ? null : this.secondItem.createStack();
        ItemStack selling = this.sellingItem.createStack();
        MerchantRecipe recipe = new MerchantRecipe(ItemStackUtil.toNative(first), ItemStackUtil.toNative(second), ItemStackUtil.toNative(selling), this.useCount, this.maxUses);
        recipe.field_180323_f = this.allowsExperience;
        return (TradeOffer)recipe;
    }

    @Override
    public TradeOffer.Builder from(TradeOffer offer) {
        Preconditions.checkNotNull((Object)offer, (Object)"Trade offer cannot be null");
        this.firstItem = offer.getFirstBuyingItem();
        this.secondItem = offer.getSecondBuyingItem().orElse(null);
        this.sellingItem = offer.getSellingItem();
        this.useCount = offer.getUses();
        this.maxUses = offer.getMaxUses();
        this.allowsExperience = offer.doesGrantExperience();
        return this;
    }

    @Override
    public SpongeTradeOfferBuilder reset() {
        this.firstItem = null;
        this.secondItem = null;
        this.sellingItem = null;
        this.useCount = 0;
        this.maxUses = 7;
        this.allowsExperience = true;
        return this;
    }

    @Override
    protected Optional<TradeOffer> buildContent(DataView container) throws InvalidDataException {
        ItemStack secondItem;
        boolean secondPresent;
        if (!container.contains(DataQueries.FIRST_QUERY, DataQueries.SECOND_QUERY, DataQueries.EXPERIENCE_QUERY, DataQueries.MAX_QUERY, DataQueries.USES_QUERY, DataQueries.BUYING_QUERY)) {
            return Optional.empty();
        }
        ItemStack firstItem = container.getSerializable(DataQueries.FIRST_QUERY, ItemStack.class).get();
        ItemStack buyingItem = container.getSerializable(DataQueries.BUYING_QUERY, ItemStack.class).get();
        if (container.getString(DataQueries.SECOND_QUERY).isPresent() && container.getString(DataQueries.SECOND_QUERY).get().equals("none")) {
            secondPresent = false;
            secondItem = null;
        } else {
            secondPresent = true;
            secondItem = container.getSerializable(DataQueries.SECOND_QUERY, ItemStack.class).get();
        }
        SpongeTradeOfferBuilder builder = new SpongeTradeOfferBuilder();
        builder.firstBuyingItem(firstItem);
        if (secondPresent) {
            builder.secondBuyingItem(secondItem);
        }
        builder.sellingItem(buyingItem).maxUses(container.getInt(DataQueries.MAX_QUERY).get()).uses(container.getInt(DataQueries.USES_QUERY).get()).canGrantExperience(container.getBoolean(DataQueries.EXPERIENCE_QUERY).get());
        return Optional.of(builder.build());
    }
}

