/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.text.title;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketTitle;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.title.Title;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.interfaces.text.IMixinText;
import org.spongepowered.common.interfaces.text.IMixinTitle;

@Mixin(value={Title.class}, remap=false)
public abstract class MixinTitle
implements IMixinTitle {
    @Shadow
    @Final
    protected Optional<Text> title;
    @Shadow
    @Final
    protected Optional<Text> subtitle;
    @Shadow
    @Final
    protected Optional<Integer> fadeIn;
    @Shadow
    @Final
    protected Optional<Integer> stay;
    @Shadow
    @Final
    protected Optional<Integer> fadeOut;
    @Shadow
    @Final
    protected boolean clear;
    @Shadow
    @Final
    protected boolean reset;
    private List<SPacketTitle> packets;

    @Override
    public void send(EntityPlayerMP player) {
        for (SPacketTitle packet : this.getPackets()) {
            player.field_71135_a.func_147359_a((Packet)packet);
        }
    }

    private List<SPacketTitle> getPackets() {
        if (this.packets == null) {
            this.packets = new ArrayList<SPacketTitle>();
            if (this.clear) {
                this.packets.add(new SPacketTitle(SPacketTitle.Type.CLEAR, null));
            }
            if (this.reset) {
                this.packets.add(new SPacketTitle(SPacketTitle.Type.RESET, null));
            }
            if (this.fadeIn.isPresent() || this.stay.isPresent() || this.fadeOut.isPresent()) {
                this.packets.add(new SPacketTitle(this.fadeIn.orElse(20).intValue(), this.stay.orElse(60).intValue(), this.fadeOut.orElse(20).intValue()));
            }
            if (this.subtitle.isPresent()) {
                this.packets.add(new SPacketTitle(SPacketTitle.Type.SUBTITLE, ((IMixinText)((Object)this.subtitle.get())).toComponent()));
            }
            if (this.title.isPresent()) {
                this.packets.add(new SPacketTitle(SPacketTitle.Type.TITLE, ((IMixinText)((Object)this.title.get())).toComponent()));
            }
        }
        return this.packets;
    }
}

