/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import co.aikar.timings.SpongeTimings;
import co.aikar.timings.Timing;
import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockLog;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockAccess;
import org.spongepowered.api.block.BlockSoundGroup;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.trait.BlockTrait;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.event.entity.ConstructEntityEvent;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.event.tracking.CauseTracker;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.ItemDropData;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.interfaces.block.IMixinBlock;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.registry.type.BlockTypeRegistryModule;
import org.spongepowered.common.text.translation.SpongeTranslation;
import org.spongepowered.common.util.VecHelper;

@NonnullByDefault
@Mixin(value={Block.class}, priority=999)
@Implements(value={@Interface(iface=BlockType.class, prefix="block$")})
public abstract class MixinBlock
implements BlockType,
IMixinBlock {
    private final boolean isVanilla = this.getClass().getName().startsWith("net.minecraft.");
    private boolean hasCollideLogic;
    private boolean hasCollideWithStateLogic;
    private boolean requiresLocationCheckForLight;
    private boolean requiresLocationCheckForOpacity;
    private boolean requiresBlockCapture = true;
    private static boolean canCaptureItems = true;
    private Timing timing;
    @Shadow
    private boolean field_149789_z;
    @Shadow
    protected SoundType field_149762_H;

    @Shadow
    public abstract String func_149739_a();

    @Shadow
    public abstract Material func_149688_o(IBlockState var1);

    @Shadow
    public abstract IBlockState shadow$func_176223_P();

    @Shadow
    public abstract void func_176226_b(net.minecraft.world.World var1, BlockPos var2, IBlockState var3, int var4);

    @Inject(method="<init>*", at={@At(value="RETURN")})
    public void onConstruction(CallbackInfo ci) {
        Class<?> clazz;
        Class[] args2;
        Class<?> clazz2;
        Class[] argTypes;
        String mapping2;
        this.hasCollideLogic = true;
        this.hasCollideWithStateLogic = true;
        this.requiresLocationCheckForLight = true;
        this.requiresLocationCheckForOpacity = true;
        try {
            mapping2 = SpongeImplHooks.isDeobfuscatedEnvironment() ? "onEntityWalk" : "func_176199_a";
            argTypes = new Class[]{net.minecraft.world.World.class, BlockPos.class, Entity.class};
            clazz2 = this.getClass().getMethod(mapping2, argTypes).getDeclaringClass();
            if (clazz2.equals(Block.class)) {
                this.hasCollideLogic = false;
            }
        }
        catch (Throwable mapping2) {
            // empty catch block
        }
        try {
            mapping2 = SpongeImplHooks.isDeobfuscatedEnvironment() ? "onEntityCollidedWithBlock" : "func_180634_a";
            argTypes = new Class[]{net.minecraft.world.World.class, BlockPos.class, IBlockState.class, Entity.class};
            clazz2 = this.getClass().getMethod(mapping2, argTypes).getDeclaringClass();
            if (clazz2.equals(Block.class)) {
                this.hasCollideWithStateLogic = false;
            }
        }
        catch (Throwable mapping3) {
            // empty catch block
        }
        try {
            args2 = new Class[]{IBlockState.class, IBlockAccess.class, BlockPos.class};
            clazz = this.getClass().getMethod("getLightValue", args2).getDeclaringClass();
            if (clazz.equals(Block.class)) {
                this.requiresLocationCheckForLight = false;
            }
        }
        catch (Throwable args2) {
            // empty catch block
        }
        try {
            args2 = new Class[]{IBlockState.class, IBlockAccess.class, BlockPos.class};
            clazz = this.getClass().getMethod("getLightOpacity", args2).getDeclaringClass();
            if (clazz.equals(Block.class)) {
                this.requiresLocationCheckForOpacity = false;
            }
        }
        catch (Throwable args3) {
            // empty catch block
        }
        Block block = (Block)this;
        if (block instanceof BlockLeaves || block instanceof BlockLog || block instanceof BlockGrass || block instanceof BlockLiquid) {
            this.requiresBlockCapture = false;
        }
    }

    @Inject(method="registerBlock", at={@At(value="RETURN")})
    private static void onRegisterBlock(int id, ResourceLocation location, Block block, CallbackInfo ci) {
        BlockTypeRegistryModule.getInstance().registerFromGameData(location.toString(), (BlockType)block);
    }

    @Override
    public String getId() {
        return ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)((Block)this))).toString();
    }

    @Override
    public String getName() {
        return ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)((Block)this))).toString();
    }

    @Override
    public BlockState getDefaultState() {
        return (BlockState)this.shadow$func_176223_P();
    }

    @Override
    public Optional<ItemType> getItem() {
        return Optional.ofNullable((ItemType)Item.func_150898_a((Block)((Block)this)));
    }

    @Override
    public Translation getTranslation() {
        return new SpongeTranslation(this.func_149739_a() + ".name");
    }

    @Intrinsic
    public boolean block$getTickRandomly() {
        return this.getTickRandomly();
    }

    @Override
    public void setTickRandomly(boolean tickRandomly) {
        this.field_149789_z = tickRandomly;
    }

    @Override
    public boolean supports(Class<? extends ImmutableDataManipulator<?, ?>> immutable) {
        return false;
    }

    @Override
    public Optional<BlockState> getStateWithData(IBlockState blockState, ImmutableDataManipulator<?, ?> manipulator) {
        return Optional.empty();
    }

    @Override
    public <E> Optional<BlockState> getStateWithValue(IBlockState blockState, Key<? extends BaseValue<E>> key, E value) {
        return Optional.empty();
    }

    @Override
    public List<ImmutableDataManipulator<?, ?>> getManipulators(IBlockState blockState) {
        return ImmutableList.of();
    }

    @Override
    public BlockState getDefaultBlockState() {
        return this.getDefaultState();
    }

    @Override
    public Collection<BlockTrait<?>> getTraits() {
        return this.getDefaultBlockState().getTraits();
    }

    @Override
    public Optional<BlockTrait<?>> getTrait(String blockTrait) {
        return this.getDefaultBlockState().getTrait(blockTrait);
    }

    @Inject(method="harvestBlock", at={@At(value="HEAD")})
    public void onHarvestBlockHead(net.minecraft.world.World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack, CallbackInfo ci) {
        if (stack != null && SpongeImplHooks.isFakePlayer((Entity)player) && player.func_184614_ca() != null) {
            canCaptureItems = false;
        }
    }

    @Inject(method="harvestBlock", at={@At(value="RETURN")})
    public void onHarvestBlockReturn(net.minecraft.world.World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack, CallbackInfo ci) {
        canCaptureItems = true;
    }

    @Inject(method="spawnAsEntity", at={@At(value="NEW", args={"class=net/minecraft/entity/item/EntityItem"})}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void checkSpawnAsEntity(net.minecraft.world.World worldIn, BlockPos pos, ItemStack stack, CallbackInfo callbackInfo, float chance, double x, double y, double z) {
        Transform<World> position = new Transform<World>((World)worldIn, new Vector3d(x, y, z));
        ConstructEntityEvent.Pre eventPre = SpongeEventFactory.createConstructEntityEventPre(Cause.source(worldIn.func_180495_p(pos)).build(), EntityTypes.ITEM, position);
        SpongeImpl.postEvent(eventPre);
        if (eventPre.isCancelled()) {
            callbackInfo.cancel();
        }
    }

    @Inject(method="dropBlockAsItemWithChance", at={@At(value="HEAD")}, cancellable=true)
    public void onDropBlockAsItemWithChanceHead(net.minecraft.world.World worldIn, BlockPos pos, IBlockState state, float chance, int fortune, CallbackInfo ci) {
        if (!worldIn.field_72995_K && worldIn instanceof IMixinWorldServer) {
            boolean shouldEnterBlockDropPhase;
            if (CauseTracker.getInstance().getCurrentState() == BlockPhase.State.RESTORING_BLOCKS) {
                ci.cancel();
                return;
            }
            IMixinWorldServer mixinWorld = (IMixinWorldServer)worldIn;
            CauseTracker causeTracker = CauseTracker.getInstance();
            IPhaseState currentState = causeTracker.getCurrentState();
            boolean bl = shouldEnterBlockDropPhase = !currentState.getPhase().alreadyCapturingItemSpawns(currentState) && !currentState.getPhase().isWorldGeneration(currentState);
            if (shouldEnterBlockDropPhase) {
                PhaseContext context = PhaseContext.start().add(NamedCause.source(mixinWorld.createSpongeBlockSnapshot(state, state, pos, 4))).addBlockCaptures().addEntityCaptures();
                User notifier = causeTracker.getCurrentContext().getNotifier().orElse(null);
                User owner = causeTracker.getCurrentContext().getOwner().orElse(null);
                if (notifier != null) {
                    context.notifier(notifier);
                }
                if (owner != null) {
                    context.owner(owner);
                }
                context.complete();
                causeTracker.switchToPhase(BlockPhase.State.BLOCK_DROP_ITEMS, context);
            }
        }
    }

    @Inject(method="dropBlockAsItemWithChance", at={@At(value="RETURN")}, cancellable=true)
    public void onDropBlockAsItemWithChanceReturn(net.minecraft.world.World worldIn, BlockPos pos, IBlockState state, float chance, int fortune, CallbackInfo ci) {
        if (!worldIn.field_72995_K && worldIn instanceof IMixinWorldServer) {
            boolean shouldEnterBlockDropPhase;
            CauseTracker causeTracker = CauseTracker.getInstance();
            IPhaseState currentState = causeTracker.getCurrentState();
            boolean bl = shouldEnterBlockDropPhase = !currentState.getPhase().alreadyCapturingItemSpawns(currentState) && !currentState.getPhase().isWorldGeneration(currentState);
            if (shouldEnterBlockDropPhase) {
                causeTracker.completePhase(BlockPhase.State.BLOCK_DROP_ITEMS);
            }
        }
    }

    @Inject(method="spawnAsEntity", at={@At(value="HEAD")}, cancellable=true)
    private static void onSpawnAsEntity(net.minecraft.world.World worldIn, BlockPos pos, ItemStack stack, CallbackInfo ci) {
        if (!worldIn.field_72995_K && CauseTracker.getInstance().getCurrentState() == BlockPhase.State.RESTORING_BLOCKS) {
            ci.cancel();
        }
    }

    @Redirect(method="spawnAsEntity", at=@At(value="INVOKE", target="Lnet/minecraft/world/GameRules;getBoolean(Ljava/lang/String;)Z"))
    private static boolean redirectGameRulesToCaptureItemDrops(GameRules gameRules, String argument, net.minecraft.world.World worldIn, BlockPos pos, ItemStack stack) {
        if (stack == null) {
            return false;
        }
        boolean allowTileDrops = gameRules.func_82766_b(argument);
        if (allowTileDrops && worldIn instanceof IMixinWorldServer) {
            PhaseData currentPhase = CauseTracker.getInstance().getCurrentPhaseData();
            IPhaseState currentState = currentPhase.state;
            if (canCaptureItems && currentState.tracksBlockSpecificDrops()) {
                PhaseContext context = currentPhase.context;
                Multimap<BlockPos, ItemDropData> multimap = context.getCapturedBlockDrops();
                Collection itemStacks = multimap.get((Object)pos);
                SpongeImplHooks.addItemStackToListForSpawning(itemStacks, ItemDropData.item(stack).position(VecHelper.toVector3d(pos)).build());
                return false;
            }
        }
        return allowTileDrops;
    }

    @Override
    public boolean isVanilla() {
        return this.isVanilla;
    }

    @Override
    public boolean hasCollideLogic() {
        return this.hasCollideLogic;
    }

    @Override
    public boolean hasCollideWithStateLogic() {
        return this.hasCollideWithStateLogic;
    }

    @Override
    public Timing getTimingsHandler() {
        if (this.timing == null) {
            this.timing = SpongeTimings.getBlockTiming((Block)this);
        }
        return this.timing;
    }

    @Override
    public boolean requiresLocationCheckForLightValue() {
        return this.requiresLocationCheckForLight;
    }

    @Override
    public boolean requiresLocationCheckForOpacity() {
        return this.requiresLocationCheckForOpacity;
    }

    @Override
    public boolean requiresBlockCapture() {
        return this.requiresBlockCapture;
    }

    @Override
    public BlockSoundGroup getSoundGroup() {
        return (BlockSoundGroup)this.field_149762_H;
    }
}

