/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableDecayableData;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableTreeData;
import org.spongepowered.api.data.type.TreeType;
import org.spongepowered.api.data.type.TreeTypes;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeDecayableData;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeTreeData;
import org.spongepowered.common.data.util.TreeTypeResolver;
import org.spongepowered.common.event.tracking.CauseTracker;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.event.tracking.phase.TrackingPhases;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.mixin.core.block.MixinBlock;

@NonnullByDefault
@Mixin(value={BlockLeaves.class})
public abstract class MixinBlockLeaves
extends MixinBlock {
    @Inject(method="<init>", at={@At(value="RETURN")})
    public void onLeavesConstruction(CallbackInfo ci) {
        this.setTickRandomly(SpongeImpl.getGlobalConfig().getConfig().getWorld().getLeafDecay());
    }

    @Redirect(method="updateTick", at=@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;I)Z"))
    public boolean onUpdateDecayState(net.minecraft.world.World worldIn, BlockPos pos, IBlockState state, int flags) {
        IMixinWorldServer spongeWorld = (IMixinWorldServer)worldIn;
        CauseTracker causeTracker = CauseTracker.getInstance();
        boolean isBlockAlready = CauseTracker.ENABLED && causeTracker.getCurrentState().getPhase() != TrackingPhases.BLOCK;
        IPhaseState currentState = causeTracker.getCurrentPhaseData().state;
        boolean isWorldGen = currentState.getPhase().isWorldGeneration(currentState);
        if (isBlockAlready && !isWorldGen) {
            LocatableBlock locatable = LocatableBlock.builder().location(new Location<World>((World)worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())).state((BlockState)state).build();
            causeTracker.switchToPhase(BlockPhase.State.BLOCK_DECAY, PhaseContext.start().add(NamedCause.source(locatable)).addCaptures().complete());
        }
        boolean result = worldIn.func_180501_a(pos, state, flags);
        if (isBlockAlready && !isWorldGen) {
            causeTracker.completePhase(BlockPhase.State.BLOCK_DECAY);
        }
        return result;
    }

    @Overwrite
    private void func_176235_d(net.minecraft.world.World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (CauseTracker.ENABLED && !worldIn.field_72995_K) {
            boolean isBlockAlready;
            IMixinWorldServer mixinWorldServer = (IMixinWorldServer)worldIn;
            CauseTracker causeTracker = CauseTracker.getInstance();
            PhaseData peek = causeTracker.getCurrentPhaseData();
            IPhaseState currentState = peek.state;
            boolean isWorldGen = currentState.getPhase().isWorldGeneration(currentState);
            boolean bl = isBlockAlready = causeTracker.getCurrentState().getPhase() != TrackingPhases.BLOCK;
            if (isBlockAlready && !isWorldGen) {
                LocatableBlock locatable = LocatableBlock.builder().location(new Location<World>((World)worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())).state((BlockState)state).build();
                causeTracker.switchToPhase(BlockPhase.State.BLOCK_DECAY, PhaseContext.start().add(NamedCause.source(locatable)).addCaptures().complete());
            }
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
            if (isBlockAlready && !isWorldGen) {
                causeTracker.completePhase(BlockPhase.State.BLOCK_DECAY);
            }
            return;
        }
        this.func_176226_b(worldIn, pos, state, 0);
        worldIn.func_175698_g(pos);
    }

    protected ImmutableTreeData getTreeData(IBlockState blockState) {
        BlockPlanks.EnumType type = blockState.func_177230_c() instanceof BlockOldLeaf ? (BlockPlanks.EnumType)blockState.func_177229_b((IProperty)BlockOldLeaf.field_176239_P) : (blockState.func_177230_c() instanceof BlockNewLeaf ? (BlockPlanks.EnumType)blockState.func_177229_b((IProperty)BlockNewLeaf.field_176240_P) : BlockPlanks.EnumType.OAK);
        TreeType treeType = TreeTypeResolver.getFor(type);
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeTreeData.class, treeType);
    }

    private ImmutableDecayableData getIsDecayableFor(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeDecayableData.class, blockState.func_177229_b((IProperty)BlockLeaves.field_176237_a));
    }

    @Override
    public boolean supports(Class<? extends ImmutableDataManipulator<?, ?>> immutable) {
        return ImmutableTreeData.class.isAssignableFrom(immutable) || ImmutableDecayableData.class.isAssignableFrom(immutable);
    }

    @Override
    public Optional<BlockState> getStateWithData(IBlockState blockState, ImmutableDataManipulator<?, ?> manipulator) {
        if (manipulator instanceof ImmutableTreeData) {
            TreeType treeType = (TreeType)((ImmutableTreeData)manipulator).type().get();
            BlockPlanks.EnumType type = TreeTypeResolver.getFor(treeType);
            if (blockState.func_177230_c() instanceof BlockOldLeaf) {
                if (treeType.equals(TreeTypes.OAK) || treeType.equals(TreeTypes.BIRCH) || treeType.equals(TreeTypes.SPRUCE) || treeType.equals(TreeTypes.JUNGLE)) {
                    return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)type));
                }
            } else if (blockState.func_177230_c() instanceof BlockNewLeaf && (treeType.equals(TreeTypes.ACACIA) || treeType.equals(TreeTypes.DARK_OAK))) {
                return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockNewLeaf.field_176240_P, (Comparable)type));
            }
            return Optional.empty();
        }
        if (manipulator instanceof ImmutableDecayableData) {
            boolean decayable = (Boolean)((ImmutableDecayableData)manipulator).decayable().get();
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(decayable)));
        }
        return super.getStateWithData(blockState, manipulator);
    }

    @Override
    public <E> Optional<BlockState> getStateWithValue(IBlockState blockState, Key<? extends BaseValue<E>> key, E value) {
        if (key.equals(Keys.TREE_TYPE)) {
            TreeType treeType = (TreeType)value;
            BlockPlanks.EnumType type = TreeTypeResolver.getFor(treeType);
            if (blockState.func_177230_c() instanceof BlockOldLeaf) {
                if (treeType.equals(TreeTypes.OAK) || treeType.equals(TreeTypes.BIRCH) || treeType.equals(TreeTypes.SPRUCE) || treeType.equals(TreeTypes.JUNGLE)) {
                    return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)type));
                }
            } else if (blockState.func_177230_c() instanceof BlockNewLeaf && (treeType.equals(TreeTypes.ACACIA) || treeType.equals(TreeTypes.DARK_OAK))) {
                return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockNewLeaf.field_176240_P, (Comparable)type));
            }
            return Optional.empty();
        }
        if (key.equals(Keys.DECAYABLE)) {
            boolean decayable = (Boolean)value;
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(decayable)));
        }
        return super.getStateWithValue(blockState, key, value);
    }

    @Override
    public List<ImmutableDataManipulator<?, ?>> getManipulators(IBlockState blockState) {
        return ImmutableList.of((Object)this.getTreeData(blockState), (Object)this.getIsDecayableFor(blockState));
    }
}

