/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.command;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.item.EntityMinecartCommandBlock;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.rcon.RConConsoleSource;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityCommandBlock;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectCollection;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeInternalListeners;
import org.spongepowered.common.entity.player.SpongeUser;
import org.spongepowered.common.interfaces.IMixinCommandSource;
import org.spongepowered.common.interfaces.IMixinSubject;
import org.spongepowered.common.service.permission.SubjectSettingCallback;

@NonnullByDefault
@Mixin(value={EntityPlayerMP.class, TileEntityCommandBlock.class, EntityMinecartCommandBlock.class, MinecraftServer.class, RConConsoleSource.class, SpongeUser.class}, targets={"net/minecraft/tileentity/TileEntitySign$1"})
public abstract class MixinSubject
implements Subject,
IMixinCommandSource,
IMixinSubject {
    @Nullable
    private WeakReference<Subject> thisSubject;

    @Inject(method="<init>", at={@At(value="RETURN")}, remap=false)
    public void subjectConstructor(CallbackInfo ci) {
        if (SpongeImpl.isInitialized()) {
            SpongeInternalListeners.getInstance().registerExpirableServiceCallback(PermissionService.class, new SubjectSettingCallback(this));
        }
    }

    @Override
    public void setSubject(Subject subj) {
        this.thisSubject = new WeakReference<Subject>(subj);
    }

    @Nullable
    private Subject internalSubject() {
        Optional<PermissionService> serv;
        if ((this.thisSubject == null || this.thisSubject.get() == null) && (serv = SpongeImpl.getGame().getServiceManager().provide(PermissionService.class)).isPresent()) {
            new SubjectSettingCallback(this).test(serv.get());
        }
        return (Subject)this.thisSubject.get();
    }

    @Override
    public SubjectCollection getContainingCollection() {
        Subject subj = this.internalSubject();
        if (subj == null) {
            throw new IllegalStateException("No subject present for user " + this);
        }
        return subj.getContainingCollection();
    }

    @Override
    public SubjectData getSubjectData() {
        Subject subj = this.internalSubject();
        if (subj == null) {
            throw new IllegalStateException("No subject present for user " + this);
        }
        return subj.getSubjectData();
    }

    @Override
    public SubjectData getTransientSubjectData() {
        Subject subj = this.internalSubject();
        if (subj == null) {
            throw new IllegalStateException("No subject present for user " + this);
        }
        return subj.getTransientSubjectData();
    }

    @Override
    public boolean hasPermission(Set<Context> contexts, String permission) {
        Subject subj = this.internalSubject();
        if (subj == null) {
            return this.permDefault(permission).asBoolean();
        }
        Tristate ret = this.getPermissionValue(contexts, permission);
        switch (ret) {
            case UNDEFINED: {
                return this.permDefault(permission).asBoolean();
            }
        }
        return ret.asBoolean();
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.hasPermission(this.getActiveContexts(), permission);
    }

    @Override
    public Tristate getPermissionValue(Set<Context> contexts, String permission) {
        Subject subj = this.internalSubject();
        return subj == null ? this.permDefault(permission) : subj.getPermissionValue(contexts, permission);
    }

    @Override
    public boolean isChildOf(Subject parent) {
        Subject subj = this.internalSubject();
        return subj != null && subj.isChildOf(parent);
    }

    @Override
    public boolean isChildOf(Set<Context> contexts, Subject parent) {
        Subject subj = this.internalSubject();
        return subj != null && subj.isChildOf(contexts, parent);
    }

    @Override
    public List<Subject> getParents() {
        Subject subj = this.internalSubject();
        return subj == null ? Collections.emptyList() : subj.getParents();
    }

    @Override
    public List<Subject> getParents(Set<Context> contexts) {
        Subject subj = this.internalSubject();
        return subj == null ? Collections.emptyList() : subj.getParents(contexts);
    }

    @Override
    public Set<Context> getActiveContexts() {
        Subject subj = this.internalSubject();
        return subj == null ? Collections.emptySet() : subj.getActiveContexts();
    }

    @Override
    public Optional<String> getOption(Set<Context> contexts, String key) {
        Subject subj = this.internalSubject();
        return subj == null ? Optional.empty() : subj.getOption(contexts, key);
    }
}

