/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.data;

import co.aikar.timings.SpongeTimings;
import co.aikar.timings.TimingsManager;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.MemoryDataContainer;
import org.spongepowered.api.data.Property;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.DataManipulatorBuilder;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.data.DataProcessor;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.ValueProcessor;
import org.spongepowered.common.entity.player.SpongeUser;
import org.spongepowered.common.interfaces.data.IMixinCustomDataHolder;

@Mixin(value={TileEntity.class, Entity.class, ItemStack.class, SpongeUser.class}, priority=999)
public abstract class MixinDataHolder
implements DataHolder {
    @Override
    public <T extends DataManipulator<?, ?>> Optional<T> get(Class<T> containerClass) {
        TimingsManager.DATA_GROUP_HANDLER.startTimingIfSync();
        SpongeTimings.dataGetManipulator.startTimingIfSync();
        Optional<DataProcessor<?, ?>> optional = SpongeDataManager.getInstance().getWildProcessor(containerClass);
        if (optional.isPresent()) {
            Optional<?> from = optional.get().from(this);
            SpongeTimings.dataGetManipulator.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return from;
        }
        if (this instanceof IMixinCustomDataHolder) {
            Optional<T> custom = ((IMixinCustomDataHolder)((Object)this)).getCustom(containerClass);
            SpongeTimings.dataGetManipulator.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return custom;
        }
        SpongeTimings.dataGetManipulator.stopTimingIfSync();
        TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
        return Optional.empty();
    }

    @Override
    public <T extends DataManipulator<?, ?>> Optional<T> getOrCreate(Class<T> containerClass) {
        TimingsManager.DATA_GROUP_HANDLER.startTimingIfSync();
        SpongeTimings.dataGetOrCreateManipulator.startTimingIfSync();
        Optional<DataProcessor<?, ?>> optional = SpongeDataManager.getInstance().getWildProcessor(containerClass);
        if (optional.isPresent()) {
            Optional<?> created = optional.get().createFrom(this);
            SpongeTimings.dataGetOrCreateManipulator.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return created;
        }
        if (this instanceof IMixinCustomDataHolder) {
            Optional<T> custom = ((IMixinCustomDataHolder)((Object)this)).getCustom(containerClass);
            if (custom.isPresent()) {
                SpongeTimings.dataGetOrCreateManipulator.stopTimingIfSync();
                TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
                return custom;
            }
            Optional<DataManipulatorBuilder<?, ?>> builder = SpongeDataManager.getInstance().getWildManipulatorBuilder(containerClass);
            Preconditions.checkState((boolean)builder.isPresent(), (Object)("A DataManipulatorBuilder is not registered for the manipulator class: " + containerClass.getName()));
            Object manipulator = builder.get().create();
            Optional<DataManipulator> other = manipulator.fill(this).map(customManipulator -> customManipulator);
            SpongeTimings.dataGetOrCreateManipulator.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return other;
        }
        SpongeTimings.dataGetOrCreateManipulator.stopTimingIfSync();
        TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
        return Optional.empty();
    }

    @Override
    public boolean supports(Class<? extends DataManipulator<?, ?>> holderClass) {
        TimingsManager.DATA_GROUP_HANDLER.startTimingIfSync();
        SpongeTimings.dataSupportsManipulator.startTimingIfSync();
        Optional<DataProcessor<?, ?>> optional = SpongeDataManager.getInstance().getWildProcessor(holderClass);
        if (optional.isPresent()) {
            boolean supports = optional.get().supports(this);
            SpongeTimings.dataSupportsManipulator.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return supports;
        }
        if (this instanceof IMixinCustomDataHolder) {
            Optional<DataManipulator<?, ?>> custom = ((IMixinCustomDataHolder)((Object)this)).getCustom(holderClass);
            if (custom.isPresent()) {
                SpongeTimings.dataSupportsManipulator.stopTimingIfSync();
                TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
                return true;
            }
            Optional<DataManipulatorBuilder<?, ?>> builder = SpongeDataManager.getInstance().getWildManipulatorBuilder(holderClass);
            Preconditions.checkState((boolean)builder.isPresent(), (Object)("A DataManipulatorBuilder is not registered for the manipulator class: " + holderClass.getName()));
            Object manipulator = builder.get().create();
            boolean present = manipulator.fill(this).isPresent();
            SpongeTimings.dataSupportsManipulator.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return present;
        }
        SpongeTimings.dataSupportsManipulator.stopTimingIfSync();
        TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
        return false;
    }

    @Override
    public <E> DataTransactionResult offer(Key<? extends BaseValue<E>> key, E value) {
        TimingsManager.DATA_GROUP_HANDLER.startTimingIfSync();
        SpongeTimings.dataOfferKey.startTimingIfSync();
        Optional optional = SpongeDataManager.getInstance().getBaseValueProcessor(key);
        if (optional.isPresent()) {
            DataTransactionResult result = optional.get().offerToStore(this, value);
            SpongeTimings.dataOfferKey.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return result;
        }
        if (this instanceof IMixinCustomDataHolder) {
            DataTransactionResult result = ((IMixinCustomDataHolder)((Object)this)).offerCustom(key, value);
            SpongeTimings.dataOfferKey.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return result;
        }
        SpongeTimings.dataOfferKey.stopTimingIfSync();
        TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
        return DataTransactionResult.failNoData();
    }

    @Override
    public DataTransactionResult offer(DataManipulator<?, ?> valueContainer, MergeFunction function) {
        TimingsManager.DATA_GROUP_HANDLER.startTimingIfSync();
        SpongeTimings.dataOfferManipulator.startTimingIfSync();
        Optional<DataProcessor> optional = SpongeDataManager.getInstance().getWildDataProcessor(valueContainer.getClass());
        if (optional.isPresent()) {
            DataTransactionResult result = optional.get().set(this, valueContainer, (MergeFunction)Preconditions.checkNotNull((Object)function));
            SpongeTimings.dataOfferManipulator.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return result;
        }
        if (this instanceof IMixinCustomDataHolder) {
            DataTransactionResult result = ((IMixinCustomDataHolder)((Object)this)).offerCustom(valueContainer, function);
            SpongeTimings.dataOfferManipulator.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return result;
        }
        SpongeTimings.dataOfferManipulator.stopTimingIfSync();
        TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
        return DataTransactionResult.failResult(valueContainer.getValues());
    }

    @Override
    public DataTransactionResult offer(Iterable<DataManipulator<?, ?>> valueContainers) {
        TimingsManager.DATA_GROUP_HANDLER.startTimingIfSync();
        SpongeTimings.dataOfferMultiManipulators.startTimingIfSync();
        DataTransactionResult.Builder builder = DataTransactionResult.builder();
        for (DataManipulator<?, ?> manipulator : valueContainers) {
            DataTransactionResult result = this.offer(manipulator);
            if (!result.getRejectedData().isEmpty()) {
                builder.reject(result.getRejectedData());
            }
            if (!result.getReplacedData().isEmpty()) {
                builder.replace(result.getReplacedData());
            }
            if (!result.getSuccessfulData().isEmpty()) {
                builder.success(result.getSuccessfulData());
            }
            DataTransactionResult.Type type = result.getType();
            builder.result(type);
            switch (type) {
                case UNDEFINED: 
                case ERROR: 
                case CANCELLED: {
                    SpongeTimings.dataOfferMultiManipulators.stopTimingIfSync();
                    TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
                    return builder.build();
                }
            }
        }
        SpongeTimings.dataOfferMultiManipulators.stopTimingIfSync();
        TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
        return builder.build();
    }

    @Override
    public DataTransactionResult remove(Class<? extends DataManipulator<?, ?>> containerClass) {
        TimingsManager.DATA_GROUP_HANDLER.startTimingIfSync();
        SpongeTimings.dataRemoveManipulator.startTimingIfSync();
        Optional<DataProcessor<?, ?>> optional = SpongeDataManager.getInstance().getWildProcessor(containerClass);
        if (optional.isPresent()) {
            DataTransactionResult result = optional.get().remove(this);
            SpongeTimings.dataRemoveManipulator.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return result;
        }
        if (this instanceof IMixinCustomDataHolder) {
            DataTransactionResult result = ((IMixinCustomDataHolder)((Object)this)).removeCustom(containerClass);
            SpongeTimings.dataRemoveManipulator.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return result;
        }
        SpongeTimings.dataOfferMultiManipulators.stopTimingIfSync();
        TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
        return DataTransactionResult.failNoData();
    }

    @Override
    public DataTransactionResult remove(Key<?> key) {
        TimingsManager.DATA_GROUP_HANDLER.startTimingIfSync();
        SpongeTimings.dataRemoveKey.startTimingIfSync();
        Optional<ValueProcessor<?, ?>> optional = SpongeDataManager.getInstance().getWildValueProcessor((Key)Preconditions.checkNotNull(key));
        if (optional.isPresent()) {
            DataTransactionResult result = optional.get().removeFrom(this);
            SpongeTimings.dataRemoveKey.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return result;
        }
        if (this instanceof IMixinCustomDataHolder) {
            DataTransactionResult result = ((IMixinCustomDataHolder)((Object)this)).removeCustom(key);
            SpongeTimings.dataRemoveKey.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return result;
        }
        SpongeTimings.dataRemoveKey.stopTimingIfSync();
        TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
        return DataTransactionResult.failNoData();
    }

    @Override
    public DataTransactionResult undo(DataTransactionResult result) {
        SpongeTimings.dataOfferManipulator.startTimingIfSync();
        TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
        if (result.getReplacedData().isEmpty() && result.getSuccessfulData().isEmpty()) {
            SpongeTimings.dataOfferManipulator.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return DataTransactionResult.successNoData();
        }
        DataTransactionResult.Builder builder = DataTransactionResult.builder();
        for (ImmutableValue<?> replaced : result.getReplacedData()) {
            builder.absorbResult(this.offer(replaced));
        }
        for (ImmutableValue<?> successful : result.getSuccessfulData()) {
            builder.absorbResult(this.remove(successful));
        }
        SpongeTimings.dataOfferManipulator.stopTimingIfSync();
        TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
        return builder.build();
    }

    @Override
    public DataTransactionResult copyFrom(DataHolder that, MergeFunction function) {
        return this.offer(that.getContainers(), function);
    }

    @Override
    public <E> Optional<E> get(Key<? extends BaseValue<E>> key) {
        TimingsManager.DATA_GROUP_HANDLER.startTimingIfSync();
        SpongeTimings.dataGetByKey.startTimingIfSync();
        Optional optional = SpongeDataManager.getInstance().getBaseValueProcessor((Key)Preconditions.checkNotNull(key));
        if (optional.isPresent()) {
            Optional value = optional.get().getValueFromContainer(this);
            SpongeTimings.dataGetByKey.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return value;
        }
        if (this instanceof IMixinCustomDataHolder) {
            Optional custom = ((IMixinCustomDataHolder)((Object)this)).getCustom(key);
            SpongeTimings.dataGetByKey.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return custom;
        }
        SpongeTimings.dataGetByKey.stopTimingIfSync();
        TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
        return Optional.empty();
    }

    @Override
    public <E, V extends BaseValue<E>> Optional<V> getValue(Key<V> key) {
        TimingsManager.DATA_GROUP_HANDLER.startTimingIfSync();
        SpongeTimings.dataGetValue.startTimingIfSync();
        Optional optional = SpongeDataManager.getInstance().getValueProcessor((Key)Preconditions.checkNotNull(key));
        if (optional.isPresent()) {
            Optional value = optional.get().getApiValueFromContainer(this);
            SpongeTimings.dataGetValue.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return value;
        }
        if (this instanceof IMixinCustomDataHolder) {
            Optional<V> customValue = ((IMixinCustomDataHolder)((Object)this)).getCustomValue(key);
            SpongeTimings.dataGetValue.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return customValue;
        }
        SpongeTimings.dataGetValue.stopTimingIfSync();
        TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
        return Optional.empty();
    }

    @Override
    public boolean supports(Key<?> key) {
        TimingsManager.DATA_GROUP_HANDLER.startTimingIfSync();
        SpongeTimings.dataSupportsKey.startTimingIfSync();
        Optional<ValueProcessor<?, ?>> optional = SpongeDataManager.getInstance().getWildValueProcessor((Key)Preconditions.checkNotNull(key));
        if (optional.isPresent()) {
            boolean supports = optional.get().supports(this);
            SpongeTimings.dataSupportsKey.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return supports;
        }
        if (this instanceof IMixinCustomDataHolder) {
            boolean customSupport = ((IMixinCustomDataHolder)((Object)this)).supportsCustom(key);
            SpongeTimings.dataSupportsKey.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return customSupport;
        }
        SpongeTimings.dataSupportsKey.stopTimingIfSync();
        TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
        return false;
    }

    @Override
    public Set<Key<?>> getKeys() {
        return this.getContainers().stream().flatMap(container -> container.getKeys().stream()).collect(Collectors.toSet());
    }

    @Override
    public Set<ImmutableValue<?>> getValues() {
        return this.getContainers().stream().flatMap(container -> container.getValues().stream()).collect(Collectors.toSet());
    }

    @Override
    public boolean validateRawData(DataView container) {
        return false;
    }

    @Override
    public void setRawData(DataView container) throws InvalidDataException {
    }

    @Override
    public Collection<DataManipulator<?, ?>> getContainers() {
        return Collections.emptyList();
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        return new MemoryDataContainer();
    }

    @Override
    public <T extends Property<?, ?>> Optional<T> getProperty(Class<T> propertyClass) {
        return Optional.empty();
    }

    @Override
    public Collection<Property<?, ?>> getApplicableProperties() {
        return Collections.emptyList();
    }

    @Override
    public DataHolder copy() {
        return this;
    }
}

