/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.item;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import org.spongepowered.api.entity.EnderCrystal;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.interfaces.entity.explosive.IMixinExplosive;
import org.spongepowered.common.mixin.core.entity.MixinEntity;

@Mixin(value={EntityEnderCrystal.class})
public abstract class MixinEntityEnderCrystal
extends MixinEntity
implements EnderCrystal,
IMixinExplosive {
    private static final String TARGET_NEW_EXPLOSION = "Lnet/minecraft/world/World;createExplosion(Lnet/minecraft/entity/Entity;DDDFZ)Lnet/minecraft/world/Explosion;";
    private static final int DEFAULT_EXPLOSION_STRENGTH = 6;
    private Cause detonationCause;
    private int explosionStrength = 6;

    @Override
    public Optional<Integer> getExplosionRadius() {
        return Optional.of(this.explosionStrength);
    }

    @Override
    public void setExplosionRadius(Optional<Integer> radius) {
        this.explosionStrength = radius.orElse(6);
    }

    @Override
    public void detonate(Cause cause) {
        this.detonationCause = (Cause)Preconditions.checkNotNull((Object)cause, (Object)"cause");
        this.func_70106_y();
        this.onExplode(this.field_70170_p, null, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.explosionStrength, true);
    }

    @Inject(method="attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z", at={@At(value="INVOKE")})
    protected void onAttack(DamageSource damageSource, float amount, CallbackInfoReturnable<Boolean> ci) {
        this.detonationCause = Cause.source(damageSource).build();
    }

    @Redirect(method="attackEntityFrom", at=@At(value="INVOKE", target="Lnet/minecraft/world/World;createExplosion(Lnet/minecraft/entity/Entity;DDDFZ)Lnet/minecraft/world/Explosion;"))
    protected net.minecraft.world.Explosion onExplode(World worldObj, @Nullable Entity nil, double x, double y, double z, float strength, boolean smoking) {
        return this.detonate(this.detonationCause, Explosion.builder().location(new Location<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)worldObj, new Vector3d(x, y, z))).radius(this.explosionStrength).shouldPlaySmoke(smoking)).orElse(null);
    }
}

