/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.item;

import com.flowpowered.math.vector.Vector3d;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.api.entity.vehicle.minecart.Minecart;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.mixin.core.entity.MixinEntity;
import org.spongepowered.common.util.VectorSerializer;

@Mixin(value={EntityMinecart.class})
public abstract class MixinEntityMinecart
extends MixinEntity
implements Minecart {
    private static final double DEFAULT_AIRBORNE_MOD = (double)0.95f;
    private static final double DEFAULT_DERAILED_MOD = 0.5;
    private double maxSpeed = 0.4;
    private boolean slowWhenEmpty = true;
    private Vector3d airborneMod = new Vector3d((double)0.95f, (double)0.95f, (double)0.95f);
    private Vector3d derailedMod = new Vector3d(0.5, 0.5, 0.5);

    @Overwrite
    protected double func_174898_m() {
        return this.maxSpeed;
    }

    @ModifyConstant(method="moveDerailedMinecart", constant={@Constant(doubleValue=0.5, ordinal=0)})
    private double onDecelerateX(double defaultValue) {
        return this.derailedMod.getX();
    }

    @ModifyConstant(method="moveDerailedMinecart", constant={@Constant(doubleValue=0.5, ordinal=1)})
    private double onDecelerateY(double defaultValue) {
        return this.derailedMod.getY();
    }

    @ModifyConstant(method="moveDerailedMinecart", constant={@Constant(doubleValue=0.5, ordinal=2)})
    private double onDecelerateZ(double defaultValue) {
        return this.derailedMod.getZ();
    }

    @Redirect(method="applyDrag", at=@At(value="INVOKE", target="Lnet/minecraft/entity/item/EntityMinecart;isBeingRidden()Z"))
    private boolean onIsRidden(EntityMinecart self) {
        return !this.slowWhenEmpty || this.func_184207_aI();
    }

    @Override
    public double getSwiftness() {
        return this.maxSpeed;
    }

    @Override
    public void setSwiftness(double maxSpeed) {
        this.maxSpeed = maxSpeed;
    }

    @Override
    public double getPotentialMaxSpeed() {
        return this.func_174898_m();
    }

    @Override
    public boolean doesSlowWhenEmpty() {
        return this.slowWhenEmpty;
    }

    @Override
    public void setSlowWhenEmpty(boolean slowWhenEmpty) {
        this.slowWhenEmpty = slowWhenEmpty;
    }

    @Override
    public Vector3d getAirborneVelocityMod() {
        return this.airborneMod;
    }

    @Override
    public void setAirborneVelocityMod(Vector3d airborneMod) {
        this.airborneMod = airborneMod;
    }

    @Override
    public Vector3d getDerailedVelocityMod() {
        return this.derailedMod;
    }

    @Override
    public void setDerailedVelocityMod(Vector3d derailedVelocityMod) {
        this.derailedMod = derailedVelocityMod;
    }

    @Override
    public void readFromNbt(NBTTagCompound compound) {
        super.readFromNbt(compound);
        if (compound.func_74764_b("maxSpeed")) {
            this.maxSpeed = compound.func_74769_h("maxSpeed");
        }
        if (compound.func_74764_b("slowWhenEmpty")) {
            this.slowWhenEmpty = compound.func_74767_n("slowWhenEmpty");
        }
        if (compound.func_74764_b("airborneModifier")) {
            this.airborneMod = VectorSerializer.fromNbt(compound.func_74775_l("airborneModifier"));
        }
        if (compound.func_74764_b("derailedModifier")) {
            this.derailedMod = VectorSerializer.fromNbt(compound.func_74775_l("derailedModifier"));
        }
    }

    @Override
    public void writeToNbt(NBTTagCompound compound) {
        super.writeToNbt(compound);
        compound.func_74780_a("maxSpeed", this.maxSpeed);
        compound.func_74757_a("slowWhenEmpty", this.slowWhenEmpty);
        compound.func_74782_a("airborneModifier", (NBTBase)VectorSerializer.toNbt(this.airborneMod));
        compound.func_74782_a("derailedModifier", (NBTBase)VectorSerializer.toNbt(this.derailedMod));
    }
}

