/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.item;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecartTNT;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import org.spongepowered.api.entity.vehicle.minecart.TNTMinecart;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.interfaces.entity.explosive.IMixinFusedExplosive;
import org.spongepowered.common.mixin.core.entity.item.MixinEntityMinecart;

@Mixin(value={EntityMinecartTNT.class})
public abstract class MixinEntityMinecartTNT
extends MixinEntityMinecart
implements TNTMinecart,
IMixinFusedExplosive {
    private static final String TARGET_NEW_EXPLOSION = "Lnet/minecraft/world/World;createExplosion(Lnet/minecraft/entity/Entity;DDDFZ)Lnet/minecraft/world/Explosion;";
    @Shadow
    private int field_94106_a;
    @Nullable
    private Cause primeCause;
    @Nullable
    private Cause detonationCause;
    private Optional<Integer> explosionRadius = Optional.empty();
    private int fuseDuration = 80;
    private boolean detonationCancelled;

    @Shadow
    public abstract void func_94105_c();

    @Nullable
    private Cause getCause(@Nullable Cause type) {
        if (type != null) {
            return type;
        }
        if (this.primeCause != null) {
            return this.primeCause;
        }
        return null;
    }

    @Override
    public Optional<Integer> getExplosionRadius() {
        return this.explosionRadius;
    }

    @Override
    public void setExplosionRadius(Optional<Integer> radius) {
        this.explosionRadius = radius;
    }

    @Override
    public int getFuseDuration() {
        return this.fuseDuration;
    }

    @Override
    public void setFuseDuration(int fuseTicks) {
        this.fuseDuration = fuseTicks;
    }

    @Override
    public int getFuseTicksRemaining() {
        return this.field_94106_a;
    }

    @Override
    public void setFuseTicksRemaining(int fuseTicks) {
        this.field_94106_a = fuseTicks;
    }

    @Override
    public void prime(Cause cause) {
        Preconditions.checkState((!this.isPrimed() ? 1 : 0) != 0, (Object)"already primed");
        this.primeCause = (Cause)Preconditions.checkNotNull((Object)cause, (Object)"cause");
        this.func_94105_c();
    }

    @Override
    public void defuse(Cause cause) {
        Preconditions.checkState((boolean)this.isPrimed(), (Object)"not primed");
        if (this.shouldDefuse((Cause)Preconditions.checkNotNull((Object)cause, (Object)"cause"))) {
            this.setFuseTicksRemaining(-1);
            this.postDefuse(cause);
        }
    }

    @Override
    public boolean isPrimed() {
        return this.field_94106_a >= 0;
    }

    @Override
    public void detonate(Cause cause) {
        this.detonationCause = (Cause)Preconditions.checkNotNull((Object)cause, (Object)"cause");
        this.setFuseTicksRemaining(0);
    }

    @Inject(method="attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z", at={@At(value="INVOKE")})
    protected void onAttack(DamageSource damageSource, float amount, CallbackInfoReturnable<Boolean> ci) {
        this.detonationCause = Cause.source(damageSource).build();
    }

    @Inject(method="onActivatorRailPass(IIIZ)V", at={@At(value="INVOKE")})
    protected void onActivate(int x, int y, int z, boolean receivingPower, CallbackInfo ci) {
        if (receivingPower) {
            this.getWorld().getNotifier(x, y, z).ifPresent(notifier -> {
                this.primeCause = Cause.of(NamedCause.notifier(notifier));
            });
        }
    }

    @Inject(method="ignite", at={@At(value="INVOKE")}, cancellable=true)
    protected void preIgnite(CallbackInfo ci) {
        if (!this.shouldPrime(this.getCause(this.primeCause))) {
            this.setFuseTicksRemaining(-1);
            ci.cancel();
        }
    }

    @Inject(method="ignite", at={@At(value="RETURN")})
    protected void postIgnite(CallbackInfo ci) {
        this.setFuseTicksRemaining(this.fuseDuration);
        this.postPrime(this.getCause(this.primeCause));
    }

    @Redirect(method="explodeCart", at=@At(value="INVOKE", target="Lnet/minecraft/world/World;createExplosion(Lnet/minecraft/entity/Entity;DDDFZ)Lnet/minecraft/world/Explosion;"))
    protected net.minecraft.world.Explosion onExplode(World worldObj, Entity self, double x, double y, double z, float strength, boolean smoking) {
        return this.detonate(this.getCause(this.detonationCause), Explosion.builder().location(new Location<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)worldObj, new Vector3d(x, y, z))).sourceExplosive(this).radius(this.explosionRadius.isPresent() ? (float)this.explosionRadius.get().intValue() : strength).shouldPlaySmoke(smoking).shouldBreakBlocks(smoking)).orElseGet(() -> {
            this.detonationCancelled = true;
            return null;
        });
    }

    @Inject(method="explodeCart", at={@At(value="RETURN")})
    protected void postExplode(CallbackInfo ci) {
        if (this.detonationCancelled) {
            this.field_70128_L = false;
            this.detonationCancelled = false;
        }
    }
}

