/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.item;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.world.World;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.entity.explosive.PrimedTNT;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.interfaces.entity.IMixinEntityTNTPrimed;
import org.spongepowered.common.mixin.core.entity.MixinEntity;

@Mixin(value={EntityTNTPrimed.class})
public abstract class MixinEntityTNTPrimed
extends MixinEntity
implements PrimedTNT,
IMixinEntityTNTPrimed {
    private static final String TARGET_NEW_EXPLOSION = "Lnet/minecraft/world/World;createExplosion(Lnet/minecraft/entity/Entity;DDDFZ)Lnet/minecraft/world/Explosion;";
    private static final int DEFAULT_EXPLOSION_RADIUS = 4;
    private static final BlockType BLOCK_TYPE = BlockTypes.TNT;
    @Shadow
    private int field_70516_a;
    @Shadow
    @Nullable
    private EntityLivingBase field_94084_b;
    @Nullable
    private EntityLivingBase detonator;
    private Cause detonationCause;
    private int explosionRadius = 4;
    private int fuseDuration = 80;
    private boolean detonationCancelled;

    @Shadow
    private void func_70515_d() {
    }

    @Override
    public void setDetonator(EntityLivingBase detonator) {
        this.detonator = detonator;
    }

    @Override
    public Optional<Living> getDetonator() {
        return Optional.ofNullable((Living)this.detonator);
    }

    @Nullable
    private Cause getCause(@Nullable Cause type) {
        if (type != null) {
            return type;
        }
        if (this.detonator != null) {
            return Cause.of(NamedCause.of("Igniter", this.detonator));
        }
        if (this.field_94084_b != null) {
            return Cause.source(this.field_94084_b).build();
        }
        return null;
    }

    private void defuse() {
        this.func_70106_y();
        this.getWorld().setBlock((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, (BlockState)BlockState.builder().blockType(BLOCK_TYPE).build(), BlockChangeFlag.ALL, Cause.source(this).build());
    }

    @Override
    public Optional<Integer> getExplosionRadius() {
        return Optional.of(this.explosionRadius);
    }

    @Override
    public void setExplosionRadius(Optional<Integer> radius) {
        this.explosionRadius = radius.orElse(4);
    }

    @Override
    public int getFuseDuration() {
        return this.fuseDuration;
    }

    @Override
    public void setFuseDuration(int fuseTicks) {
        this.fuseDuration = fuseTicks;
    }

    @Override
    public int getFuseTicksRemaining() {
        return this.field_70516_a;
    }

    @Override
    public void setFuseTicksRemaining(int fuseTicks) {
        this.field_70516_a = fuseTicks;
    }

    @Override
    public void prime(Cause cause) {
        Preconditions.checkState((!this.isPrimed() ? 1 : 0) != 0, (Object)"already primed");
        Preconditions.checkState((boolean)this.field_70128_L, (Object)"tnt about to be primed");
        this.getWorld().spawnEntity(this, (Cause)Preconditions.checkNotNull((Object)cause, (Object)"cause"));
    }

    @Override
    public void defuse(Cause cause) {
        Preconditions.checkState((boolean)this.isPrimed(), (Object)"not primed");
        Preconditions.checkNotNull((Object)cause, (Object)"cause");
        if (this.shouldDefuse((Cause)Preconditions.checkNotNull((Object)cause, (Object)"cause"))) {
            this.defuse();
            this.postDefuse(cause);
        }
    }

    @Override
    public boolean isPrimed() {
        return this.field_70516_a > 0 && this.field_70516_a < this.fuseDuration && !this.field_70128_L;
    }

    @Override
    public void detonate(Cause cause) {
        this.detonationCause = (Cause)Preconditions.checkNotNull((Object)cause, (Object)"cause");
        this.func_70106_y();
        this.func_70515_d();
    }

    @Redirect(method="explode", at=@At(value="INVOKE", target="Lnet/minecraft/world/World;createExplosion(Lnet/minecraft/entity/Entity;DDDFZ)Lnet/minecraft/world/Explosion;"))
    protected net.minecraft.world.Explosion onExplode(World worldObj, Entity self, double x, double y, double z, float strength, boolean smoking) {
        return this.detonate(this.getCause(this.detonationCause), Explosion.builder().location(new Location<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)worldObj, new Vector3d(x, y, z))).sourceExplosive(this).radius(this.explosionRadius).shouldPlaySmoke(smoking).shouldBreakBlocks(smoking)).orElseGet(() -> {
            this.detonationCancelled = true;
            return null;
        });
    }

    @Inject(method="explode", at={@At(value="RETURN")})
    protected void postExplode(CallbackInfo ci) {
        if (this.detonationCancelled) {
            this.defuse();
            this.detonationCancelled = false;
        }
    }

    @Inject(method="onUpdate", at={@At(value="RETURN")})
    protected void onUpdate(CallbackInfo ci) {
        if (this.field_70516_a == this.fuseDuration - 1) {
            this.postPrime(this.getCause(null));
        }
    }
}

