/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.monster;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import org.spongepowered.api.entity.living.monster.Creeper;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.event.tracking.CauseTracker;
import org.spongepowered.common.event.tracking.phase.entity.EntityPhase;
import org.spongepowered.common.interfaces.entity.IMixinGriefer;
import org.spongepowered.common.interfaces.entity.explosive.IMixinFusedExplosive;
import org.spongepowered.common.mixin.core.entity.monster.MixinEntityMob;

@Mixin(value={EntityCreeper.class})
public abstract class MixinEntityCreeper
extends MixinEntityMob
implements Creeper,
IMixinFusedExplosive {
    private static final String TARGET_NEW_EXPLOSION = "Lnet/minecraft/world/World;createExplosion(Lnet/minecraft/entity/Entity;DDDFZ)Lnet/minecraft/world/Explosion;";
    private static final String TARGET_IGNITE = "Lnet/minecraft/entity/monster/EntityCreeper;ignite()V";
    private static final String TARGET_DAMAGE_ITEM = "Lnet/minecraft/item/ItemStack;damageItem(ILnet/minecraft/entity/EntityLivingBase;)V";
    private static final int DEFAULT_EXPLOSION_RADIUS = 3;
    private static final int STATE_IDLE = -1;
    private static final int STATE_PRIMED = 1;
    @Shadow
    private int field_70833_d;
    @Shadow
    private int field_82225_f;
    @Shadow
    private int field_82226_g;
    private Cause primeCause;
    private Cause detonationCause;
    private Cause defuseCause;
    private int fuseDuration = 30;
    private boolean interactPrimeCancelled;
    private boolean stateDirty;
    private boolean detonationCancelled;
    private boolean isCorrectlyOverridden;

    @Shadow
    public abstract void func_146079_cb();

    @Shadow
    public abstract int func_70832_p();

    @Shadow
    public abstract void func_70829_a(int var1);

    @Shadow
    private void func_146077_cc() {
    }

    @Inject(method="<init>", at={@At(value="RETURN")})
    private void onCreeperConstructedVerifyDeathCompletion(CallbackInfo callbackInfo) {
        this.isCorrectlyOverridden = ((EntityCreeper)this).getClass() == EntityCreeper.class;
    }

    @Inject(method="onDeath", at={@At(value="RETURN")})
    private void onDeath(DamageSource damageSource, CallbackInfo ci) {
        if (!this.field_70170_p.field_72995_K && this.tracksEntityDeaths) {
            CauseTracker.getInstance().completePhase(EntityPhase.State.DEATH);
            this.tracksEntityDeaths = false;
        }
    }

    @Override
    public boolean properlyOverridesOnDeathForCauseTrackerCompletion() {
        return this.isCorrectlyOverridden;
    }

    @Nullable
    private Cause getCause(@Nullable Cause type) {
        if (type != null) {
            return type;
        }
        if (this.func_70638_az() != null) {
            return Cause.source(this.func_70638_az()).build();
        }
        return null;
    }

    @Override
    public Optional<Integer> getExplosionRadius() {
        return Optional.of(this.field_82226_g);
    }

    @Override
    public void setExplosionRadius(Optional<Integer> radius) {
        this.field_82226_g = radius.orElse(3);
    }

    @Override
    public int getFuseDuration() {
        return this.fuseDuration;
    }

    @Override
    public void setFuseDuration(int fuseTicks) {
        this.fuseDuration = fuseTicks;
    }

    @Override
    public int getFuseTicksRemaining() {
        return this.field_82225_f - this.field_70833_d;
    }

    @Override
    public void setFuseTicksRemaining(int fuseTicks) {
        this.field_70833_d = 0;
        this.field_82225_f = fuseTicks;
    }

    @Override
    public void prime(Cause cause) {
        Preconditions.checkState((!this.isPrimed() ? 1 : 0) != 0, (Object)"already primed");
        this.primeCause = (Cause)Preconditions.checkNotNull((Object)cause, (Object)"cause");
        this.func_70829_a(1);
    }

    @Override
    public void defuse(Cause cause) {
        Preconditions.checkState((boolean)this.isPrimed(), (Object)"not primed");
        this.defuseCause = (Cause)Preconditions.checkNotNull((Object)cause, (Object)"cause");
        this.func_70829_a(-1);
    }

    @Override
    public boolean isPrimed() {
        return this.func_70832_p() == 1;
    }

    @Override
    public void detonate(Cause cause) {
        this.detonationCause = (Cause)Preconditions.checkNotNull((Object)cause, (Object)"cause");
        this.func_146077_cc();
    }

    @Inject(method="setCreeperState(I)V", at={@At(value="INVOKE")}, cancellable=true)
    protected void onStateChange(int state, CallbackInfo ci) {
        this.setFuseDuration(this.fuseDuration);
        if (!this.isPrimed() && state == 1 && !this.shouldPrime(this.getCause(this.primeCause))) {
            ci.cancel();
        } else if (this.isPrimed() && state == -1 && !this.shouldDefuse(this.getCause(this.defuseCause))) {
            ci.cancel();
        } else if (this.func_70832_p() != state) {
            this.stateDirty = true;
        }
    }

    @Inject(method="setCreeperState(I)V", at={@At(value="RETURN")})
    protected void postStateChange(int state, CallbackInfo ci) {
        if (this.stateDirty) {
            if (state == 1) {
                this.postPrime(this.getCause(this.primeCause));
            } else if (state == -1) {
                this.postDefuse(this.getCause(this.defuseCause));
            }
            this.stateDirty = false;
        }
    }

    @Redirect(method="explode", at=@At(value="INVOKE", target="Lnet/minecraft/world/World;createExplosion(Lnet/minecraft/entity/Entity;DDDFZ)Lnet/minecraft/world/Explosion;"))
    protected net.minecraft.world.Explosion onExplode(World worldObj, Entity self, double x, double y, double z, float strength, boolean smoking) {
        return this.detonate(this.getCause(this.detonationCause), Explosion.builder().location(new Location<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)worldObj, new Vector3d(x, y, z))).sourceExplosive(this).radius(strength).shouldPlaySmoke(smoking).shouldBreakBlocks(smoking && ((IMixinGriefer)((Object)this)).canGrief())).orElseGet(() -> {
            this.detonationCancelled = true;
            return null;
        });
    }

    @Inject(method="explode", at={@At(value="RETURN")})
    protected void postExplode(CallbackInfo ci) {
        if (this.detonationCancelled) {
            this.field_70128_L = false;
            this.detonationCancelled = false;
        }
    }

    @Redirect(method="processInteract", at=@At(value="INVOKE", target="Lnet/minecraft/entity/monster/EntityCreeper;ignite()V"))
    protected void onInteractIgnite(EntityCreeper self) {
        boolean bl = this.interactPrimeCancelled = !this.shouldPrime(this.primeCause);
        if (!this.interactPrimeCancelled) {
            this.func_146079_cb();
        }
    }

    @Redirect(method="processInteract", at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;damageItem(ILnet/minecraft/entity/EntityLivingBase;)V"))
    protected void onDamageFlintAndSteel(ItemStack fas, int amount, EntityLivingBase player) {
        if (!this.interactPrimeCancelled) {
            fas.func_77972_a(amount, player);
            this.detonationCause = this.primeCause = Cause.of(NamedCause.of("Igniter", player));
        }
        this.interactPrimeCancelled = false;
    }
}

