/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.passive;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.mutable.entity.OcelotData;
import org.spongepowered.api.data.type.OcelotType;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.entity.living.animal.Ocelot;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeOcelotData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeSittingData;
import org.spongepowered.common.data.util.DataConstants;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.entity.SpongeEntityConstants;
import org.spongepowered.common.mixin.core.entity.passive.MixinEntityTameable;
import org.spongepowered.common.text.translation.SpongeTranslation;

@Mixin(value={EntityOcelot.class})
public abstract class MixinEntityOcelot
extends MixinEntityTameable
implements Ocelot {
    @Shadow
    public abstract int func_70913_u();

    @Redirect(method="processInteract", at=@At(value="INVOKE", target="Ljava/util/Random;nextInt(I)I", ordinal=0, remap=false))
    public int onTame(Random rand, int bound, EntityPlayer player, EnumHand hand, net.minecraft.item.ItemStack stack) {
        int random = rand.nextInt(bound);
        if (random == 0) {
            ++stack.field_77994_a;
            if (!SpongeImpl.postEvent(SpongeEventFactory.createTameEntityEvent(Cause.of(NamedCause.source(player), NamedCause.of("UsedItem", ((ItemStack)stack).createSnapshot())), this))) {
                --stack.field_77994_a;
                return random;
            }
        }
        return 1;
    }

    @Inject(method="setupTamedAI", at={@At(value="HEAD")}, cancellable=true)
    public void onSetupTamedAi(CallbackInfo ci) {
        if (this.field_70170_p.field_72995_K) {
            ci.cancel();
        }
    }

    @Override
    public OcelotData getOcelotData() {
        return new SpongeOcelotData(SpongeEntityConstants.OCELOT_IDMAP.get(this.func_70913_u()));
    }

    @Override
    public Value<OcelotType> variant() {
        return new SpongeValue<OcelotType>(Keys.OCELOT_TYPE, DataConstants.Ocelot.DEFAULT_TYPE, SpongeEntityConstants.OCELOT_IDMAP.get(this.func_70913_u()));
    }

    @Override
    public void supplyVanillaManipulators(List<DataManipulator<?, ?>> manipulators) {
        super.supplyVanillaManipulators(manipulators);
        manipulators.add(new SpongeSittingData(this.shadow$func_70906_o()));
        manipulators.add(this.getOcelotData());
    }

    @Override
    public Translation getTranslation() {
        if (this.shadow$func_70909_n()) {
            return new SpongeTranslation("entity.Cat.name");
        }
        return super.getTranslation();
    }
}

