/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.player;

import com.flowpowered.math.vector.Vector3d;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.player.PlayerCapabilities;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryEnderChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.FoodStats;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.LockCode;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.event.cause.entity.damage.DamageModifier;
import org.spongepowered.api.event.cause.entity.damage.DamageTypes;
import org.spongepowered.api.event.cause.entity.damage.source.EntityDamageSource;
import org.spongepowered.api.event.entity.AttackEntityEvent;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.damage.DamageEventHandler;
import org.spongepowered.common.interfaces.ITargetedLocation;
import org.spongepowered.common.interfaces.entity.IMixinEntity;
import org.spongepowered.common.interfaces.entity.player.IMixinEntityPlayer;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.entity.MixinEntityLivingBase;
import org.spongepowered.common.registry.type.event.DamageSourceRegistryModule;
import org.spongepowered.common.text.serializer.LegacyTexts;
import org.spongepowered.common.util.VecHelper;

@Mixin(value={EntityPlayer.class})
public abstract class MixinEntityPlayer
extends MixinEntityLivingBase
implements IMixinEntityPlayer,
ITargetedLocation {
    private static final String WORLD_PLAY_SOUND_AT = "Lnet/minecraft/world/World;playSound(Lnet/minecraft/entity/player/EntityPlayer;DDDLnet/minecraft/util/SoundEvent;Lnet/minecraft/util/SoundCategory;FF)V";
    private static final String WORLD_SPAWN_ENTITY = "Lnet/minecraft/world/World;spawnEntityInWorld(Lnet/minecraft/entity/Entity;)Z";
    private static final String PLAYER_COLLIDE_ENTITY = "Lnet/minecraft/entity/Entity;onCollideWithPlayer(Lnet/minecraft/entity/player/EntityPlayer;)V";
    @Shadow
    public Container field_71069_bz;
    @Shadow
    public Container field_71070_bA;
    @Shadow
    public int field_71068_ca;
    @Shadow
    public int field_71067_cb;
    @Shadow
    public float field_71106_cc;
    @Shadow
    public PlayerCapabilities field_71075_bZ;
    @Shadow
    public InventoryPlayer field_71071_by;
    @Shadow
    private BlockPos field_71077_c;
    @Shadow
    private BlockPos field_71081_bT;
    @Shadow
    protected FoodStats field_71100_bB;
    @Shadow
    public InventoryEnderChest field_71078_a;
    private boolean affectsSpawning = true;
    private UUID collidingEntityUuid = null;
    private Vector3d targetedLocation;

    @Shadow
    public abstract boolean func_175146_a(LockCode var1);

    @Shadow
    public abstract boolean func_70608_bn();

    @Shadow
    public abstract boolean func_175149_v();

    @Shadow
    public abstract int func_71050_bK();

    @Shadow
    public abstract float func_70689_ay();

    @Shadow
    public abstract float func_184825_o(float var1);

    @Shadow
    public abstract void func_71023_q(int var1);

    @Shadow
    public abstract void func_71020_j(float var1);

    @Shadow
    public abstract void func_71064_a(StatBase var1, int var2);

    @Shadow
    public abstract void func_71029_a(StatBase var1);

    @Shadow
    public abstract void func_71009_b(Entity var1);

    @Shadow
    public abstract void func_71047_c(Entity var1);

    @Shadow
    public abstract void func_184821_cY();

    @Shadow
    public abstract void func_184810_cG();

    @Shadow
    public abstract void func_175145_a(StatBase var1);

    @Shadow
    public abstract void func_70999_a(boolean var1, boolean var2, boolean var3);

    @Shadow
    public abstract EntityItem func_71040_bB(boolean var1);

    @Shadow
    public abstract FoodStats func_71024_bL();

    @Shadow
    public abstract GameProfile func_146103_bH();

    @Shadow
    public abstract Scoreboard func_96123_co();

    @Shadow
    public abstract String func_70005_c_();

    @Shadow
    @Nullable
    public abstract Team func_96124_cp();

    @Inject(method="<init>(Lnet/minecraft/world/World;Lcom/mojang/authlib/GameProfile;)V", at={@At(value="RETURN")})
    public void construct(World worldIn, GameProfile gameProfileIn, CallbackInfo ci) {
        this.targetedLocation = VecHelper.toVector3d(worldIn.func_175694_M());
    }

    @Inject(method="getDisplayName", at={@At(value="RETURN")}, cancellable=true)
    public void onGetDisplayName(CallbackInfoReturnable<ITextComponent> ci) {
        ci.setReturnValue((ITextComponent)LegacyTexts.parseComponent((TextComponentString)ci.getReturnValue(), '\u00a7'));
    }

    @Inject(method="clonePlayer", at={@At(value="HEAD")})
    public void onClonePlayer(EntityPlayer oldPlayer, boolean respawnFromEnd, CallbackInfo ci) {
        IMixinEntity oldEntity = (IMixinEntity)oldPlayer;
        NBTTagCompound old = oldEntity.getEntityData();
        if (old.func_74764_b("SpongeData")) {
            this.getEntityData().func_74782_a("SpongeData", (NBTBase)old.func_74775_l("SpongeData"));
            this.readFromNbt(this.getSpongeData());
        }
    }

    private int xpAtLevel(int level) {
        if (level > 30) {
            return (int)(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
        }
        if (level > 15) {
            return (int)(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
        }
        return (int)(Math.pow(level, 2.0) + (double)(6 * level));
    }

    public int getExperienceSinceLevel() {
        return this.getTotalExperience() - this.xpAtLevel(this.getLevel());
    }

    public void setExperienceSinceLevel(int experience) {
        this.setTotalExperience(this.xpAtLevel(this.field_71068_ca) + experience);
    }

    public int getExperienceBetweenLevels() {
        return this.func_71050_bK();
    }

    public int getLevel() {
        return this.field_71068_ca;
    }

    public void setLevel(int level) {
        this.field_71068_ca = level;
    }

    public int getTotalExperience() {
        return this.field_71067_cb;
    }

    public void setTotalExperience(int exp) {
        this.field_71067_cb = exp;
    }

    public boolean isFlying() {
        return this.field_71075_bZ.field_75100_b;
    }

    public void setFlying(boolean flying) {
        this.field_71075_bZ.field_75100_b = flying;
    }

    @Override
    @Overwrite
    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        this.func_70105_a(0.2f, 0.2f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70181_x = 0.1f;
        if (this.func_70005_c_().equals("Notch")) {
            this.func_146097_a(new ItemStack(Items.field_151034_e, 1), true, false);
        }
        if (!this.field_70170_p.func_82736_K().func_82766_b("keepInventory") && !this.func_175149_v()) {
            this.field_71071_by.func_70436_m();
        }
        if (cause != null) {
            this.field_70159_w = -MathHelper.func_76134_b((float)((this.field_70739_aP + this.field_70177_z) * ((float)Math.PI / 180))) * 0.1f;
            this.field_70179_y = -MathHelper.func_76126_a((float)((this.field_70739_aP + this.field_70177_z) * ((float)Math.PI / 180))) * 0.1f;
        } else {
            this.field_70179_y = 0.0;
            this.field_70159_w = 0.0;
        }
        this.func_71029_a(StatList.field_188069_A);
        this.func_175145_a(StatList.field_188098_h);
    }

    @Redirect(method="onUpdate", at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayer;isPlayerSleeping()Z"))
    public boolean onIsPlayerSleeping(EntityPlayer self) {
        if (self.func_70608_bn()) {
            if (!this.field_70170_p.field_72995_K) {
                SpongeImpl.postEvent(SpongeEventFactory.createSleepingEventTick(Cause.of(NamedCause.source(this)), this.getWorld().createSnapshot(VecHelper.toVector3i(this.field_71081_bT)), this));
            }
            return true;
        }
        return false;
    }

    @Redirect(method="playSound", at=@At(value="INVOKE", target="Lnet/minecraft/world/World;playSound(Lnet/minecraft/entity/player/EntityPlayer;DDDLnet/minecraft/util/SoundEvent;Lnet/minecraft/util/SoundCategory;FF)V"))
    public void playSound(World world, EntityPlayer player, double d1, double d2, double d3, SoundEvent sound, SoundCategory category, float volume, float pitch) {
        if (!this.isVanished()) {
            this.field_70170_p.func_184148_a(player, d1, d2, d3, sound, category, volume, pitch);
        }
    }

    @Override
    public boolean affectsSpawning() {
        return this.affectsSpawning && !this.func_175149_v();
    }

    @Override
    public void setAffectsSpawning(boolean affectsSpawning) {
        this.affectsSpawning = affectsSpawning;
    }

    @Override
    public Vector3d getTargetedLocation() {
        return this.targetedLocation;
    }

    @Override
    public void setTargetedLocation(@Nullable Vector3d vec) {
        Vector3d vector3d = this.targetedLocation = vec != null ? vec : VecHelper.toVector3d(this.field_70170_p.func_175694_M());
        if (!(this instanceof EntityPlayerMP)) {
            this.field_70170_p.func_175652_B(VecHelper.toBlockPos(this.targetedLocation));
        }
    }

    @Overwrite
    @Nullable
    public EntityItem func_71019_a(@Nullable ItemStack itemStackIn, boolean unused) {
        return this.func_146097_a(itemStackIn, false, false);
    }

    @Nullable
    @Overwrite
    public EntityItem func_146097_a(@Nullable ItemStack droppedItem, boolean dropAround, boolean traceItem) {
        if (droppedItem == null || droppedItem.field_77994_a == 0 || droppedItem.func_77973_b() == null) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            double d0 = this.field_70163_u - (double)0.3f + (double)this.func_70047_e();
            EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, d0, this.field_70161_v, droppedItem);
            entityitem.func_174867_a(40);
            if (traceItem) {
                entityitem.func_145799_b(this.func_70005_c_());
            }
            if (dropAround) {
                float f = this.field_70146_Z.nextFloat() * 0.5f;
                float f1 = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                entityitem.field_70159_w = -MathHelper.func_76126_a((float)f1) * f;
                entityitem.field_70179_y = MathHelper.func_76134_b((float)f1) * f;
                entityitem.field_70181_x = 0.2f;
            } else {
                float f2 = 0.3f;
                entityitem.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(this.field_70125_A * ((float)Math.PI / 180))) * f2;
                entityitem.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(this.field_70125_A * ((float)Math.PI / 180))) * f2;
                entityitem.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A * ((float)Math.PI / 180))) * f2 + 0.1f;
                float f3 = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                f2 = 0.02f * this.field_70146_Z.nextFloat();
                entityitem.field_70159_w += Math.cos(f3) * (double)f2;
                entityitem.field_70181_x += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f);
                entityitem.field_70179_y += Math.sin(f3) * (double)f2;
            }
            ItemStack itemstack = this.func_184816_a(entityitem);
            if (traceItem) {
                if (itemstack != null) {
                    this.func_71064_a(StatList.func_188058_e((Item)itemstack.func_77973_b()), droppedItem.field_77994_a);
                }
                this.func_71029_a(StatList.field_75952_v);
            }
            return entityitem;
        }
        return EntityUtil.playerDropItem(this, droppedItem, dropAround, traceItem);
    }

    @Overwrite
    @Nullable
    public ItemStack func_184816_a(EntityItem p_184816_1_) {
        this.field_70170_p.func_72838_d((Entity)p_184816_1_);
        return p_184816_1_.func_92059_d();
    }

    @Redirect(method="collideWithPlayer", at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;onCollideWithPlayer(Lnet/minecraft/entity/player/EntityPlayer;)V"))
    public void onPlayerCollideEntity(Entity entity, EntityPlayer player) {
        this.collidingEntityUuid = entity.func_110124_au();
        entity.func_70100_b_(player);
        this.collidingEntityUuid = null;
    }

    @Override
    public UUID getCollidingEntityUuid() {
        return this.collidingEntityUuid;
    }

    @Inject(method="attackEntityFrom", cancellable=true, at={@At(value="HEAD")})
    public void onAttackEntityFrom(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (source == DamageSourceRegistryModule.IGNORED_DAMAGE_SOURCE) {
            if (this.func_70608_bn() && !this.field_70170_p.field_72995_K) {
                this.func_70999_a(true, true, false);
            }
            cir.setReturnValue(super.func_70097_a(source, amount));
        }
    }

    @Overwrite
    public void func_71059_n(Entity targetEntity) {
        if (!SpongeImplHooks.checkAttackEntity((EntityPlayer)this, targetEntity)) {
            return;
        }
        if (targetEntity.func_70075_an() && !targetEntity.func_85031_j((Entity)((EntityPlayer)this))) {
            double originalBaseDamage = this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            float damage = (float)originalBaseDamage;
            float enchantmentDamage = 0.0f;
            float attackStrength = this.func_184825_o(0.5f);
            ArrayList<Tuple<DamageModifier, Function<? super Double, Double>>> originalFunctions = new ArrayList<Tuple<DamageModifier, Function<? super Double, Double>>>();
            EnumCreatureAttribute creatureAttribute = targetEntity instanceof EntityLivingBase ? ((EntityLivingBase)targetEntity).func_70668_bt() : EnumCreatureAttribute.UNDEFINED;
            List<Tuple<DamageModifier, Function<? super Double, Double>>> enchantmentModifierFunctions = DamageEventHandler.createAttackEnchamntmentFunction(this.func_184614_ca(), creatureAttribute, attackStrength);
            List enchantmentModifiers = enchantmentModifierFunctions.stream().map(Tuple::getFirst).collect(Collectors.toList());
            enchantmentDamage = (float)enchantmentModifierFunctions.stream().map(Tuple::getSecond).mapToDouble(function -> (Double)function.apply(originalBaseDamage)).sum();
            originalFunctions.addAll(enchantmentModifierFunctions);
            originalFunctions.add(DamageEventHandler.provideCooldownAttackStrengthFunction((EntityPlayer)this, attackStrength));
            enchantmentDamage *= attackStrength;
            this.func_184821_cY();
            if ((damage *= 0.2f + attackStrength * attackStrength * 0.8f) > 0.0f || enchantmentDamage > 0.0f) {
                ItemStack itemstack;
                boolean isStrongAttack = attackStrength > 0.9f;
                boolean isSprintingAttack = false;
                boolean isCriticalAttack = false;
                boolean isSweapingAttack = false;
                int knockbackModifier = 0;
                knockbackModifier += EnchantmentHelper.func_77501_a((EntityLivingBase)((EntityPlayer)this));
                if (this.func_70051_ag() && isStrongAttack) {
                    ++knockbackModifier;
                    isSprintingAttack = true;
                }
                isCriticalAttack = isStrongAttack && this.field_70143_R > 0.0f && !this.field_70122_E && !this.func_70617_f_() && !this.func_70090_H() && !this.func_70644_a(MobEffects.field_76440_q) && !this.func_184218_aH() && targetEntity instanceof EntityLivingBase;
                boolean bl = isCriticalAttack = isCriticalAttack && !this.func_70051_ag();
                if (isCriticalAttack) {
                    originalFunctions.add(DamageEventHandler.provideCriticalAttackTuple((EntityPlayer)this));
                }
                double distanceWalkedDelta = this.field_70140_Q - this.field_70141_P;
                if (isStrongAttack && !isCriticalAttack && !isSprintingAttack && this.field_70122_E && distanceWalkedDelta < (double)this.func_70689_ay() && (itemstack = this.func_184586_b(EnumHand.MAIN_HAND)) != null && itemstack.func_77973_b() instanceof ItemSword) {
                    isSweapingAttack = true;
                }
                DamageSource damageSource = DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)this));
                Cause cause = Cause.source(damageSource).build();
                AttackEntityEvent event = SpongeEventFactory.createAttackEntityEvent(cause, originalFunctions, EntityUtil.fromNative(targetEntity), knockbackModifier, originalBaseDamage);
                SpongeImpl.postEvent(event);
                if (event.isCancelled()) {
                    return;
                }
                damage = (float)event.getFinalOutputDamage();
                knockbackModifier = event.getKnockbackModifier();
                enchantmentDamage = (float)enchantmentModifiers.stream().mapToDouble(event::getOutputDamage).sum();
                float targetOriginalHealth = 0.0f;
                boolean litEntityOnFire = false;
                int fireAspectModifier = EnchantmentHelper.func_90036_a((EntityLivingBase)((EntityPlayer)this));
                if (targetEntity instanceof EntityLivingBase) {
                    targetOriginalHealth = ((EntityLivingBase)targetEntity).func_110143_aJ();
                    if (fireAspectModifier > 0 && !targetEntity.func_70027_ad()) {
                        litEntityOnFire = true;
                        targetEntity.func_70015_d(1);
                    }
                }
                double targetMotionX = targetEntity.field_70159_w;
                double targetMotionY = targetEntity.field_70181_x;
                double targetMotionZ = targetEntity.field_70179_y;
                boolean attackSucceeded = targetEntity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)this)), damage);
                if (attackSucceeded) {
                    IEntityMultiPart ientitymultipart;
                    if (knockbackModifier > 0) {
                        if (targetEntity instanceof EntityLivingBase) {
                            ((EntityLivingBase)targetEntity).func_70653_a((Entity)((EntityPlayer)this), (float)knockbackModifier * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                        } else {
                            targetEntity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * (float)knockbackModifier * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * (float)knockbackModifier * 0.5f));
                        }
                        this.field_70159_w *= 0.6;
                        this.field_70179_y *= 0.6;
                        this.func_70031_b(false);
                    }
                    if (isSweapingAttack) {
                        for (EntityLivingBase entitylivingbase : this.field_70170_p.func_72872_a(EntityLivingBase.class, targetEntity.func_174813_aQ().func_72314_b(1.0, 0.25, 1.0))) {
                            if (entitylivingbase == (EntityPlayer)this || entitylivingbase == targetEntity || this.func_184191_r((Entity)entitylivingbase) || !(this.func_70068_e((Entity)entitylivingbase) < 9.0)) continue;
                            EntityDamageSource sweepingAttackSource = (EntityDamageSource)((EntityDamageSource.Builder)((EntityDamageSource.Builder)EntityDamageSource.builder().entity(this)).type(DamageTypes.SWEEPING_ATTACK)).build();
                            Cause sweapingCause = Cause.source(sweepingAttackSource).named("Weapon", ItemStackUtil.snapshotOf(this.func_184586_b(EnumHand.MAIN_HAND))).build();
                            AttackEntityEvent sweepingAttackEvent = SpongeEventFactory.createAttackEntityEvent(sweapingCause, new ArrayList(), EntityUtil.fromNative((Entity)entitylivingbase), 1, 1.0);
                            SpongeImpl.postEvent(sweepingAttackEvent);
                            if (sweepingAttackEvent.isCancelled()) continue;
                            entitylivingbase.func_70653_a((Entity)((EntityPlayer)this), (float)sweepingAttackEvent.getKnockbackModifier() * 0.4f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                            entitylivingbase.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)this)), (float)sweepingAttackEvent.getFinalOutputDamage());
                        }
                        this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187730_dW, this.func_184176_by(), 1.0f, 1.0f);
                        this.func_184810_cG();
                    }
                    if (targetEntity instanceof EntityPlayerMP && targetEntity.field_70133_I) {
                        ((EntityPlayerMP)targetEntity).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(targetEntity));
                        targetEntity.field_70133_I = false;
                        targetEntity.field_70159_w = targetMotionX;
                        targetEntity.field_70181_x = targetMotionY;
                        targetEntity.field_70179_y = targetMotionZ;
                    }
                    if (isCriticalAttack) {
                        this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187718_dS, this.func_184176_by(), 1.0f, 1.0f);
                        this.func_71009_b(targetEntity);
                    }
                    if (!isCriticalAttack && !isSweapingAttack) {
                        if (isStrongAttack) {
                            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187727_dV, this.func_184176_by(), 1.0f, 1.0f);
                        } else {
                            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187733_dX, this.func_184176_by(), 1.0f, 1.0f);
                        }
                    }
                    if (enchantmentDamage > 0.0f) {
                        this.func_71047_c(targetEntity);
                    }
                    if (!this.field_70170_p.field_72995_K && targetEntity instanceof EntityPlayer) {
                        ItemStack itemstack3;
                        EntityPlayer entityplayer = (EntityPlayer)targetEntity;
                        ItemStack itemstack2 = this.func_184614_ca();
                        ItemStack itemStack = itemstack3 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : null;
                        if (itemstack2 != null && itemstack3 != null && itemstack2.func_77973_b() instanceof ItemAxe && itemstack3.func_77973_b() == Items.field_185159_cQ) {
                            float f3 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)((EntityPlayer)this)) * 0.05f;
                            if (isSprintingAttack) {
                                f3 += 0.75f;
                            }
                            if (this.field_70146_Z.nextFloat() < f3) {
                                entityplayer.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                                this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                            }
                        }
                    }
                    if (damage >= 18.0f) {
                        this.func_71029_a((StatBase)AchievementList.field_187973_F);
                    }
                    this.func_130011_c(targetEntity);
                    if (targetEntity instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)targetEntity), (Entity)((EntityPlayer)this));
                    }
                    EnchantmentHelper.func_151385_b((EntityLivingBase)((EntityPlayer)this), (Entity)targetEntity);
                    ItemStack itemstack1 = this.func_184614_ca();
                    Entity entity = targetEntity;
                    if (targetEntity instanceof EntityDragonPart && (ientitymultipart = ((EntityDragonPart)targetEntity).field_70259_a) instanceof EntityLivingBase) {
                        entity = (EntityLivingBase)ientitymultipart;
                    }
                    if (itemstack1 != null && entity instanceof EntityLivingBase) {
                        itemstack1.func_77961_a((EntityLivingBase)entity, (EntityPlayer)this);
                        if (itemstack1.field_77994_a <= 0) {
                            this.func_184611_a(EnumHand.MAIN_HAND, null);
                        }
                    }
                    if (targetEntity instanceof EntityLivingBase) {
                        float f5 = targetOriginalHealth - ((EntityLivingBase)targetEntity).func_110143_aJ();
                        this.func_71064_a(StatList.field_188111_y, Math.round(f5 * 10.0f));
                        if (fireAspectModifier > 0) {
                            targetEntity.func_70015_d(fireAspectModifier * 4);
                        }
                        if (this.field_70170_p instanceof WorldServer && f5 > 2.0f) {
                            int k = (int)((double)f5 * 0.5);
                            ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.DAMAGE_INDICATOR, targetEntity.field_70165_t, targetEntity.field_70163_u + (double)(targetEntity.field_70131_O * 0.5f), targetEntity.field_70161_v, k, 0.1, 0.0, 0.1, 0.2, new int[0]);
                        }
                    }
                    this.func_71020_j(0.3f);
                } else {
                    this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187724_dU, this.func_184176_by(), 1.0f, 1.0f);
                    if (litEntityOnFire) {
                        targetEntity.func_70066_B();
                    }
                }
            }
        }
    }
}

