/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.projectile;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.RayTraceResult;
import org.spongepowered.api.entity.projectile.explosive.fireball.Fireball;
import org.spongepowered.api.entity.projectile.source.ProjectileSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.entity.projectile.ProjectileSourceSerializer;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.mixin.core.entity.MixinEntity;

@Mixin(value={EntityFireball.class})
public abstract class MixinEntityFireball
extends MixinEntity
implements Fireball {
    @Shadow
    public EntityLivingBase field_70235_a;
    private ProjectileSource projectileSource = null;

    @Shadow
    protected abstract void func_70227_a(RayTraceResult var1);

    @Override
    public ProjectileSource getShooter() {
        if (this.projectileSource == null || this.projectileSource != this.field_70235_a) {
            this.projectileSource = this.field_70235_a != null && this.field_70235_a instanceof ProjectileSource ? (ProjectileSource)this.field_70235_a : ProjectileSource.UNKNOWN;
        }
        return this.projectileSource;
    }

    @Override
    public void setShooter(ProjectileSource shooter) {
        this.projectileSource = shooter;
        this.field_70235_a = shooter instanceof EntityLivingBase ? (EntityLivingBase)shooter : null;
    }

    @Override
    public void readFromNbt(NBTTagCompound compound) {
        super.readFromNbt(compound);
        ProjectileSourceSerializer.readSourceFromNbt(compound, this);
    }

    @Override
    public void writeToNbt(NBTTagCompound compound) {
        super.writeToNbt(compound);
        ProjectileSourceSerializer.writeSourceToNbt(compound, this.getShooter(), (Entity)this.field_70235_a);
    }

    @Redirect(method="onUpdate", at=@At(value="INVOKE", target="Lnet/minecraft/entity/projectile/EntityFireball;onImpact(Lnet/minecraft/util/math/RayTraceResult;)V"))
    public void onProjectileImpact(EntityFireball projectile, RayTraceResult movingObjectPosition) {
        if (this.field_70170_p.field_72995_K || movingObjectPosition.field_72313_a == RayTraceResult.Type.MISS) {
            this.func_70227_a(movingObjectPosition);
            return;
        }
        if (!SpongeCommonEventFactory.handleCollideImpactEvent((Entity)projectile, this.getShooter(), movingObjectPosition)) {
            this.func_70227_a(movingObjectPosition);
        }
    }
}

