/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.projectile;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableList;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.projectile.FishHook;
import org.spongepowered.api.entity.projectile.source.ProjectileSource;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.action.FishingEvent;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.projectile.ProjectileSourceSerializer;
import org.spongepowered.common.mixin.core.entity.MixinEntity;

@Mixin(value={EntityFishHook.class})
public abstract class MixinEntityFishHook
extends MixinEntity
implements FishHook {
    @Shadow
    private boolean field_146051_au;
    @Shadow
    private EntityPlayer field_146042_b;
    @Shadow
    public Entity field_146043_c;
    @Shadow
    private int field_146045_ax;
    @Nullable
    public ProjectileSource projectileSource;
    private double damageAmount;
    private net.minecraft.item.ItemStack fishingRod;

    @Shadow
    protected abstract void func_184527_k();

    @Override
    public ProjectileSource getShooter() {
        if (this.projectileSource != null) {
            return this.projectileSource;
        }
        if (this.field_146042_b != null && this.field_146042_b instanceof ProjectileSource) {
            return (ProjectileSource)this.field_146042_b;
        }
        return ProjectileSource.UNKNOWN;
    }

    @Override
    public void setShooter(ProjectileSource shooter) {
        this.field_146042_b = shooter instanceof EntityPlayer ? (EntityPlayer)shooter : null;
        this.projectileSource = shooter;
    }

    @Inject(method="notifyDataManagerChange", at={@At(value="HEAD")}, cancellable=true)
    public void onDataChange(DataParameter<?> param, CallbackInfo ci) {
        if (!this.field_70170_p.field_72995_K) {
            super.func_184206_a(param);
            ci.cancel();
        }
    }

    @Override
    public Optional<org.spongepowered.api.entity.Entity> getHookedEntity() {
        return Optional.ofNullable((org.spongepowered.api.entity.Entity)this.field_146043_c);
    }

    @Override
    public void setHookedEntity(@Nullable org.spongepowered.api.entity.Entity entity) {
        this.field_146043_c = (Entity)entity;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Overwrite
    public int func_146034_e() {
        if (this.field_70170_p.field_72995_K) {
            return 0;
        }
        int i = 0;
        if (this.field_146043_c != null) {
            if (SpongeImpl.postEvent(SpongeEventFactory.createFishingEventStop(Cause.of(NamedCause.source(this.field_146042_b)), 0, 0, this.createSnapshot(), this, Lists.newArrayList((Object[])new Transaction[]{new Transaction<ItemStackSnapshot>(ItemStackSnapshot.NONE, ItemStackSnapshot.NONE)}), (Player)this.field_146042_b))) return 0;
            this.func_184527_k();
            this.field_70170_p.func_72960_a((Entity)((EntityFishHook)this), (byte)31);
            i = this.field_146043_c instanceof EntityItem ? 3 : 5;
        } else if (this.field_146045_ax > 0) {
            LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)this.field_70170_p);
            lootcontext$builder.func_186469_a((float)EnchantmentHelper.func_151386_g((EntityLivingBase)this.field_146042_b) + this.field_146042_b.func_184817_da());
            List itemstacks = this.field_70170_p.func_184146_ak().func_186521_a(LootTableList.field_186387_al).func_186462_a(this.field_70146_Z, lootcontext$builder.func_186471_a());
            FishingEvent.Stop event = SpongeEventFactory.createFishingEventStop(Cause.of(NamedCause.source(this.field_146042_b)), 0, 0, this.createSnapshot(), this, itemstacks.stream().map(s -> {
                ItemStackSnapshot snapshot = ((ItemStack)s).createSnapshot();
                return new Transaction<ItemStackSnapshot>(snapshot, snapshot);
            }).collect(Collectors.toList()), (Player)this.field_146042_b);
            if (SpongeImpl.postEvent(event)) return 0;
            for (net.minecraft.item.ItemStack itemstack : event.getItemStackTransaction().stream().filter(Transaction::isValid).map(t -> (net.minecraft.item.ItemStack)((ItemStackSnapshot)t.getFinal()).createStack()).collect(Collectors.toList())) {
                EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, itemstack);
                double d0 = this.field_146042_b.field_70165_t - this.field_70165_t;
                double d1 = this.field_146042_b.field_70163_u - this.field_70163_u;
                double d2 = this.field_146042_b.field_70161_v - this.field_70161_v;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                double d4 = 0.1;
                entityitem.field_70159_w = d0 * d4;
                entityitem.field_70181_x = d1 * d4 + (double)MathHelper.func_76133_a((double)d3) * 0.08;
                entityitem.field_70179_y = d2 * d4;
                this.field_70170_p.func_72838_d((Entity)entityitem);
                this.field_146042_b.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_146042_b.field_70170_p, this.field_146042_b.field_70165_t, this.field_146042_b.field_70163_u + 0.5, this.field_146042_b.field_70161_v + 0.5, this.field_70146_Z.nextInt(6) + 1));
            }
            i = 1;
            if (this.field_146051_au) {
                i = 2;
            }
        } else if (SpongeImpl.postEvent(SpongeEventFactory.createFishingEventStop(Cause.of(NamedCause.source(this.field_146042_b)), 0, 0, this.createSnapshot(), this, Lists.newArrayList(), (Player)this.field_146042_b))) {
            return 0;
        }
        this.func_70106_y();
        this.field_146042_b.field_71104_cf = null;
        return i;
    }

    @Override
    public void readFromNbt(NBTTagCompound compound) {
        super.readFromNbt(compound);
        ProjectileSourceSerializer.readSourceFromNbt(compound, this);
    }

    @Override
    public void writeToNbt(NBTTagCompound compound) {
        super.writeToNbt(compound);
        ProjectileSourceSerializer.writeSourceToNbt(compound, this.getShooter(), (Entity)this.field_146042_b);
    }
}

