/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.item;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.MemoryDataContainer;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.data.util.DataQueries;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.data.util.NbtDataUtil;
import org.spongepowered.common.event.tracking.CauseTracker;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.interfaces.data.IMixinCustomDataHolder;
import org.spongepowered.common.interfaces.item.IMixinItem;
import org.spongepowered.common.interfaces.item.IMixinItemStack;
import org.spongepowered.common.item.inventory.SpongeItemStackSnapshot;
import org.spongepowered.common.registry.type.ItemTypeRegistryModule;
import org.spongepowered.common.text.translation.SpongeTranslation;

@Mixin(value={net.minecraft.item.ItemStack.class})
public abstract class MixinItemStack
implements ItemStack,
IMixinItemStack,
IMixinCustomDataHolder {
    @Shadow
    public int field_77994_a;
    private List<DataManipulator<?, ?>> manipulators = Lists.newArrayList();

    @Shadow
    public abstract void func_77964_b(int var1);

    @Shadow
    public abstract void func_77982_d(NBTTagCompound var1);

    @Shadow
    public abstract void func_77983_a(String var1, NBTBase var2);

    @Shadow
    public abstract int func_77952_i();

    @Shadow
    public abstract int func_77976_d();

    @Shadow
    public abstract boolean func_77942_o();

    @Shadow
    public abstract NBTTagCompound func_77978_p();

    @Shadow
    public abstract NBTTagCompound func_179543_a(String var1, boolean var2);

    @Shadow
    public abstract net.minecraft.item.ItemStack shadow$func_77946_l();

    @Shadow
    @Nullable
    public abstract Item shadow$func_77973_b();

    @Inject(method="writeToNBT", at={@At(value="HEAD")})
    private void onWrite(NBTTagCompound incoming, CallbackInfoReturnable<NBTTagCompound> info) {
        if (this.hasManipulators()) {
            this.writeToNbt(incoming);
        }
    }

    @Inject(method="readFromNBT", at={@At(value="RETURN")})
    private void onRead(NBTTagCompound compound, CallbackInfo info) {
        if (this.func_77942_o() && this.func_77978_p().func_150297_b("SpongeData", 10)) {
            this.readFromNbt(this.func_77978_p().func_74775_l("SpongeData"));
        }
    }

    @Inject(method="copy", at={@At(value="RETURN")})
    private void onCopy(CallbackInfoReturnable<net.minecraft.item.ItemStack> info) {
        net.minecraft.item.ItemStack itemStack = info.getReturnValue();
        if (this.hasManipulators()) {
            for (DataManipulator<?, ?> manipulator : this.manipulators) {
                ((IMixinCustomDataHolder)itemStack).offerCustom((DataManipulator<?, ?>)manipulator.copy(), MergeFunction.IGNORE_ALL);
            }
        }
    }

    @Inject(method="splitStack", at={@At(value="RETURN")})
    private void onSplit(int amount, CallbackInfoReturnable<net.minecraft.item.ItemStack> info) {
        net.minecraft.item.ItemStack itemStack = info.getReturnValue();
        if (this.hasManipulators()) {
            for (DataManipulator<?, ?> manipulator : this.manipulators) {
                ((IMixinCustomDataHolder)itemStack).offerCustom((DataManipulator<?, ?>)manipulator.copy(), MergeFunction.IGNORE_ALL);
            }
        }
    }

    @Inject(method="setTagCompound", at={@At(value="RETURN")})
    private void onSet(NBTTagCompound compound, CallbackInfo callbackInfo) {
        if (this.func_77942_o() && this.func_77978_p().func_150297_b("SpongeData", 10)) {
            this.readFromNbt(this.func_77978_p().func_74775_l("SpongeData"));
        }
    }

    @Inject(method="onBlockDestroyed", at={@At(value="HEAD")})
    private void capturePlayerOnBlockDestroyed(World worldIn, IBlockState blockIn, BlockPos pos, EntityPlayer playerIn, CallbackInfo ci) {
        if (!worldIn.field_72995_K) {
            CauseTracker causeTracker = CauseTracker.getInstance();
            PhaseData peek = causeTracker.getCurrentPhaseData();
            IPhaseState state = peek.state;
            state.getPhase().capturePlayerUsingStackToBreakBlock(this, (EntityPlayerMP)playerIn, state, peek.context, causeTracker);
        }
    }

    @Override
    public ItemType getItem() {
        Item item = this.shadow$func_77973_b();
        return item == null ? (ItemType)ItemTypeRegistryModule.NONE_ITEM : (ItemType)item;
    }

    @Override
    public int getQuantity() {
        return this.field_77994_a;
    }

    @Override
    public void setQuantity(int quantity) throws IllegalArgumentException {
        if (quantity > this.getMaxStackQuantity()) {
            throw new IllegalArgumentException("Quantity (" + quantity + ") exceeded the maximum stack size (" + this.getMaxStackQuantity() + ")");
        }
        this.field_77994_a = quantity;
    }

    @Override
    public int getMaxStackQuantity() {
        return this.func_77976_d();
    }

    @Override
    public boolean validateRawData(DataView container) {
        return false;
    }

    @Override
    public void setRawData(DataView container) throws InvalidDataException {
    }

    @Override
    public ItemStack copy() {
        return (ItemStack)this.shadow$func_77946_l();
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        Collection<DataManipulator<?, ?>> manipulators;
        DataContainer container = new MemoryDataContainer().set(Queries.CONTENT_VERSION, (Object)this.getContentVersion()).set(DataQueries.ITEM_TYPE, (Object)this.getItem().getId()).set(DataQueries.ITEM_COUNT, (Object)this.getQuantity()).set(DataQueries.ITEM_DAMAGE_VALUE, (Object)this.func_77952_i());
        if (this.func_77942_o()) {
            NBTTagCompound spongeCompound;
            NBTTagCompound compound = this.func_77978_p().func_74737_b();
            if (compound.func_74764_b("SpongeData") && (spongeCompound = compound.func_74775_l("SpongeData")).func_74764_b("CustomManipulators")) {
                spongeCompound.func_82580_o("CustomManipulators");
            }
            NbtDataUtil.filterSpongeCustomData(compound);
            if (!compound.func_82582_d()) {
                DataContainer unsafeNbt = NbtTranslator.getInstance().translateFrom(compound);
                container.set(DataQueries.UNSAFE_NBT, (Object)unsafeNbt);
            }
        }
        if (!(manipulators = this.getContainers()).isEmpty()) {
            container.set(DataQueries.DATA_MANIPULATORS, DataUtil.getSerializedManipulatorList(manipulators));
        }
        return container;
    }

    @Override
    public Translation getTranslation() {
        return new SpongeTranslation(this.shadow$func_77973_b().func_77667_c((net.minecraft.item.ItemStack)this) + ".name");
    }

    @Override
    public ItemStackSnapshot createSnapshot() {
        return new SpongeItemStackSnapshot(this);
    }

    @Override
    public boolean equalTo(ItemStack that) {
        return net.minecraft.item.ItemStack.func_77989_b((net.minecraft.item.ItemStack)((net.minecraft.item.ItemStack)this), (net.minecraft.item.ItemStack)((net.minecraft.item.ItemStack)that));
    }

    @Override
    public Collection<DataManipulator<?, ?>> getContainers() {
        ArrayList manipulators = Lists.newArrayList();
        Item item = this.shadow$func_77973_b();
        if (item == null) {
            PrettyPrinter printer = new PrettyPrinter(60);
            printer.add("Null Item found!").centre().hr();
            printer.add("An ItemStack has a null ItemType! This is usually not supported as it will likely have issues elsewhere.");
            printer.add("Please ask help for seeing if this is an issue with a mod and report it!");
            printer.add("Printing a Stacktrace:");
            printer.add(new Exception());
            printer.log(SpongeImpl.getLogger(), Level.WARN);
            return manipulators;
        }
        ((IMixinItem)item).getManipulatorsFor((net.minecraft.item.ItemStack)this, manipulators);
        if (this.hasManipulators()) {
            List<DataManipulator<?, ?>> customManipulators = this.getCustomManipulators();
            manipulators.addAll(customManipulators);
        }
        return manipulators;
    }

    @Override
    public void readFromNbt(NBTTagCompound compound) {
        if (compound.func_150297_b("CustomManipulators", 9)) {
            NBTTagList list = compound.func_150295_c("CustomManipulators", 10);
            if (!list.func_82582_d()) {
                compound.func_82580_o("CustomManipulators");
                ArrayList views = Lists.newArrayList();
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    NBTTagCompound dataCompound = list.func_150305_b(i);
                    views.add(NbtTranslator.getInstance().translateFrom(dataCompound));
                }
                ImmutableList<DataManipulator<?, ?>> manipulators = DataUtil.deserializeManipulatorList(views);
                for (DataManipulator manipulator : manipulators) {
                    this.offerCustom(manipulator, MergeFunction.IGNORE_ALL);
                }
            } else {
                compound.func_82580_o("CustomManipulators");
                if (compound.func_82582_d()) {
                    this.func_77978_p().func_82580_o("SpongeData");
                    return;
                }
            }
        }
        if (compound.func_82582_d()) {
            this.func_77978_p().func_82580_o("SpongeData");
            if (this.func_77978_p().func_82582_d()) {
                this.func_77982_d(null);
            }
        }
    }

    @Override
    public void writeToNbt(NBTTagCompound compound) {
        this.resyncCustomToTag();
    }

    @Override
    public DataTransactionResult offerCustom(DataManipulator<?, ?> manipulator, MergeFunction function) {
        DataManipulator<?, ?> existingManipulator = null;
        for (DataManipulator<?, ?> existing : this.manipulators) {
            if (!manipulator.getClass().isInstance(existing)) continue;
            existingManipulator = existing;
            break;
        }
        DataTransactionResult.Builder builder = DataTransactionResult.builder();
        DataManipulator newManipulator = (DataManipulator)Preconditions.checkNotNull((Object)function.merge(existingManipulator, manipulator.copy()));
        if (existingManipulator != null) {
            builder.replace(existingManipulator.getValues());
            this.manipulators.remove(existingManipulator);
        }
        this.manipulators.add(newManipulator);
        this.resyncCustomToTag();
        return builder.success(newManipulator.getValues()).result(DataTransactionResult.Type.SUCCESS).build();
    }

    @Override
    public <T extends DataManipulator<?, ?>> Optional<T> getCustom(Class<T> customClass) {
        for (DataManipulator<?, ?> existing : this.manipulators) {
            if (!customClass.isInstance(existing)) continue;
            return Optional.of(existing.copy());
        }
        return Optional.empty();
    }

    private void resyncCustomToTag() {
        if (!this.manipulators.isEmpty()) {
            NBTTagList newList = new NBTTagList();
            List<DataView> manipulatorViews = DataUtil.getSerializedManipulatorList(this.getCustomManipulators());
            for (DataView dataView : manipulatorViews) {
                newList.func_74742_a((NBTBase)NbtTranslator.getInstance().translateData(dataView));
            }
            NBTTagCompound spongeCompound = this.func_179543_a("SpongeData", true);
            spongeCompound.func_74782_a("CustomManipulators", (NBTBase)newList);
        } else {
            if (this.func_77942_o()) {
                this.func_77978_p().func_82580_o("SpongeData");
            }
            if (this.func_77978_p().func_82582_d()) {
                this.func_77982_d(null);
            }
        }
    }

    @Override
    public DataTransactionResult removeCustom(Class<? extends DataManipulator<?, ?>> customClass) {
        DataManipulator<?, ?> manipulator = null;
        for (DataManipulator<?, ?> existing : this.manipulators) {
            if (!customClass.isInstance(existing)) continue;
            manipulator = existing;
        }
        if (manipulator != null) {
            this.manipulators.remove(manipulator);
            this.resyncCustomToTag();
            return DataTransactionResult.builder().replace(manipulator.getValues()).result(DataTransactionResult.Type.SUCCESS).build();
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    public boolean hasManipulators() {
        return !this.manipulators.isEmpty();
    }

    @Override
    public List<DataManipulator<?, ?>> getCustomManipulators() {
        return this.manipulators.stream().map(DataManipulator::copy).collect(Collectors.toList());
    }

    @Override
    public <E> DataTransactionResult offerCustom(Key<? extends BaseValue<E>> key, E value) {
        for (DataManipulator<? extends BaseValue<E>, ? extends BaseValue<E>> dataManipulator : this.manipulators) {
            if (!dataManipulator.supports(key)) continue;
            DataTransactionResult.Builder builder = DataTransactionResult.builder();
            builder.replace(((Value)dataManipulator.getValue(key).get()).asImmutable());
            dataManipulator.set(key, value);
            builder.success(((Value)dataManipulator.getValue(key).get()).asImmutable());
            this.resyncCustomToTag();
            return builder.result(DataTransactionResult.Type.SUCCESS).build();
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    public DataTransactionResult removeCustom(Key<?> key) {
        Iterator<DataManipulator<?, ?>> iterator = this.manipulators.iterator();
        while (iterator.hasNext()) {
            DataManipulator<?, ?> manipulator = iterator.next();
            if (manipulator.getKeys().size() != 1 || !manipulator.supports(key)) continue;
            iterator.remove();
            this.resyncCustomToTag();
            return DataTransactionResult.builder().replace(manipulator.getValues()).result(DataTransactionResult.Type.SUCCESS).build();
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    public boolean supportsCustom(Key<?> key) {
        return this.manipulators.stream().filter(manipulator -> manipulator.supports(key)).findFirst().isPresent();
    }

    @Override
    public <E> Optional<E> getCustom(Key<? extends BaseValue<E>> key) {
        return this.manipulators.stream().filter(manipulator -> manipulator.supports(key)).findFirst().flatMap(supported -> supported.get(key));
    }

    @Override
    public <E, V extends BaseValue<E>> Optional<V> getCustomValue(Key<V> key) {
        return this.manipulators.stream().filter(manipulator -> manipulator.supports(key)).findFirst().flatMap(supported -> supported.getValue(key));
    }
}

