/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.item.inventory;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.event.item.inventory.InteractInventoryEvent;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryArchetype;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.item.inventory.adapter.impl.MinecraftInventoryAdapter;
import org.spongepowered.common.item.inventory.custom.CustomInventory;
import org.spongepowered.common.item.inventory.custom.CustomLens;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.impl.MinecraftFabric;
import org.spongepowered.common.item.inventory.lens.impl.collections.SlotCollection;
import org.spongepowered.common.item.inventory.observer.InventoryEventArgs;

@Mixin(value={CustomInventory.class})
public abstract class MixinCustomInventory
implements MinecraftInventoryAdapter,
Inventory,
CarriedInventory<Carrier> {
    @Shadow
    private InventoryArchetype archetype;
    @Shadow
    public InventoryBasic inv;
    @Shadow
    public Carrier carrier;
    private Fabric<IInventory> inventory;
    private SlotCollection slots;
    private CustomLens lens;

    @Inject(method="<init>*", at={@At(value="RETURN")}, remap=false)
    private void onConstructed(InventoryArchetype archetype, Map<String, InventoryProperty> properties, Carrier carrier, Map<Class<? extends InteractInventoryEvent>, List<Consumer<? extends InteractInventoryEvent>>> listeners, Object plugin, CallbackInfo ci) {
        this.inventory = MinecraftFabric.of(this);
        this.slots = new SlotCollection.Builder().add(this.inv.func_70302_i_()).build();
        this.lens = new CustomLens(this, this.slots, archetype, properties);
    }

    @Override
    public Lens<IInventory, ItemStack> getRootLens() {
        return this.lens;
    }

    @Override
    public Fabric<IInventory> getInventory() {
        return this.inventory;
    }

    @Override
    public Inventory getChild(Lens<IInventory, ItemStack> lens) {
        return null;
    }

    @Override
    public void notify(Object source, InventoryEventArgs eventArgs) {
    }

    @Override
    public InventoryArchetype getArchetype() {
        return this.archetype;
    }

    @Override
    public Optional<Carrier> getCarrier() {
        return Optional.ofNullable(this.carrier);
    }
}

