/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.network;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.network.ChannelBuf;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.network.SpongeNetworkManager;

@Mixin(value={PacketBuffer.class})
@Implements(value={@Interface(iface=ChannelBuf.class, prefix="cbuf$")})
public abstract class MixinPacketBuffer
extends ByteBuf {
    private static final int MAX_STRING_LENGTH_BYTES = Short.MAX_VALUE;
    private static final int MAX_STRING_LENGTH = 8191;

    @Shadow
    public abstract PacketBuffer func_179250_a(byte[] var1);

    @Shadow
    public abstract PacketBuffer func_150787_b(int var1);

    @Shadow
    public abstract PacketBuffer func_180714_a(String var1);

    @Shadow
    public abstract PacketBuffer func_150786_a(@Nullable NBTTagCompound var1);

    @Shadow
    public abstract byte[] func_179251_a();

    @Shadow
    public abstract byte[] func_189425_b(int var1);

    @Shadow
    public abstract int func_150792_a();

    @Shadow
    public abstract String func_150789_c(int var1);

    @Shadow
    public abstract NBTTagCompound func_150793_b() throws IOException;

    @Shadow
    public abstract UUID func_179253_g();

    public int cbuf$getCapacity() {
        return this.capacity();
    }

    public int cbuf$available() {
        return this.writerIndex() - this.readerIndex();
    }

    public ChannelBuf cbuf$order(ByteOrder order) {
        this.order(order);
        return (ChannelBuf)((Object)this);
    }

    public ByteOrder cbuf$getByteOrder() {
        return this.order();
    }

    @Intrinsic
    public int cbuf$readerIndex() {
        return this.readerIndex();
    }

    public ChannelBuf cbuf$setReadIndex(int index) {
        this.readerIndex(index);
        return (ChannelBuf)((Object)this);
    }

    @Intrinsic
    public int cbuf$writerIndex() {
        return this.writerIndex();
    }

    public ChannelBuf cbuf$setWriteIndex(int index) {
        this.writerIndex(index);
        return (ChannelBuf)((Object)this);
    }

    public ChannelBuf cbuf$setIndex(int readIndex, int writeIndex) {
        this.setIndex(readIndex, writeIndex);
        return (ChannelBuf)((Object)this);
    }

    public ChannelBuf cbuf$clear() {
        this.clear();
        return (ChannelBuf)((Object)this);
    }

    public ChannelBuf cbuf$markRead() {
        this.markReaderIndex();
        return (ChannelBuf)((Object)this);
    }

    public ChannelBuf cbuf$markWrite() {
        this.markWriterIndex();
        return (ChannelBuf)((Object)this);
    }

    public ChannelBuf cbuf$resetRead() {
        this.resetReaderIndex();
        return (ChannelBuf)((Object)this);
    }

    public ChannelBuf cbuf$resetWrite() {
        this.resetWriterIndex();
        return (ChannelBuf)((Object)this);
    }

    public ChannelBuf cbuf$slice() {
        return SpongeNetworkManager.toChannelBuf(this.slice());
    }

    public ChannelBuf cbuf$slice(int index, int length) {
        return SpongeNetworkManager.toChannelBuf(this.slice(index, length));
    }

    @Intrinsic
    public byte[] cbuf$array() {
        return this.array();
    }

    public ChannelBuf cbuf$writeBoolean(boolean data) {
        this.writeBoolean(data);
        return (ChannelBuf)((Object)this);
    }

    public ChannelBuf cbuf$setBoolean(int index, boolean data) {
        this.setBoolean(index, data);
        return (ChannelBuf)((Object)this);
    }

    @Intrinsic
    public boolean cbuf$readBoolean() {
        return this.readBoolean();
    }

    @Intrinsic
    public boolean cbuf$getBoolean(int index) {
        return this.getBoolean(index);
    }

    public ChannelBuf cbuf$writeByte(byte data) {
        this.writeByte(data);
        return (ChannelBuf)((Object)this);
    }

    public ChannelBuf cbuf$setByte(int index, byte data) {
        this.setByte(index, data);
        return (ChannelBuf)((Object)this);
    }

    @Intrinsic
    public byte cbuf$readByte() {
        return this.readByte();
    }

    @Intrinsic
    public byte cbuf$getByte(int index) {
        return this.getByte(index);
    }

    public ChannelBuf cbuf$writeByteArray(byte[] data) {
        return (ChannelBuf)this.func_179250_a(data);
    }

    public ChannelBuf cbuf$writeByteArray(byte[] data, int start, int length) {
        this.writeBytes(data, start, length);
        return (ChannelBuf)((Object)this);
    }

    public ChannelBuf cbuf$setByteArray(int index, byte[] data) {
        this.setBytes(index, data);
        return (ChannelBuf)((Object)this);
    }

    public ChannelBuf cbuf$setByteArray(int index, byte[] data, int start, int length) {
        this.setBytes(index, data, start, length);
        return (ChannelBuf)((Object)this);
    }

    @Intrinsic
    public byte[] cbuf$readByteArray() {
        return this.func_179251_a();
    }

    @Intrinsic
    public byte[] cbuf$readByteArray(int index) {
        return this.func_189425_b(index);
    }

    public ChannelBuf cbuf$writeBytes(byte[] data) {
        this.writeBytes(data);
        return (ChannelBuf)((Object)this);
    }

    public ChannelBuf cbuf$writeBytes(byte[] data, int start, int length) {
        this.writeBytes(data, start, length);
        return (ChannelBuf)((Object)this);
    }

    public ChannelBuf cbuf$setBytes(int index, byte[] data) {
        this.setBytes(index, data);
        return (ChannelBuf)((Object)this);
    }

    public ChannelBuf cbuf$setBytes(int index, byte[] data, int start, int length) {
        this.setBytes(index, data, start, length);
        return (ChannelBuf)((Object)this);
    }

    @Intrinsic
    public byte[] cbuf$readBytes(int length) {
        return this.readBytes(length).array();
    }

    public byte[] cbuf$readBytes(int index, int length) {
        byte[] dest = new byte[length];
        this.readBytes(dest, index, length);
        return dest;
    }

    public ChannelBuf cbuf$writeShort(short data) {
        this.writeShort(data);
        return (ChannelBuf)((Object)this);
    }

    public ChannelBuf cbuf$setShort(int index, short data) {
        this.setShort(index, data);
        return (ChannelBuf)((Object)this);
    }

    @Intrinsic
    public short cbuf$readShort() {
        return this.readShort();
    }

    @Intrinsic
    public short cbuf$getShort(int index) {
        return this.getShort(index);
    }

    public ChannelBuf cbuf$writeChar(char data) {
        this.writeChar(data);
        return (ChannelBuf)((Object)this);
    }

    public ChannelBuf cbuf$setChar(int index, char data) {
        this.setChar(index, data);
        return (ChannelBuf)((Object)this);
    }

    @Intrinsic
    public char cbuf$readChar() {
        return this.readChar();
    }

    @Intrinsic
    public char cbuf$getChar(int index) {
        return this.getChar(index);
    }

    public ChannelBuf cbuf$writeInteger(int data) {
        this.writeInt(data);
        return (ChannelBuf)((Object)this);
    }

    public ChannelBuf cbuf$setInteger(int index, int data) {
        this.setInt(index, data);
        return (ChannelBuf)((Object)this);
    }

    public int cbuf$readInteger() {
        return this.readInt();
    }

    public int getInteger(int index) {
        return this.getInt(index);
    }

    public ChannelBuf cbuf$writeLong(long data) {
        this.writeLong(data);
        return (ChannelBuf)((Object)this);
    }

    public ChannelBuf cbuf$setLong(int index, long data) {
        this.setLong(index, data);
        return (ChannelBuf)((Object)this);
    }

    @Intrinsic
    public long cbuf$readLong() {
        return this.readLong();
    }

    @Intrinsic
    public long cbuf$getLong(int index) {
        return this.getLong(index);
    }

    public ChannelBuf cbuf$writeFloat(float data) {
        this.writeFloat(data);
        return (ChannelBuf)((Object)this);
    }

    public ChannelBuf cbuf$setFloat(int index, float data) {
        this.setFloat(index, data);
        return (ChannelBuf)((Object)this);
    }

    @Intrinsic
    public float cbuf$readFloat() {
        return this.readFloat();
    }

    @Intrinsic
    public float cbuf$getFloat(int index) {
        return this.getFloat(index);
    }

    public ChannelBuf cbuf$writeDouble(double data) {
        this.writeDouble(data);
        return (ChannelBuf)((Object)this);
    }

    public ChannelBuf cbuf$setDouble(int index, double data) {
        this.setDouble(index, data);
        return (ChannelBuf)((Object)this);
    }

    @Intrinsic
    public double cbuf$readDouble() {
        return this.readDouble();
    }

    @Intrinsic
    public double cbuf$getDouble(int index) {
        return this.getDouble(index);
    }

    public ChannelBuf cbuf$writeVarInt(int value) {
        return (ChannelBuf)this.func_150787_b(value);
    }

    public ChannelBuf cbuf$setVarInt(int index, int value) {
        int oldIndex = this.writerIndex();
        this.writerIndex(index);
        this.func_150787_b(value);
        this.writerIndex(oldIndex);
        return (ChannelBuf)((Object)this);
    }

    public int cbuf$readVarInt() {
        return this.func_150792_a();
    }

    public int cbuf$getVarInt(int index) {
        int oldIndex = this.readerIndex();
        this.readerIndex(index);
        int value = this.func_150792_a();
        this.readerIndex(oldIndex);
        return value;
    }

    public ChannelBuf cbuf$writeString(String data) {
        return (ChannelBuf)this.func_180714_a((String)Preconditions.checkNotNull((Object)data));
    }

    public ChannelBuf cbuf$setString(int index, String data) {
        Preconditions.checkNotNull((Object)data);
        int oldIndex = this.writerIndex();
        this.writerIndex(index);
        this.func_180714_a(data);
        this.writerIndex(oldIndex);
        return (ChannelBuf)((Object)this);
    }

    public String cbuf$readString() {
        return this.func_150789_c(8191);
    }

    public String cbuf$getString(int index) {
        int oldIndex = this.readerIndex();
        this.readerIndex(index);
        String value = this.func_150789_c(8191);
        this.readerIndex(oldIndex);
        return value;
    }

    public ChannelBuf cbuf$writeUTF(String data) {
        byte[] bytes = data.getBytes(Charsets.UTF_8);
        if (bytes.length > Short.MAX_VALUE) {
            throw new EncoderException("String too big (was " + data.length() + " bytes encoded, max " + Short.MAX_VALUE + ")");
        }
        this.writeShort(bytes.length);
        this.writeBytes(bytes);
        return (ChannelBuf)((Object)this);
    }

    public ChannelBuf cbuf$setUTF(int index, String data) {
        Preconditions.checkNotNull((Object)data, (Object)"data");
        int oldIndex = this.writerIndex();
        this.writerIndex(index);
        this.cbuf$writeUTF(data);
        this.writerIndex(oldIndex);
        return (ChannelBuf)((Object)this);
    }

    public String cbuf$readUTF() {
        short length = this.readShort();
        return new String(this.readBytes(length).array(), Charsets.UTF_8);
    }

    public String cbuf$getUTF(int index) {
        int oldIndex = this.readerIndex();
        this.readerIndex(index);
        short length = this.readShort();
        String data = new String(this.readBytes(length).array(), Charsets.UTF_8);
        this.readerIndex(oldIndex);
        return data;
    }

    public ChannelBuf cbuf$writeUniqueId(UUID data) {
        Preconditions.checkNotNull((Object)data, (Object)"data");
        return this.cbuf$writeLong(data.getMostSignificantBits()).writeLong(data.getLeastSignificantBits());
    }

    public ChannelBuf cbuf$setUniqueId(int index, UUID data) {
        Preconditions.checkNotNull((Object)data, (Object)"data");
        int oldIndex = this.writerIndex();
        this.writerIndex(index);
        this.writeLong(data.getMostSignificantBits()).writeLong(data.getLeastSignificantBits());
        this.writerIndex(oldIndex);
        return (ChannelBuf)((Object)this);
    }

    public UUID cbuf$readUniqueId() {
        return this.func_179253_g();
    }

    public UUID getUniqueId(int index) {
        int oldIndex = this.readerIndex();
        this.readerIndex(index);
        UUID data = this.func_179253_g();
        this.readerIndex(oldIndex);
        return data;
    }

    public ChannelBuf cbuf$writeDataView(DataView data) {
        NBTTagCompound compound = NbtTranslator.getInstance().translateData((DataView)Preconditions.checkNotNull((Object)data, (Object)"data"));
        this.func_150786_a(compound);
        return (ChannelBuf)((Object)this);
    }

    public ChannelBuf cbuf$setDataView(int index, DataView data) {
        Preconditions.checkNotNull((Object)data, (Object)"data");
        int oldIndex = this.writerIndex();
        this.writerIndex(index);
        this.cbuf$writeDataView(data);
        this.writerIndex(oldIndex);
        return (ChannelBuf)((Object)this);
    }

    public DataView cbuf$readDataView() {
        try {
            return NbtTranslator.getInstance().translateFrom(this.func_150793_b());
        }
        catch (IOException e) {
            throw new DecoderException((Throwable)e);
        }
    }

    public DataView cbuf$getDataView(int index) {
        int oldIndex = this.readerIndex();
        this.readerIndex(index);
        DataView data = this.cbuf$readDataView();
        this.readerIndex(oldIndex);
        return data;
    }
}

