/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server;

import com.flowpowered.math.vector.Vector3d;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.net.SocketAddress;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketCustomPayload;
import net.minecraft.network.play.server.SPacketDisconnect;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketEntityStatus;
import net.minecraft.network.play.server.SPacketHeldItemChange;
import net.minecraft.network.play.server.SPacketJoinGame;
import net.minecraft.network.play.server.SPacketPlayerAbilities;
import net.minecraft.network.play.server.SPacketPlayerListItem;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.network.play.server.SPacketServerDifficulty;
import net.minecraft.network.play.server.SPacketSetExperience;
import net.minecraft.network.play.server.SPacketSpawnPosition;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.server.management.UserListBans;
import net.minecraft.server.management.UserListIPBans;
import net.minecraft.server.management.UserListWhitelist;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.WorldServer;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.demo.DemoWorldManager;
import net.minecraft.world.storage.IPlayerFileData;
import net.minecraft.world.storage.WorldInfo;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.event.cause.entity.spawn.EntitySpawnCause;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.entity.living.humanoid.player.RespawnPlayerEvent;
import org.spongepowered.api.event.message.MessageEvent;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.network.RemoteConnection;
import org.spongepowered.api.resourcepack.ResourcePack;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.entity.player.SpongeUser;
import org.spongepowered.common.event.tracking.CauseTracker;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.phase.PlayerPhase;
import org.spongepowered.common.interfaces.IMixinPlayerList;
import org.spongepowered.common.interfaces.IMixinServerScoreboard;
import org.spongepowered.common.interfaces.entity.IMixinEntity;
import org.spongepowered.common.interfaces.entity.player.IMixinEntityPlayerMP;
import org.spongepowered.common.interfaces.network.play.server.IMixinSPacketWorldBorder;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.service.ban.SpongeIPBanList;
import org.spongepowered.common.service.ban.SpongeUserListBans;
import org.spongepowered.common.service.permission.SpongePermissionService;
import org.spongepowered.common.service.whitelist.SpongeUserListWhitelist;
import org.spongepowered.common.text.SpongeTexts;
import org.spongepowered.common.text.chat.ChatUtil;
import org.spongepowered.common.world.WorldManager;
import org.spongepowered.common.world.storage.SpongePlayerDataHandler;

@NonnullByDefault
@Mixin(value={PlayerList.class})
public abstract class MixinPlayerList
implements IMixinPlayerList {
    private static final String WRITE_PLAYER_DATA = "Lnet/minecraft/world/storage/IPlayerFileData;writePlayerData(Lnet/minecraft/entity/player/EntityPlayer;)V";
    private static final String SERVER_SEND_PACKET_TO_ALL_PLAYERS = "Lnet/minecraft/server/management/PlayerList;sendPacketToAllPlayers(Lnet/minecraft/network/Packet;)V";
    @Shadow
    @Final
    private static Logger field_148546_d;
    @Shadow
    @Final
    private MinecraftServer field_72400_f;
    @Shadow
    @Final
    public Map<UUID, EntityPlayerMP> field_177454_f;
    @Shadow
    @Final
    public List<EntityPlayerMP> field_72404_b;
    @Shadow
    private IPlayerFileData field_72412_k;

    @Shadow
    public abstract NBTTagCompound func_72380_a(EntityPlayerMP var1);

    @Shadow
    public abstract MinecraftServer func_72365_p();

    @Shadow
    public abstract int func_72352_l();

    @Shadow
    public abstract void func_148540_a(Packet<?> var1);

    @Shadow
    public abstract void func_72375_a(EntityPlayerMP var1, @Nullable WorldServer var2);

    @Shadow
    public abstract void func_72377_c(EntityPlayerMP var1);

    @Shadow
    public abstract void func_72354_b(EntityPlayerMP var1, WorldServer var2);

    @Shadow
    public abstract void func_187243_f(EntityPlayerMP var1);

    @Shadow
    public abstract void func_72385_f(EntityPlayerMP var1);

    @Nullable
    @Shadow
    public abstract String func_148542_a(SocketAddress var1, GameProfile var2);

    @Shadow
    private void func_72381_a(EntityPlayerMP playerIn, @Nullable EntityPlayerMP other, net.minecraft.world.World worldIn) {
    }

    @Redirect(method="<init>", at=@At(value="NEW", args={"class=net/minecraft/server/management/UserListBans"}))
    private UserListBans createBanList(File file) {
        return new SpongeUserListBans(file);
    }

    @Redirect(method="<init>", at=@At(value="NEW", args={"class=net/minecraft/server/management/UserListIPBans"}))
    private UserListIPBans createIPBanList(File file) {
        return new SpongeIPBanList(file);
    }

    @Redirect(method="<init>", at=@At(value="NEW", args={"class=net/minecraft/server/management/UserListWhitelist"}))
    private UserListWhitelist createWhitelist(File file) {
        return new SpongeUserListWhitelist(file);
    }

    public void func_72355_a(NetworkManager netManager, EntityPlayerMP playerIn) {
        this.initializeConnectionToPlayer(netManager, playerIn, null);
    }

    public void initializeConnectionToPlayer(NetworkManager netManager, EntityPlayerMP playerIn) {
        this.initializeConnectionToPlayer(netManager, playerIn, null);
    }

    private void disconnectClient(NetworkManager netManager, Optional<Text> disconnectMessage, @Nullable GameProfile profile) {
        Object reason = disconnectMessage.isPresent() ? SpongeTexts.toComponent(disconnectMessage.get()) : new TextComponentTranslation("disconnect.disconnected", new Object[0]);
        try {
            field_148546_d.info("Disconnecting " + (profile != null ? profile.toString() + " (" + netManager.func_74430_c().toString() + ")" : String.valueOf(netManager.func_74430_c() + ": " + reason.func_150260_c())));
            netManager.func_179290_a((Packet)new SPacketDisconnect(reason));
            netManager.func_150718_a(reason);
        }
        catch (Exception exception) {
            field_148546_d.error("Error whilst disconnecting player", (Throwable)exception);
        }
    }

    public void initializeConnectionToPlayer(NetworkManager netManager, EntityPlayerMP playerIn, @Nullable NetHandlerPlayServer handler) {
        String kickReason;
        GameProfile gameprofile = playerIn.func_146103_bH();
        PlayerProfileCache playerprofilecache = this.field_72400_f.func_152358_ax();
        GameProfile gameprofile1 = playerprofilecache.func_152652_a(gameprofile.getId());
        String s = gameprofile1 == null ? gameprofile.getName() : gameprofile1.getName();
        playerprofilecache.func_152649_a(gameprofile);
        SpongeUser user = (SpongeUser)((Object)((IMixinEntityPlayerMP)playerIn).getUserObject());
        if (SpongeUser.dirtyUsers.contains(user)) {
            user.save();
        }
        NBTTagCompound nbttagcompound = this.func_72380_a(playerIn);
        WorldServer worldServer = this.field_72400_f.func_71218_a(playerIn.field_71093_bK);
        int actualDimensionId = ((IMixinWorldServer)worldServer).getDimensionId();
        BlockPos spawnPos = null;
        Optional<Instant> firstJoined = SpongePlayerDataHandler.getFirstJoined(playerIn.func_110124_au());
        Instant lastJoined = Instant.now();
        SpongePlayerDataHandler.setPlayerInfo(playerIn.func_110124_au(), firstJoined.orElse(lastJoined), lastJoined);
        if (actualDimensionId != playerIn.field_71093_bK) {
            SpongeImpl.getLogger().warn("Player [{}] has attempted to login to unloaded world [{}]. This is not safe so we have moved them to the default world's spawn point.", new Object[]{playerIn.func_70005_c_(), playerIn.field_71093_bK});
            spawnPos = !firstJoined.isPresent() ? SpongeImplHooks.getRandomizedSpawnPoint(worldServer) : worldServer.func_175694_M();
            playerIn.field_71093_bK = actualDimensionId;
            playerIn.func_70107_b((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p());
        }
        Text disconnectMessage = (kickReason = this.func_148542_a(netManager.func_74430_c(), gameprofile)) != null ? SpongeTexts.fromLegacy(kickReason) : Text.of("You are not allowed to log in to this server.");
        Player player = (Player)playerIn;
        Transform<World> fromTransform = player.getTransform().setExtent((World)worldServer);
        ClientConnectionEvent.Login loginEvent = SpongeEventFactory.createClientConnectionEventLogin(Cause.of(NamedCause.source(player)), fromTransform, fromTransform, (RemoteConnection)netManager, new MessageEvent.MessageFormatter(disconnectMessage), (org.spongepowered.api.profile.GameProfile)gameprofile, player, false);
        if (kickReason != null) {
            loginEvent.setCancelled(true);
        }
        if (SpongeImpl.postEvent(loginEvent)) {
            this.disconnectClient(netManager, loginEvent.isMessageCancelled() ? Optional.empty() : Optional.of(loginEvent.getMessage()), gameprofile);
            return;
        }
        worldServer = (WorldServer)loginEvent.getToTransform().getExtent();
        double x = loginEvent.getToTransform().getPosition().getX();
        double y = loginEvent.getToTransform().getPosition().getY();
        double z = loginEvent.getToTransform().getPosition().getZ();
        float pitch = (float)loginEvent.getToTransform().getPitch();
        float yaw = (float)loginEvent.getToTransform().getYaw();
        playerIn.field_71093_bK = ((IMixinWorldServer)worldServer).getDimensionId();
        playerIn.func_70029_a((net.minecraft.world.World)worldServer);
        playerIn.field_71134_c.func_73080_a((WorldServer)playerIn.field_70170_p);
        playerIn.func_70080_a(x, y, z, yaw, pitch);
        worldServer.func_72863_F().func_186028_c(loginEvent.getToTransform().getLocation().getChunkPosition().getX(), loginEvent.getToTransform().getLocation().getChunkPosition().getZ());
        String s1 = "local";
        if (netManager.func_74430_c() != null) {
            s1 = netManager.func_74430_c().toString();
        }
        WorldInfo worldinfo = worldServer.func_72912_H();
        BlockPos spawnBlockPos = worldServer.func_175694_M();
        this.func_72381_a(playerIn, null, (net.minecraft.world.World)worldServer);
        if (handler == null) {
            handler = new NetHandlerPlayServer(this.field_72400_f, netManager, playerIn);
        }
        playerIn.field_71135_a = handler;
        int dimensionId = WorldManager.getClientDimensionId(playerIn, (net.minecraft.world.World)worldServer);
        WorldManager.sendDimensionRegistration(playerIn, worldServer.field_73011_w);
        handler.func_147359_a((Packet)new SPacketJoinGame(playerIn.func_145782_y(), playerIn.field_71134_c.func_73081_b(), worldinfo.func_76093_s(), dimensionId, worldServer.func_175659_aa(), this.func_72352_l(), worldinfo.func_76067_t(), worldServer.func_82736_K().func_82766_b("reducedDebugInfo")));
        handler.func_147359_a((Packet)new SPacketCustomPayload("MC|Brand", new PacketBuffer(Unpooled.buffer()).func_180714_a(this.func_72365_p().getServerModName())));
        handler.func_147359_a((Packet)new SPacketServerDifficulty(worldinfo.func_176130_y(), worldinfo.func_176123_z()));
        handler.func_147359_a((Packet)new SPacketSpawnPosition(spawnBlockPos));
        handler.func_147359_a((Packet)new SPacketPlayerAbilities(playerIn.field_71075_bZ));
        handler.func_147359_a((Packet)new SPacketHeldItemChange(playerIn.field_71071_by.field_70461_c));
        this.func_187243_f(playerIn);
        playerIn.func_147099_x().func_150877_d();
        playerIn.func_147099_x().func_150884_b(playerIn);
        this.field_72400_f.func_147132_au();
        handler.func_147364_a(x, y, z, yaw, pitch);
        this.func_72377_c(playerIn);
        field_148546_d.info(playerIn.func_70005_c_() + "[" + s1 + "] logged in with entity id " + playerIn.func_145782_y() + " in " + worldServer.func_72912_H().func_76065_j() + "(" + ((IMixinWorldServer)worldServer).getDimensionId() + ") at (" + playerIn.field_70165_t + ", " + playerIn.field_70163_u + ", " + playerIn.field_70161_v + ")");
        this.func_72354_b(playerIn, worldServer);
        Optional<ResourcePack> pack = ((Server)this.field_72400_f).getDefaultResourcePack();
        if (pack.isPresent()) {
            ((Player)playerIn).sendResourcePack(pack.get());
        }
        ((IMixinEntityPlayerMP)playerIn).initScoreboard();
        for (PotionEffect potioneffect : playerIn.func_70651_bq()) {
            handler.func_147359_a((Packet)new SPacketEntityEffect(playerIn.func_145782_y(), potioneffect));
        }
        if (nbttagcompound != null) {
            net.minecraft.entity.Entity entity1;
            if (nbttagcompound.func_150297_b("RootVehicle", 10)) {
                NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("RootVehicle");
                net.minecraft.entity.Entity entity2 = AnvilChunkLoader.func_186051_a((NBTTagCompound)nbttagcompound1.func_74775_l("Entity"), (net.minecraft.world.World)worldServer, (boolean)true);
                if (entity2 != null) {
                    UUID uuid = nbttagcompound1.func_186857_a("Attach");
                    if (entity2.func_110124_au().equals(uuid)) {
                        playerIn.func_184205_a(entity2, true);
                    } else {
                        for (net.minecraft.entity.Entity entity : entity2.func_184182_bu()) {
                            if (!entity.func_110124_au().equals(uuid)) continue;
                            playerIn.func_184205_a(entity, true);
                            break;
                        }
                    }
                    if (!playerIn.func_184218_aH()) {
                        field_148546_d.warn("Couldn't reattach entity to player");
                        worldServer.func_72973_f(entity2);
                        for (net.minecraft.entity.Entity entity3 : entity2.func_184182_bu()) {
                            worldServer.func_72973_f(entity3);
                        }
                    }
                }
            } else if (nbttagcompound.func_150297_b("Riding", 10) && (entity1 = AnvilChunkLoader.func_186051_a((NBTTagCompound)nbttagcompound.func_74775_l("Riding"), (net.minecraft.world.World)worldServer, (boolean)true)) != null) {
                playerIn.func_184205_a(entity1, true);
            }
        }
        playerIn.func_71116_b();
        TextComponentTranslation chatcomponenttranslation = !playerIn.func_70005_c_().equalsIgnoreCase(s) ? new TextComponentTranslation("multiplayer.player.joined.renamed", new Object[]{playerIn.func_145748_c_(), s}) : new TextComponentTranslation("multiplayer.player.joined", new Object[]{playerIn.func_145748_c_()});
        chatcomponenttranslation.func_150256_b().func_150238_a(TextFormatting.YELLOW);
        Text originalMessage = SpongeTexts.toText((ITextComponent)chatcomponenttranslation);
        MessageChannel originalChannel = player.getMessageChannel();
        ClientConnectionEvent.Join event = SpongeEventFactory.createClientConnectionEventJoin(Cause.of(NamedCause.source(player)), originalChannel, Optional.of(originalChannel), new MessageEvent.MessageFormatter(originalMessage), player, false);
        SpongeImpl.postEvent(event);
        if (!event.isMessageCancelled()) {
            event.getChannel().ifPresent(channel -> channel.send(player, event.getMessage()));
        }
    }

    @Overwrite
    public EntityPlayerMP func_72368_a(EntityPlayerMP playerIn, int targetDimension, boolean conqueredEnd) {
        if (!conqueredEnd && targetDimension == 0) {
            targetDimension = playerIn.field_71093_bK;
        }
        if (playerIn.func_184207_aI()) {
            playerIn.func_184226_ay();
        }
        if (playerIn.func_184218_aH()) {
            playerIn.func_184210_p();
        }
        Player player = (Player)playerIn;
        Transform<World> fromTransform = player.getTransform();
        WorldServer worldServer = this.field_72400_f.func_71218_a(targetDimension);
        targetDimension = ((IMixinWorldServer)worldServer).getDimensionId();
        Transform<World> toTransform = new Transform<World>(EntityUtil.getPlayerRespawnLocation(playerIn, worldServer), Vector3d.ZERO, Vector3d.ZERO);
        Location<World> location = toTransform.getLocation();
        if (conqueredEnd) {
            MoveEntityEvent.Teleport teleportEvent = EntityUtil.handleDisplaceEntityTeleportEvent((net.minecraft.entity.Entity)playerIn, location);
            if (teleportEvent.isCancelled()) {
                playerIn.field_71136_j = false;
                return playerIn;
            }
            toTransform = teleportEvent.getToTransform();
            location = toTransform.getLocation();
        }
        Vector3d tempPos = player.getLocation().getPosition();
        playerIn.func_70107_b(location.getX(), location.getY(), location.getZ());
        while (!((WorldServer)location.getExtent()).func_184144_a((net.minecraft.entity.Entity)playerIn, playerIn.func_174813_aQ()).isEmpty()) {
            playerIn.func_70107_b(playerIn.field_70165_t, playerIn.field_70163_u + 1.0, playerIn.field_70161_v);
            location = location.add(0.0, 1.0, 0.0);
        }
        playerIn.func_70107_b(tempPos.getX(), tempPos.getY(), tempPos.getZ());
        playerIn.func_71121_q().func_73039_n().func_72787_a(playerIn);
        playerIn.func_71121_q().func_73039_n().func_72790_b((net.minecraft.entity.Entity)playerIn);
        playerIn.func_71121_q().func_184164_w().func_72695_c(playerIn);
        this.field_72404_b.remove(playerIn);
        this.field_72400_f.func_71218_a(playerIn.field_71093_bK).func_72973_f((net.minecraft.entity.Entity)playerIn);
        Object playerinteractionmanager = this.field_72400_f.func_71242_L() ? new DemoWorldManager((net.minecraft.world.World)this.field_72400_f.func_71218_a(targetDimension)) : new PlayerInteractionManager((net.minecraft.world.World)this.field_72400_f.func_71218_a(targetDimension));
        EntityPlayerMP newPlayer = new EntityPlayerMP(SpongeImpl.getServer(), worldServer, playerIn.func_146103_bH(), (PlayerInteractionManager)playerinteractionmanager);
        newPlayer.field_71135_a = playerIn.field_71135_a;
        newPlayer.func_71049_a((EntityPlayer)playerIn, conqueredEnd);
        newPlayer.field_71093_bK = targetDimension;
        newPlayer.func_145769_d(playerIn.func_145782_y());
        newPlayer.func_174817_o((net.minecraft.entity.Entity)playerIn);
        newPlayer.func_184819_a(playerIn.func_184591_cq());
        newPlayer.func_180473_a(playerIn.func_180470_cg(), playerIn.func_82245_bX());
        for (String s : playerIn.func_184216_O()) {
            newPlayer.func_184211_a(s);
        }
        this.func_72381_a(newPlayer, playerIn, (net.minecraft.world.World)worldServer);
        newPlayer.func_70095_a(false);
        toTransform = toTransform.setLocation(location);
        RespawnPlayerEvent event = SpongeEventFactory.createRespawnPlayerEvent(Cause.of(NamedCause.source(newPlayer)), fromTransform, toTransform, (Player)playerIn, (Player)newPlayer, EntityUtil.tempIsBedSpawn, !conqueredEnd);
        EntityUtil.tempIsBedSpawn = false;
        SpongeImpl.postEvent(event);
        ((IMixinEntity)((Object)player)).setLocationAndAngles(event.getToTransform());
        toTransform = event.getToTransform();
        location = toTransform.getLocation();
        if (!(location.getExtent() instanceof WorldServer)) {
            SpongeImpl.getLogger().warn("Location set in PlayerRespawnEvent was invalid, using original location instead");
            location = event.getFromTransform().getLocation();
        }
        worldServer = (WorldServer)location.getExtent();
        IMixinWorldServer mixinWorldServer = (IMixinWorldServer)worldServer;
        newPlayer.field_71093_bK = mixinWorldServer.getDimensionId();
        newPlayer.func_70029_a((net.minecraft.world.World)worldServer);
        newPlayer.field_71134_c.func_73080_a(worldServer);
        worldServer.func_72863_F().func_186028_c((int)location.getX() >> 4, (int)location.getZ() >> 4);
        int dimensionId = WorldManager.getClientDimensionId(newPlayer, (net.minecraft.world.World)worldServer);
        if (((IMixinEntityPlayerMP)newPlayer).usesCustomClient()) {
            WorldManager.sendDimensionRegistration(newPlayer, worldServer.field_73011_w);
        } else if (fromTransform.getExtent() != worldServer && fromTransform.getExtent().getDimension().getType() == toTransform.getExtent().getDimension().getType()) {
            newPlayer.field_71135_a.func_147359_a((Packet)new SPacketRespawn(dimensionId >= 0 ? -1 : 0, worldServer.func_175659_aa(), worldServer.func_72912_H().func_76067_t(), newPlayer.field_71134_c.func_73081_b()));
        }
        newPlayer.field_71135_a.func_147359_a((Packet)new SPacketRespawn(dimensionId, worldServer.func_175659_aa(), worldServer.func_72912_H().func_76067_t(), newPlayer.field_71134_c.func_73081_b()));
        newPlayer.field_71135_a.func_147364_a(location.getX(), location.getY(), location.getZ(), (float)toTransform.getYaw(), (float)toTransform.getPitch());
        BlockPos spawnLocation = worldServer.func_175694_M();
        newPlayer.field_71135_a.func_147359_a((Packet)new SPacketSpawnPosition(spawnLocation));
        newPlayer.field_71135_a.func_147359_a((Packet)new SPacketSetExperience(newPlayer.field_71106_cc, newPlayer.field_71067_cb, newPlayer.field_71068_ca));
        this.func_72354_b(newPlayer, worldServer);
        this.func_187243_f(newPlayer);
        worldServer.func_184164_w().func_72683_a(newPlayer);
        Entity spongeEntity = (Entity)newPlayer;
        Object spawnCause = ((EntitySpawnCause.Builder)((EntitySpawnCause.Builder)EntitySpawnCause.builder().entity(spongeEntity)).type(SpawnTypes.PLACEMENT)).build();
        ((World)worldServer).spawnEntity(spongeEntity, Cause.of(NamedCause.source(spawnCause)));
        this.field_72404_b.add(newPlayer);
        this.field_177454_f.put(newPlayer.func_110124_au(), newPlayer);
        newPlayer.func_71116_b();
        newPlayer.field_71135_a.func_147359_a((Packet)new SPacketEntityStatus((net.minecraft.entity.Entity)newPlayer, worldServer.func_82736_K().func_82766_b("reducedDebugInfo") ? (byte)22 : 23));
        for (PotionEffect potioneffect : newPlayer.func_70651_bq()) {
            newPlayer.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(newPlayer.func_145782_y(), potioneffect));
        }
        ((IMixinEntityPlayerMP)newPlayer).refreshScaledHealth();
        return newPlayer;
    }

    @Override
    public void transferPlayerToDimension(EntityPlayerMP playerIn, int targetDimensionId, Teleporter teleporter) {
        MoveEntityEvent.Teleport.Portal event = EntityUtil.handleDisplaceEntityPortalEvent((net.minecraft.entity.Entity)playerIn, targetDimensionId, teleporter);
        if (event == null || event.isCancelled()) {
            return;
        }
        EntityUtil.transferPlayerToDimension(event, playerIn);
    }

    @Override
    public void prepareEntityForPortal(net.minecraft.entity.Entity entityIn, WorldServer oldWorldIn, WorldServer toWorldIn) {
        oldWorldIn.field_72984_F.func_76320_a("moving");
        WorldProvider pOld = oldWorldIn.field_73011_w;
        WorldProvider pNew = toWorldIn.field_73011_w;
        double moveFactor = this.getMovementFactor(pOld) / this.getMovementFactor(pNew);
        double x = entityIn.field_70165_t * moveFactor;
        double y = entityIn.field_70163_u;
        double z = entityIn.field_70161_v * moveFactor;
        if (pNew instanceof WorldProviderEnd) {
            BlockPos blockpos = pOld instanceof WorldProviderEnd ? toWorldIn.func_175694_M() : toWorldIn.func_180504_m();
            x = blockpos.func_177958_n();
            y = blockpos.func_177956_o();
            z = blockpos.func_177952_p();
            entityIn.func_70012_b(x, y, z, 90.0f, 0.0f);
        }
        if (!(pOld instanceof WorldProviderEnd)) {
            oldWorldIn.field_72984_F.func_76320_a("placing");
            x = MathHelper.func_76125_a((int)((int)x), (int)-29999872, (int)29999872);
            z = MathHelper.func_76125_a((int)((int)z), (int)-29999872, (int)29999872);
            if (entityIn.func_70089_S()) {
                entityIn.func_70012_b(x, y, z, entityIn.field_70177_z, entityIn.field_70125_A);
            }
            oldWorldIn.field_72984_F.func_76319_b();
        }
        if (entityIn.func_70089_S()) {
            oldWorldIn.func_72866_a(entityIn, false);
        }
        oldWorldIn.field_72984_F.func_76319_b();
    }

    @Overwrite
    public void func_82448_a(net.minecraft.entity.Entity entityIn, int p_82448_2_, WorldServer oldWorldIn, WorldServer toWorldIn) {
        this.transferEntityToWorld(entityIn, p_82448_2_, oldWorldIn, toWorldIn, toWorldIn.func_85176_s());
    }

    @Override
    public void transferEntityToWorld(net.minecraft.entity.Entity entityIn, int fromDimensionId, WorldServer fromWorld, WorldServer toWorld, Teleporter teleporter) {
        MoveEntityEvent.Teleport.Portal event = EntityUtil.handleDisplaceEntityPortalEvent(entityIn, WorldManager.getDimensionId(toWorld), teleporter);
        if (event == null || event.isCancelled()) {
            return;
        }
        entityIn.func_70012_b(event.getToTransform().getPosition().getX(), event.getToTransform().getPosition().getY(), event.getToTransform().getPosition().getZ(), (float)event.getToTransform().getYaw(), (float)event.getToTransform().getPitch());
        toWorld.func_72838_d(entityIn);
        toWorld.func_72866_a(entityIn, false);
        entityIn.func_70029_a((net.minecraft.world.World)toWorld);
    }

    @Override
    public double getMovementFactor(WorldProvider provider) {
        if (provider instanceof WorldProviderHell) {
            return 8.0;
        }
        return 1.0;
    }

    @Inject(method="setPlayerManager", at={@At(value="HEAD")}, cancellable=true)
    private void onSetPlayerManager(WorldServer[] worldServers, CallbackInfo callbackInfo) {
        if (this.field_72412_k == null) {
            this.field_72412_k = worldServers[0].func_72860_G().func_75756_e();
        }
        callbackInfo.cancel();
    }

    @Redirect(method="updateTimeAndWeatherForPlayer", at=@At(value="INVOKE", target="Lnet/minecraft/world/WorldServer;getWorldBorder()Lnet/minecraft/world/border/WorldBorder;"))
    private WorldBorder onUpdateTimeGetWorldBorder(WorldServer worldServer, EntityPlayerMP entityPlayerMP, WorldServer worldServerIn) {
        return worldServerIn.func_175723_af();
    }

    @Redirect(method="updateTimeAndWeatherForPlayer", at=@At(value="INVOKE", target="Lnet/minecraft/network/NetHandlerPlayServer;sendPacket(Lnet/minecraft/network/Packet;)V", ordinal=0))
    public void onWorldBorderInitializePacket(NetHandlerPlayServer invoker, Packet<?> packet, EntityPlayerMP playerMP, WorldServer worldServer) {
        if (worldServer.field_73011_w instanceof WorldProviderHell) {
            ((IMixinSPacketWorldBorder)packet).netherifyCenterCoordinates();
        }
        invoker.func_147359_a(packet);
    }

    @Inject(method="playerLoggedOut(Lnet/minecraft/entity/player/EntityPlayerMP;)V", at={@At(value="HEAD")})
    private void onPlayerLogOut(EntityPlayerMP player, CallbackInfo ci) {
        NBTTagCompound nbt = new NBTTagCompound();
        player.func_189511_e(nbt);
        ((SpongeUser)((Object)((IMixinEntityPlayerMP)player).getUserObject())).readFromNbt(nbt);
        ((IMixinServerScoreboard)((Object)((Player)player).getScoreboard())).removePlayer(player, false);
    }

    @Redirect(method="playerLoggedOut(Lnet/minecraft/entity/player/EntityPlayerMP;)V", at=@At(value="INVOKE", target="Lnet/minecraft/world/WorldServer;removeEntity(Lnet/minecraft/entity/Entity;)V"))
    private void onPlayerRemoveFromWorldFromDisconnect(WorldServer world, net.minecraft.entity.Entity player, EntityPlayerMP playerMP) {
        CauseTracker causeTracker = CauseTracker.getInstance();
        causeTracker.switchToPhase(PlayerPhase.State.PLAYER_LOGOUT, PhaseContext.start().add(NamedCause.source(playerMP)).addCaptures().complete());
        world.func_72900_e(player);
        causeTracker.completePhase(PlayerPhase.State.PLAYER_LOGOUT);
    }

    @Inject(method="saveAllPlayerData()V", at={@At(value="RETURN")})
    private void onSaveAllPlayerData(CallbackInfo ci) {
        for (SpongeUser user : SpongeUser.dirtyUsers) {
            user.save();
        }
    }

    @Inject(method="playerLoggedIn", at={@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendPacketToAllPlayers(Lnet/minecraft/network/Packet;)V", shift=At.Shift.BEFORE)}, cancellable=true)
    public void playerLoggedIn2(EntityPlayerMP player, CallbackInfo ci) {
        SPacketPlayerListItem noSpecificViewerPacket = new SPacketPlayerListItem(SPacketPlayerListItem.Action.ADD_PLAYER, new EntityPlayerMP[]{player});
        for (EntityPlayerMP viewer : this.field_72404_b) {
            if (((Player)viewer).canSee((Player)player)) {
                viewer.field_71135_a.func_147359_a((Packet)noSpecificViewerPacket);
            }
            if (!((Player)player).canSee((Player)viewer)) continue;
            player.field_71135_a.func_147359_a((Packet)new SPacketPlayerListItem(SPacketPlayerListItem.Action.ADD_PLAYER, new EntityPlayerMP[]{viewer}));
        }
        WorldServer level = this.field_72400_f.func_71218_a(player.field_71093_bK);
        level.func_72838_d((net.minecraft.entity.Entity)player);
        this.func_72375_a(player, null);
        ci.cancel();
    }

    @Inject(method="writePlayerData", at={@At(target="Lnet/minecraft/world/storage/IPlayerFileData;writePlayerData(Lnet/minecraft/entity/player/EntityPlayer;)V", value="INVOKE")})
    private void onWritePlayerFile(EntityPlayerMP playerMP, CallbackInfo callbackInfo) {
        SpongePlayerDataHandler.savePlayer(playerMP.func_110124_au());
    }

    @ModifyVariable(method="sendPlayerPermissionLevel", at=@At(value="HEAD"), argsOnly=true)
    public int fixPermLevel(int permLevel) {
        if (!(Sponge.getServiceManager().provideUnchecked(PermissionService.class) instanceof SpongePermissionService)) {
            return 4;
        }
        return permLevel;
    }

    @Redirect(method="updatePermissionLevel", at=@At(value="INVOKE", target="Lnet/minecraft/world/WorldServer;getWorldInfo()Lnet/minecraft/world/storage/WorldInfo;"))
    private WorldInfo onGetWorldInfo(WorldServer overworld, EntityPlayerMP player) {
        return player.field_70170_p.func_72912_H();
    }

    @Overwrite
    public void func_148544_a(ITextComponent component, boolean isSystem) {
        ChatUtil.sendMessage(component, MessageChannel.TO_ALL, (CommandSource)this.field_72400_f, !isSystem);
    }
}

