/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.Game;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.command.MinecraftCommandWrapper;
import org.spongepowered.common.command.SpongeCommandManager;
import org.spongepowered.common.command.WrapperCommandSource;
import org.spongepowered.common.interfaces.IMixinServerCommandManager;
import org.spongepowered.common.service.permission.SpongePermissionService;
import org.spongepowered.common.util.VecHelper;

@NonnullByDefault
@Mixin(value={ServerCommandManager.class})
public abstract class MixinServerCommandManager
extends CommandHandler
implements IMixinServerCommandManager {
    private List<MinecraftCommandWrapper> lowPriorityCommands = Lists.newArrayList();
    private List<MinecraftCommandWrapper> earlyRegisterCommands = Lists.newArrayList();

    private void updateStat(ICommandSender sender, CommandResultStats.Type type, Optional<Integer> count) {
        if (count.isPresent()) {
            sender.func_174794_a(type, count.get().intValue());
        }
    }

    public int func_71556_a(ICommandSender sender, String command) {
        if ((command = command.trim()).startsWith("/")) {
            command = command.substring(1);
        }
        CommandSource source = WrapperCommandSource.of(sender);
        CommandResult result = SpongeImpl.getGame().getCommandManager().process(source, command);
        this.updateStat(sender, CommandResultStats.Type.AFFECTED_BLOCKS, result.getAffectedBlocks());
        this.updateStat(sender, CommandResultStats.Type.AFFECTED_ENTITIES, result.getAffectedEntities());
        this.updateStat(sender, CommandResultStats.Type.AFFECTED_ITEMS, result.getAffectedItems());
        this.updateStat(sender, CommandResultStats.Type.QUERY_RESULT, result.getQueryResult());
        this.updateStat(sender, CommandResultStats.Type.SUCCESS_COUNT, result.getSuccessCount());
        return result.getSuccessCount().orElse(0);
    }

    public ICommand func_71560_a(ICommand command) {
        MinecraftCommandWrapper cmd = this.wrapCommand(command);
        if (cmd.getOwner().getId().equalsIgnoreCase("minecraft")) {
            this.lowPriorityCommands.add(cmd);
        } else if (SpongeImpl.getGame() == null) {
            this.earlyRegisterCommands.add(cmd);
        } else {
            SpongeImpl.getGame().getCommandManager().register((Object)cmd.getOwner(), (CommandCallable)cmd, cmd.getNames());
            this.registerDefaultPermissions(SpongeImpl.getGame(), cmd);
        }
        return super.func_71560_a(command);
    }

    @Override
    public MinecraftCommandWrapper wrapCommand(ICommand command) {
        return new MinecraftCommandWrapper(SpongeImpl.getMinecraftPlugin(), command);
    }

    private void registerDefaultPermissions(Game game, MinecraftCommandWrapper cmd) {
        Optional<PermissionService> perms = game.getServiceManager().provide(PermissionService.class);
        if (perms.isPresent()) {
            PermissionService service = perms.get();
            int opLevel = cmd.getPermissionLevel();
            if (opLevel == -1) {
                return;
            }
            if (service instanceof SpongePermissionService) {
                ((SpongePermissionService)service).getGroupForOpLevel(opLevel).getTransientSubjectData().setPermission(SubjectData.GLOBAL_CONTEXT, cmd.getCommandPermission(), Tristate.TRUE);
            } else if (opLevel == 0) {
                service.getDefaults().getTransientSubjectData().setPermission(SubjectData.GLOBAL_CONTEXT, cmd.getCommandPermission(), Tristate.TRUE);
            }
        }
    }

    private void registerCommandsList(List<MinecraftCommandWrapper> cmds, Game game) {
        Iterator<MinecraftCommandWrapper> it = cmds.iterator();
        while (it.hasNext()) {
            MinecraftCommandWrapper cmd = it.next();
            it.remove();
            game.getCommandManager().register((Object)cmd.getOwner(), (CommandCallable)cmd, cmd.getNames());
            this.registerDefaultPermissions(game, cmd);
        }
    }

    @Override
    public void registerLowPriorityCommands(Game game) {
        this.registerCommandsList(this.lowPriorityCommands, game);
    }

    @Override
    public void registerEarlyCommands(Game game) {
        this.registerCommandsList(this.earlyRegisterCommands, game);
    }

    public List<String> func_180524_a(ICommandSender sender, String input, @Nullable BlockPos pos) {
        Location<World> targetPos = null;
        if (pos != null) {
            targetPos = new Location<World>((World)sender.func_130014_f_(), VecHelper.toVector3i(pos));
        }
        return ((SpongeCommandManager)SpongeImpl.getGame().getCommandManager()).getSuggestions((CommandSource)sender, input, targetPos, false);
    }
}

