/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.management;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.server.management.IMixinPlayerChunkMap;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;

@Mixin(value={PlayerChunkMap.class})
public abstract class MixinPlayerChunkMap
implements IMixinPlayerChunkMap {
    @Shadow
    @Final
    private WorldServer field_72701_a;
    private boolean isUpdatingInstances = false;

    @Shadow
    @Nullable
    public abstract PlayerChunkMapEntry func_187301_b(int var1, int var2);

    @Override
    public boolean isChunkInUse(int x, int z) {
        PlayerChunkMapEntry playerInstance = this.func_187301_b(x, z);
        return playerInstance != null && playerInstance.field_187283_c.size() > 0;
    }

    @Redirect(method="removeEntry", at=@At(value="INVOKE", target="Lnet/minecraft/world/gen/ChunkProviderServer;unload(Lnet/minecraft/world/chunk/Chunk;)V"))
    private void onUnloadChunk(ChunkProviderServer chunkProvider, Chunk chunk) {
        if (((IMixinWorldServer)this.field_72701_a).getChunkGCTickInterval() <= 0 || ((IMixinWorldServer)this.field_72701_a).getChunkUnloadDelay() <= 0L) {
            chunkProvider.func_189549_a(chunk);
        } else {
            ((IMixinChunk)chunk).setScheduledForUnload(System.currentTimeMillis());
        }
    }

    @Redirect(method="tick", at=@At(value="INVOKE", target="Ljava/util/List;isEmpty()Z", ordinal=2))
    private boolean onChunkUnloadCheck(List<EntityPlayerMP> playerList) {
        return false;
    }

    @Inject(method="tick", at={@At(value="INVOKE", target="Ljava/util/Set;iterator()Ljava/util/Iterator;", ordinal=0)})
    public void onStartUpdateLoop(CallbackInfo ci) {
        this.isUpdatingInstances = true;
    }

    @Inject(method="tick", at={@At(value="INVOKE", target="Ljava/util/Set;clear()V")})
    public void onEndUpdateLoop(CallbackInfo ci) {
        this.isUpdatingInstances = false;
    }

    @Inject(method="addEntry", at={@At(value="HEAD")})
    public void onAddEntry(PlayerChunkMapEntry entry, CallbackInfo ci) {
        this.checkConcurrentModification(entry);
    }

    @Inject(method="removeEntry", at={@At(value="HEAD")})
    public void onRemoveEntry(PlayerChunkMapEntry entry, CallbackInfo ci) {
        this.checkConcurrentModification(entry);
    }

    private void checkConcurrentModification(PlayerChunkMapEntry entry) {
        if (this.isUpdatingInstances) {
            SpongeImpl.getLogger().error("Attempting to concurrently modify PlayerChunkMapEntry for chunk {}", new Object[]{entry.func_187264_a()});
            Thread.dumpStack();
        }
    }
}

