/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.text;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.event.HoverEvent;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.statistic.achievement.Achievement;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.interfaces.text.IMixinHoverEvent;
import org.spongepowered.common.interfaces.text.IMixinTextComponent;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

@Mixin(value={HoverEvent.class})
public abstract class MixinHoverEvent
implements IMixinHoverEvent {
    @Shadow
    @Final
    private HoverEvent.Action field_150704_a;
    @Shadow
    @Final
    private ITextComponent field_150703_b;
    private HoverAction<?> handle;
    private boolean initialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HoverAction<?> getHandle() {
        if (this.initialized) return this.handle;
        try {
            switch (this.field_150704_a) {
                case SHOW_TEXT: {
                    this.setHandle(TextActions.showText(((IMixinTextComponent)this.field_150703_b).toText()));
                    return this.handle;
                }
                case SHOW_ACHIEVEMENT: {
                    String stat = this.field_150703_b.func_150260_c();
                    this.setHandle(TextActions.showAchievement((Achievement)Preconditions.checkNotNull((Object)StatList.func_151177_a((String)stat), (String)"Unknown statistic: %s", (Object[])new Object[]{stat})));
                    return this.handle;
                }
                case SHOW_ITEM: {
                    this.setHandle(TextActions.showItem(ItemStackUtil.createSnapshot(ItemStack.func_77949_a((NBTTagCompound)this.loadNbt()))));
                    return this.handle;
                }
                case SHOW_ENTITY: {
                    NBTTagCompound nbt = this.loadNbt();
                    String name = nbt.func_74779_i("name");
                    EntityType type = null;
                    if (nbt.func_150297_b("type", 8)) {
                        type = SpongeImpl.getGame().getRegistry().getType(EntityType.class, name).orElse(null);
                    }
                    UUID uniqueId = UUID.fromString(nbt.func_74779_i("id"));
                    this.setHandle(TextActions.showEntity(uniqueId, name, type));
                    return this.handle;
                }
            }
            return this.handle;
        }
        finally {
            this.initialized = true;
        }
    }

    private NBTTagCompound loadNbt() {
        try {
            return (NBTTagCompound)Preconditions.checkNotNull((Object)JsonToNBT.func_180713_a((String)this.field_150703_b.func_150260_c()), (Object)"NBT");
        }
        catch (NBTException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void setHandle(HoverAction<?> handle) {
        if (this.initialized) {
            return;
        }
        this.handle = (HoverAction)Preconditions.checkNotNull(handle, (Object)"handle");
        this.initialized = true;
    }
}

