/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.tileentity;

import com.flowpowered.math.vector.Vector3d;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.event.cause.entity.spawn.SpawnCause;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.entity.ConstructEntityEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.event.tracking.CauseTracker;
import org.spongepowered.common.registry.type.entity.EntityTypeRegistryModule;

@Mixin(value={MobSpawnerBaseLogic.class})
public abstract class MixinMobSpawnerBaseLogic {
    private static final String WORLD_SPAWN_ENTITY = "Lnet/minecraft/world/World;spawnEntityInWorld(Lnet/minecraft/entity/Entity;)Z";
    private static final String ANVIL_CHUNK_LOADER_READ_ENTITY = "Lnet/minecraft/world/chunk/storage/AnvilChunkLoader;readWorldEntityPos(Lnet/minecraft/nbt/NBTTagCompound;Lnet/minecraft/world/World;DDDZ)Lnet/minecraft/entity/Entity;";
    @Shadow
    private int field_98290_m;
    private double posX;
    private double posY;
    private double posZ;

    @Shadow
    public abstract BlockPos func_177221_b();

    @Shadow
    public abstract World func_98271_a();

    @Redirect(method="updateSpawner", at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/storage/AnvilChunkLoader;readWorldEntityPos(Lnet/minecraft/nbt/NBTTagCompound;Lnet/minecraft/world/World;DDDZ)Lnet/minecraft/entity/Entity;"))
    private Entity onConstruct(NBTTagCompound compound, World world, double x, double y, double z, boolean doesNotForceSpawn) {
        return MixinMobSpawnerBaseLogic.readEntityFromCompoundAtWorld(compound, world, x, y, z, doesNotForceSpawn);
    }

    private static Entity readEntityFromCompoundAtWorld(NBTTagCompound compound, World world, double x, double y, double z, boolean attemptToSpawn) {
        Entity entity;
        String entityTypeString = compound.func_74779_i("id");
        Class clazz = (Class)EntityList.field_75625_b.get(entityTypeString);
        if (clazz == null) {
            PrettyPrinter printer = new PrettyPrinter(60).add("Unknown Entity for MobSpawners").centre().hr().addWrapped(60, "Sponge has found a MobSpawner attempting to locate potentiallya foreign entity type for a MobSpawner, unfortunately, there isn't away to get around the deserialization process looking up unregisteredentity types. This may be a bug with a mod or sponge.", new Object[0]).add("%s : %s", "Entity Name", entityTypeString).add();
            CauseTracker.getInstance().generateVersionInfo(printer);
            printer.trace(System.err, SpongeImpl.getLogger(), Level.WARN);
            return null;
        }
        CatalogType type = EntityTypeRegistryModule.getInstance().getForClass(clazz);
        if (type == null) {
            return null;
        }
        Object cause = ((SpawnCause.Builder)SpawnCause.builder().type(SpawnTypes.MOB_SPAWNER)).build();
        Transform<org.spongepowered.api.world.World> transform = new Transform<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)world, new Vector3d(x, y, z));
        ConstructEntityEvent.Pre event = SpongeEventFactory.createConstructEntityEventPre(Cause.of(NamedCause.source(cause)), (EntityType)type, transform);
        SpongeImpl.postEvent(event);
        if (event.isCancelled()) {
            return null;
        }
        try {
            entity = EntityList.func_75615_a((NBTTagCompound)compound, (World)world);
        }
        catch (Exception e) {
            return null;
        }
        if (entity == null) {
            return null;
        }
        entity.func_70012_b(x, y, z, entity.field_70177_z, entity.field_70125_A);
        if (attemptToSpawn && !world.func_72838_d(entity)) {
            return null;
        }
        if (compound.func_150297_b("Passengers", 9)) {
            NBTTagList passengerList = compound.func_150295_c("Passengers", 10);
            for (int i = 0; i < passengerList.func_74745_c(); ++i) {
                Entity passenger = MixinMobSpawnerBaseLogic.readEntityFromCompoundAtWorld(passengerList.func_150305_b(i), world, x, y, z, attemptToSpawn);
                if (passenger == null) continue;
                passenger.func_184205_a(entity, true);
            }
        }
        return entity;
    }

    @Inject(method="updateSpawner", at={@At(value="INVOKE", target="Lnet/minecraft/tileentity/MobSpawnerBaseLogic;resetTimer()V")})
    private void onReset(CallbackInfo callbackInfo) {
        this.posX = 0.0;
        this.posY = 0.0;
        this.posZ = 0.0;
    }
}

