/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.tileentity;

import co.aikar.timings.SpongeTimings;
import co.aikar.timings.Timing;
import com.google.common.collect.Lists;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.tileentity.TileEntityArchetype;
import org.spongepowered.api.block.tileentity.TileEntityType;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.MemoryDataContainer;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.block.SpongeTileEntityArchetypeBuilder;
import org.spongepowered.common.data.nbt.CustomDataNbtUtil;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.data.util.DataQueries;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.data.util.NbtDataUtil;
import org.spongepowered.common.event.tracking.CauseTracker;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.block.tile.IMixinTileEntity;
import org.spongepowered.common.interfaces.data.IMixinCustomDataHolder;
import org.spongepowered.common.registry.type.block.TileEntityTypeRegistryModule;

@NonnullByDefault
@Mixin(value={TileEntity.class})
@Implements(value={@Interface(iface=IMixinTileEntity.class, prefix="tile$")})
public abstract class MixinTileEntity
implements org.spongepowered.api.block.tileentity.TileEntity,
IMixinTileEntity {
    private final TileEntityType tileType = SpongeImpl.getRegistry().getTranslated(this.getClass(), TileEntityType.class);
    private final boolean isTileVanilla = this.getClass().getName().startsWith("net.minecraft.");
    private Timing timing;
    private LocatableBlock locatableBlock;
    private User spongeOwner;
    private boolean hasSetOwner = false;
    private WeakReference<IMixinChunk> activeChunk = new WeakReference<Object>(null);
    @Shadow
    protected boolean field_145846_f;
    @Shadow
    protected net.minecraft.world.World field_145850_b;
    @Shadow
    private int field_145847_g;
    @Shadow
    protected BlockPos field_174879_c;
    private BlockPos cachedPos;
    private Location<World> cachedLocation;

    @Shadow
    public abstract BlockPos func_174877_v();

    @Shadow
    public abstract Block func_145838_q();

    @Shadow
    public abstract NBTTagCompound func_189515_b(NBTTagCompound var1);

    @Shadow
    public abstract void func_70296_d();

    @Intrinsic
    public void tile$markDirty() {
        this.func_70296_d();
    }

    @Inject(method="markDirty", at={@At(value="HEAD")})
    public void onMarkDirty(CallbackInfo ci) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            CauseTracker.getInstance().getCurrentPhaseData().context.getSource(org.spongepowered.api.block.tileentity.TileEntity.class).ifPresent(currentTick -> {
                if (currentTick != this) {
                    TileEntity tileEntity = (TileEntity)currentTick;
                }
            });
        }
    }

    @Inject(method="addMapping(Ljava/lang/Class;Ljava/lang/String;)V", at={@At(value="RETURN")})
    private static void onRegister(Class clazz, String name, CallbackInfo callbackInfo) {
        if (clazz != null) {
            TileEntityTypeRegistryModule.getInstance().doTileEntityRegistration(clazz, name);
        }
    }

    @Override
    public Location<World> getLocation() {
        if (this.cachedPos == this.func_174877_v()) {
            return this.cachedLocation;
        }
        this.cachedPos = this.func_174877_v();
        this.cachedLocation = new Location<World>((World)this.field_145850_b, this.cachedPos.func_177958_n(), this.cachedPos.func_177956_o(), this.cachedPos.func_177952_p());
        return this.cachedLocation;
    }

    @Override
    public World getWorld() {
        return (World)this.field_145850_b;
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        DataContainer container = new MemoryDataContainer().set(Queries.CONTENT_VERSION, (Object)this.getContentVersion()).set(Queries.WORLD_ID, (Object)((World)this.field_145850_b).getUniqueId().toString()).set(Queries.POSITION_X, (Object)this.func_174877_v().func_177958_n()).set(Queries.POSITION_Y, (Object)this.func_174877_v().func_177956_o()).set(Queries.POSITION_Z, (Object)this.func_174877_v().func_177952_p()).set(DataQueries.BLOCK_ENTITY_TILE_TYPE, (Object)this.tileType.getId());
        NBTTagCompound compound = new NBTTagCompound();
        this.func_189515_b(compound);
        NbtDataUtil.filterSpongeCustomData(compound);
        container.set(DataQueries.UNSAFE_NBT, (Object)NbtTranslator.getInstance().translateFrom(compound));
        Collection<DataManipulator<?, ?>> manipulators = this.getContainers();
        if (!manipulators.isEmpty()) {
            container.set(DataQueries.DATA_MANIPULATORS, DataUtil.getSerializedManipulatorList(manipulators));
        }
        return container;
    }

    @Override
    public boolean validateRawData(DataView container) {
        return container.contains(Queries.WORLD_ID) && container.contains(Queries.POSITION_X) && container.contains(Queries.POSITION_Y) && container.contains(Queries.POSITION_Z) && container.contains(DataQueries.BLOCK_ENTITY_TILE_TYPE) && container.contains(DataQueries.UNSAFE_NBT);
    }

    @Override
    public void setRawData(DataView container) throws InvalidDataException {
    }

    @Override
    public boolean isValid() {
        return !this.field_145846_f;
    }

    @Override
    public void setValid(boolean valid) {
        this.field_145846_f = valid;
    }

    @Override
    public final TileEntityType getType() {
        return this.tileType;
    }

    @Override
    public BlockState getBlock() {
        return (BlockState)this.field_145850_b.func_180495_p(this.func_174877_v());
    }

    @Inject(method="invalidate", at={@At(value="RETURN")})
    public void onSpongeInvalidate(CallbackInfo ci) {
        this.setActiveChunk(null);
    }

    @Inject(method="Lnet/minecraft/tileentity/TileEntity;writeToNBT(Lnet/minecraft/nbt/NBTTagCompound;)Lnet/minecraft/nbt/NBTTagCompound;", at={@At(value="HEAD")})
    public void onWriteToNBT(NBTTagCompound compound, CallbackInfoReturnable<NBTTagCompound> ci) {
        this.writeToNbt(this.getSpongeData());
    }

    @Inject(method="Lnet/minecraft/tileentity/TileEntity;readFromNBT(Lnet/minecraft/nbt/NBTTagCompound;)V", at={@At(value="RETURN")})
    public void onReadFromNBT(NBTTagCompound compound, CallbackInfo ci) {
        this.readFromNbt(this.getSpongeData());
    }

    @Override
    public void readFromNbt(NBTTagCompound compound) {
        CustomDataNbtUtil.readCustomData(compound, this);
    }

    @Override
    public void writeToNbt(NBTTagCompound compound) {
        CustomDataNbtUtil.writeCustomData(compound, this);
    }

    public void supplyVanillaManipulators(List<DataManipulator<?, ?>> manipulators) {
    }

    @Override
    public Collection<DataManipulator<?, ?>> getContainers() {
        ArrayList list = Lists.newArrayList();
        this.supplyVanillaManipulators(list);
        if (this instanceof IMixinCustomDataHolder) {
            list.addAll(((IMixinCustomDataHolder)((Object)this)).getCustomManipulators());
        }
        return list;
    }

    @Override
    public boolean isVanilla() {
        return this.isTileVanilla;
    }

    @Override
    public Timing getTimingsHandler() {
        if (this.timing == null) {
            this.timing = SpongeTimings.getTileEntityTiming(this);
        }
        return this.timing;
    }

    @Override
    public TileEntityArchetype createArchetype() {
        return new SpongeTileEntityArchetypeBuilder().tile(this).build();
    }

    @Override
    public LocatableBlock getLocatableBlock() {
        if (this.locatableBlock == null) {
            this.locatableBlock = LocatableBlock.builder().location(new Location<World>((World)this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p())).state(this.getBlock()).build();
        }
        return this.locatableBlock;
    }

    @Override
    public void setSpongeOwner(User owner) {
        this.spongeOwner = owner;
        this.hasSetOwner = true;
    }

    @Override
    public User getSpongeOwner() {
        return this.spongeOwner;
    }

    @Override
    public boolean hasSetOwner() {
        return this.hasSetOwner;
    }

    @Override
    @Nullable
    public IMixinChunk getActiveChunk() {
        return (IMixinChunk)this.activeChunk.get();
    }

    @Override
    public void setActiveChunk(@Nullable IMixinChunk chunk) {
        this.activeChunk = new WeakReference<IMixinChunk>(chunk);
    }
}

