/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.util;

import com.google.common.base.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.Explosion;
import org.spongepowered.api.event.cause.entity.damage.DamageType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.registry.provider.DamageSourceToTypeProvider;

@Mixin(value={DamageSource.class}, priority=990)
public abstract class MixinDamageSource
implements org.spongepowered.api.event.cause.entity.damage.source.DamageSource {
    @Shadow
    public String field_76373_n;
    private DamageType apiDamageType;

    @Shadow
    public abstract boolean func_76352_a();

    @Shadow
    public abstract boolean func_76363_c();

    @Shadow
    public abstract boolean func_76357_e();

    @Shadow
    public abstract boolean func_151517_h();

    @Shadow
    public abstract boolean func_82725_o();

    @Shadow
    public abstract float func_76345_d();

    @Shadow
    public abstract boolean func_76350_n();

    @Shadow
    public abstract boolean func_94541_c();

    @Inject(method="<init>", at={@At(value="RETURN")})
    public void onConstructed(String damageTypeIn, CallbackInfo ci) {
        this.apiDamageType = DamageSourceToTypeProvider.getInstance().getOrCustom(damageTypeIn);
    }

    @Inject(method="getDeathMessage(Lnet/minecraft/entity/EntityLivingBase;)Lnet/minecraft/util/text/ITextComponent;", cancellable=true, at={@At(value="RETURN")})
    public void beforeGetDeathMessageReturn(EntityLivingBase entityLivingBaseIn, CallbackInfoReturnable<ITextComponent> cir) {
        if (cir.getReturnValue().func_150260_c().equals("death.attack." + this.field_76373_n)) {
            cir.setReturnValue((ITextComponent)new TextComponentTranslation("death.attack.generic", new Object[]{entityLivingBaseIn.func_145748_c_()}));
        }
    }

    @Inject(method="causeExplosionDamage(Lnet/minecraft/world/Explosion;)Lnet/minecraft/util/DamageSource;", at={@At(value="HEAD")}, cancellable=true)
    private static void onSetExplosionSource(Explosion explosionIn, CallbackInfoReturnable<DamageSource> cir) {
        EntityPlayer player;
        org.spongepowered.api.entity.Entity spongeEntity;
        Optional<UUID> creatorUuid;
        if (explosionIn != null && explosionIn.field_77283_e != null && explosionIn.field_77287_j != null && explosionIn.func_94613_c() == null && (creatorUuid = (spongeEntity = (org.spongepowered.api.entity.Entity)explosionIn.field_77283_e).getCreator()).isPresent() && (player = explosionIn.field_77287_j.func_152378_a(creatorUuid.get())) != null) {
            EntityDamageSourceIndirect damageSource = new EntityDamageSourceIndirect("explosion.player", explosionIn.field_77283_e, (Entity)player);
            damageSource.func_76351_m().func_94540_d();
            cir.setReturnValue((DamageSource)damageSource);
        }
    }

    @Override
    public boolean isExplosive() {
        return this.func_94541_c();
    }

    @Override
    public boolean isMagic() {
        return this.func_82725_o();
    }

    @Override
    public boolean doesAffectCreative() {
        return this.func_76357_e();
    }

    @Override
    public boolean isAbsolute() {
        return this.func_151517_h();
    }

    @Override
    public boolean isBypassingArmor() {
        return this.func_76363_c();
    }

    @Override
    public boolean isScaledByDifficulty() {
        return this.func_76350_n();
    }

    @Override
    public DamageType getType() {
        return this.apiDamageType;
    }

    public String toString() {
        return Objects.toStringHelper((String)"DamageSource").add("Name", (Object)this.field_76373_n).add("Type", (Object)this.apiDamageType.getId()).toString();
    }
}

