/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import net.minecraft.world.WorldType;
import net.minecraft.world.gen.ChunkProviderSettings;
import net.minecraft.world.gen.FlatGeneratorInfo;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.MemoryDataContainer;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.GeneratorType;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.gen.WorldGenerator;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.data.util.DataQueries;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.interfaces.world.IMixinWorldType;
import org.spongepowered.common.util.persistence.JsonTranslator;

@NonnullByDefault
@Mixin(value={WorldType.class})
public abstract class MixinWorldType
implements GeneratorType,
IMixinWorldType {
    @Shadow
    @Final
    private String field_77133_f;
    @Shadow
    @Final
    private int field_82748_f;

    @Override
    public String getId() {
        return this.field_77133_f;
    }

    @Override
    public String getName() {
        return this.field_77133_f;
    }

    @Override
    public DataContainer getGeneratorSettings() {
        if (this == WorldType.field_77138_c) {
            String defaultSettings = FlatGeneratorInfo.func_82649_e().toString();
            return new MemoryDataContainer().set(DataQueries.WORLD_CUSTOM_SETTINGS, (Object)defaultSettings);
        }
        if (this == WorldType.field_180271_f) {
            try {
                String jsonString = ChunkProviderSettings.Factory.func_177865_a((String)"").toString();
                return JsonTranslator.translateFrom(new JsonParser().parse(jsonString).getAsJsonObject());
            }
            catch (JsonParseException | IllegalStateException e) {
                AssertionError error = new AssertionError((Object)"Failed to parse default settings of CUSTOMIZED world type");
                ((Throwable)((Object)error)).initCause(e);
                throw error;
            }
        }
        return new MemoryDataContainer();
    }

    @Override
    public WorldGenerator createGenerator(World world) {
        Preconditions.checkNotNull((Object)world);
        return ((IMixinWorldServer)((Object)world)).createWorldGenerator(this.getGeneratorSettings());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getName().hashCode();
        result = 31 * result + this.field_82748_f;
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WorldType)) {
            return false;
        }
        WorldType other = (WorldType)obj;
        return this.getName().equals(other.func_77127_a()) && this.field_82748_f == other.func_82747_f();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("settings", (Object)this.getGeneratorSettings()).toString();
    }
}

