/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.Property;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.property.PropertyStore;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.Location;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.data.property.SpongePropertyRegistry;
import org.spongepowered.common.registry.provider.DirectionFacingProvider;

@Mixin(value={World.class})
public abstract class MixinWorld_Data
implements org.spongepowered.api.world.World {
    @Override
    public <T extends Property<?, ?>> Optional<T> getProperty(int x, int y, int z, Class<T> propertyClass) {
        Optional<PropertyStore<T>> optional = SpongePropertyRegistry.getInstance().getStore(propertyClass);
        if (optional.isPresent()) {
            return optional.get().getFor(new Location<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)this, x, y, z));
        }
        return Optional.empty();
    }

    @Override
    public <T extends Property<?, ?>> Optional<T> getProperty(int x, int y, int z, Direction direction, Class<T> propertyClass) {
        Optional<PropertyStore<T>> optional = SpongePropertyRegistry.getInstance().getStore(propertyClass);
        if (optional.isPresent()) {
            return optional.get().getFor(new Location<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)this, x, y, z), direction);
        }
        return Optional.empty();
    }

    @Override
    public Collection<Property<?, ?>> getProperties(int x, int y, int z) {
        return SpongePropertyRegistry.getInstance().getPropertiesFor(new Location<MixinWorld_Data>(this, x, y, z));
    }

    @Override
    public Collection<Direction> getFacesWithProperty(int x, int y, int z, Class<? extends Property<?, ?>> propertyClass) {
        Optional<PropertyStore<Property<?, ?>>> optional = SpongePropertyRegistry.getInstance().getStore(propertyClass);
        if (!optional.isPresent()) {
            return Collections.emptyList();
        }
        PropertyStore<Property<?, ?>> store = optional.get();
        Location<org.spongepowered.api.world.World> loc = new Location<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)this, x, y, z);
        ImmutableList.Builder faces = ImmutableList.builder();
        for (EnumFacing facing : EnumFacing.values()) {
            Direction direction = DirectionFacingProvider.getInstance().getKey(facing).get();
            if (!store.getFor(loc, direction).isPresent()) continue;
            faces.add((Object)direction);
        }
        return faces.build();
    }

    @Override
    public <E> Optional<E> get(int x, int y, int z, Key<? extends BaseValue<E>> key) {
        Optional optional = this.getBlock(x, y, z).withExtendedProperties(new Location<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)this, x, y, z)).get(key);
        if (optional.isPresent()) {
            return optional;
        }
        Optional<TileEntity> tileEntityOptional = this.getTileEntity(x, y, z);
        if (tileEntityOptional.isPresent()) {
            return tileEntityOptional.get().get(key);
        }
        return Optional.empty();
    }

    @Override
    public <T extends DataManipulator<?, ?>> Optional<T> get(int x, int y, int z, Class<T> manipulatorClass) {
        Collection<DataManipulator<?, ?>> manipulators = this.getManipulators(x, y, z);
        for (DataManipulator<?, ?> manipulator : manipulators) {
            if (!manipulatorClass.isInstance(manipulator)) continue;
            return Optional.of(manipulator);
        }
        return Optional.empty();
    }

    @Override
    public <T extends DataManipulator<?, ?>> Optional<T> getOrCreate(int x, int y, int z, Class<T> manipulatorClass) {
        Optional<T> optional = this.get(x, y, z, manipulatorClass);
        if (optional.isPresent()) {
            return optional;
        }
        Optional<TileEntity> tileEntity = this.getTileEntity(x, y, z);
        if (tileEntity.isPresent()) {
            return tileEntity.get().getOrCreate(manipulatorClass);
        }
        return Optional.empty();
    }

    @Override
    public <E, V extends BaseValue<E>> Optional<V> getValue(int x, int y, int z, Key<V> key) {
        BlockState blockState = this.getBlock(x, y, z).withExtendedProperties(new Location<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)this, x, y, z));
        if (blockState.supports(key)) {
            return blockState.getValue(key);
        }
        Optional<TileEntity> tileEntity = this.getTileEntity(x, y, z);
        if (tileEntity.isPresent() && tileEntity.get().supports(key)) {
            return tileEntity.get().getValue(key);
        }
        return Optional.empty();
    }

    @Override
    public boolean supports(int x, int y, int z, Key<?> key) {
        BlockState blockState = this.getBlock(x, y, z);
        boolean blockSupports = blockState.supports(key);
        Optional<TileEntity> tileEntity = this.getTileEntity(x, y, z);
        boolean tileEntitySupports = tileEntity.isPresent() && tileEntity.get().supports(key);
        return blockSupports || tileEntitySupports;
    }

    @Override
    public boolean supports(int x, int y, int z, Class<? extends DataManipulator<?, ?>> manipulatorClass) {
        BlockState blockState = this.getBlock(x, y, z);
        List<ImmutableDataManipulator<?, ?>> immutableDataManipulators = blockState.getManipulators();
        boolean blockSupports = false;
        for (ImmutableDataManipulator<?, ?> manipulator : immutableDataManipulators) {
            if (!manipulator.asMutable().getClass().isAssignableFrom(manipulatorClass)) continue;
            blockSupports = true;
            break;
        }
        if (!blockSupports) {
            Optional<TileEntity> tileEntity = this.getTileEntity(x, y, z);
            boolean tileEntitySupports = tileEntity.isPresent() && tileEntity.get().supports(manipulatorClass);
            return tileEntitySupports;
        }
        return true;
    }

    @Override
    public Set<Key<?>> getKeys(int x, int y, int z) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        BlockState blockState = this.getBlock(x, y, z).withExtendedProperties(new Location<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)this, x, y, z));
        builder.addAll(blockState.getKeys());
        Optional<TileEntity> tileEntity = this.getTileEntity(x, y, z);
        if (tileEntity.isPresent()) {
            builder.addAll(tileEntity.get().getKeys());
        }
        return builder.build();
    }

    @Override
    public Set<ImmutableValue<?>> getValues(int x, int y, int z) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        BlockState blockState = this.getBlock(x, y, z).withExtendedProperties(new Location<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)this, x, y, z));
        builder.addAll(blockState.getValues());
        Optional<TileEntity> tileEntity = this.getTileEntity(x, y, z);
        if (tileEntity.isPresent()) {
            builder.addAll(tileEntity.get().getValues());
        }
        return builder.build();
    }

    @Override
    public <E> DataTransactionResult offer(int x, int y, int z, Key<? extends BaseValue<E>> key, E value) {
        return this.getTileEntity(x, y, z).map(tileEntity -> tileEntity.offer(key, value)).orElseGet(DataTransactionResult::failNoData);
    }

    @Override
    public <E> DataTransactionResult offer(int x, int y, int z, Key<? extends BaseValue<E>> key, E value, Cause cause) {
        BlockState blockState = this.getBlock(x, y, z).withExtendedProperties(new Location<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)this, x, y, z));
        if (blockState.supports(key)) {
            ImmutableValue old = ((Value)this.getValue(x, y, z, key).get()).asImmutable();
            this.setBlock(x, y, z, (BlockState)blockState.with(key, value).get(), cause);
            ImmutableValue newVal = ((Value)this.getValue(x, y, z, key).get()).asImmutable();
            return DataTransactionResult.successReplaceResult(newVal, old);
        }
        return this.getTileEntity(x, y, z).map(tileEntity -> tileEntity.offer(key, value, cause)).orElseGet(DataTransactionResult::failNoData);
    }

    @Override
    public DataTransactionResult offer(int x, int y, int z, DataManipulator<?, ?> manipulator, MergeFunction function) {
        return this.getTileEntity(x, y, z).map(tileEntity -> tileEntity.offer(manipulator, function)).orElseGet(() -> DataTransactionResult.failResult(manipulator.getValues()));
    }

    @Override
    public DataTransactionResult offer(int x, int y, int z, DataManipulator<?, ?> manipulator, MergeFunction function, Cause cause) {
        Object immutableDataManipulator;
        BlockState blockState = this.getBlock(x, y, z).withExtendedProperties(new Location<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)this, x, y, z));
        if (blockState.supports((immutableDataManipulator = manipulator.asImmutable()).getClass())) {
            ArrayList old = new ArrayList(blockState.getValues());
            BlockState newState = (BlockState)blockState.with(immutableDataManipulator).get();
            old.removeAll(newState.getValues());
            this.setBlock(x, y, z, newState, cause);
            return DataTransactionResult.successReplaceResult(old, manipulator.getValues());
        }
        return this.getTileEntity(x, y, z).map(tileEntity -> tileEntity.offer(manipulator, function, cause)).orElseGet(() -> DataTransactionResult.failResult(manipulator.getValues()));
    }

    @Override
    public DataTransactionResult remove(int x, int y, int z, Class<? extends DataManipulator<?, ?>> manipulatorClass) {
        Optional<TileEntity> tileEntityOptional = this.getTileEntity(x, y, z);
        if (tileEntityOptional.isPresent()) {
            return tileEntityOptional.get().remove(manipulatorClass);
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    public DataTransactionResult remove(int x, int y, int z, Key<?> key) {
        Optional<TileEntity> tileEntityOptional = this.getTileEntity(x, y, z);
        if (tileEntityOptional.isPresent()) {
            return tileEntityOptional.get().remove(key);
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    public DataTransactionResult undo(int x, int y, int z, DataTransactionResult result) {
        return DataTransactionResult.failNoData();
    }

    @Override
    public DataTransactionResult copyFrom(int xTo, int yTo, int zTo, DataHolder from) {
        return this.copyFrom(xTo, yTo, zTo, from, MergeFunction.IGNORE_ALL);
    }

    @Override
    public DataTransactionResult copyFrom(int xTo, int yTo, int zTo, DataHolder from, MergeFunction function) {
        DataTransactionResult.Builder builder = DataTransactionResult.builder();
        Collection manipulators = from.getContainers();
        for (DataManipulator manipulator : manipulators) {
            builder.absorbResult(this.offer(xTo, yTo, zTo, manipulator, function));
        }
        return builder.build();
    }

    @Override
    public DataTransactionResult copyFrom(int xTo, int yTo, int zTo, int xFrom, int yFrom, int zFrom, MergeFunction function) {
        return this.copyFrom(xTo, yTo, zTo, new Location<MixinWorld_Data>(this, xFrom, yFrom, zFrom), function);
    }

    @Override
    public Collection<DataManipulator<?, ?>> getManipulators(int x, int y, int z) {
        ArrayList list = new ArrayList();
        List<ImmutableDataManipulator<?, ?>> manipulators = this.getBlock(x, y, z).withExtendedProperties(new Location<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)this, x, y, z)).getManipulators();
        for (ImmutableDataManipulator immutableDataManipulator : manipulators) {
            list.add((DataManipulator<?, ?>)immutableDataManipulator.asMutable());
        }
        Optional<TileEntity> optional = this.getTileEntity(x, y, z);
        if (optional.isPresent()) {
            list.addAll(optional.get().getContainers());
        }
        return list;
    }

    @Override
    public boolean validateRawData(int x, int y, int z, DataView container) {
        return false;
    }

    @Override
    public void setRawData(int x, int y, int z, DataView container) throws InvalidDataException {
    }
}

