/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.gen.populators;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Objects;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockBush;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBush;
import org.spongepowered.api.util.weighted.ChanceTable;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.Mushroom;
import org.spongepowered.api.world.gen.type.MushroomType;
import org.spongepowered.api.world.gen.type.MushroomTypes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.util.VecHelper;

@Mixin(value={WorldGenBush.class})
public abstract class MixinWorldGenBush
implements Mushroom {
    @Shadow
    public BlockBush field_175908_a;
    private ChanceTable<MushroomType> types;
    private Function<Location<Extent>, MushroomType> override = null;
    private VariableAmount mushroomsPerChunk;

    @Shadow
    public abstract boolean func_180709_b(World var1, Random var2, BlockPos var3);

    @Inject(method="<init>", at={@At(value="RETURN")})
    public void onConstructed(CallbackInfo ci) {
        this.types = new ChanceTable();
        this.mushroomsPerChunk = VariableAmount.fixed(1.0);
    }

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.MUSHROOM;
    }

    @Override
    public void populate(org.spongepowered.api.world.World worldIn, Extent extent, Random random) {
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        World world = (World)worldIn;
        BlockPos chunkPos = new BlockPos(min.getX(), min.getY(), min.getZ());
        int n = this.mushroomsPerChunk.getFlooredAmount(random);
        MushroomType type = MushroomTypes.BROWN;
        for (int i = 0; i < n; ++i) {
            int x = random.nextInt(size.getX());
            int z = random.nextInt(size.getZ());
            int y = this.nextInt(random, world.func_175645_m(chunkPos.func_177982_a(x, 0, z)).func_177956_o() * 2);
            BlockPos height = chunkPos.func_177982_a(x, y, z);
            if (this.override != null) {
                Location<Extent> pos2 = new Location<Extent>(extent, VecHelper.toVector3i(height));
                type = this.override.apply(pos2);
            } else {
                List<MushroomType> result = this.types.get(random);
                if (result.isEmpty()) continue;
                type = result.get(0);
            }
            this.field_175908_a = type == MushroomTypes.BROWN ? Blocks.field_150338_P : Blocks.field_150337_Q;
            this.func_180709_b(world, random, height);
        }
    }

    private int nextInt(Random rand, int i) {
        if (i <= 1) {
            return 0;
        }
        return rand.nextInt(i);
    }

    @Override
    public ChanceTable<MushroomType> getTypes() {
        return this.types;
    }

    @Override
    public VariableAmount getMushroomsPerChunk() {
        return this.mushroomsPerChunk;
    }

    @Override
    public void setMushroomsPerChunk(VariableAmount count) {
        this.mushroomsPerChunk = count;
    }

    @Override
    public Optional<Function<Location<Extent>, MushroomType>> getSupplierOverride() {
        return Optional.ofNullable(this.override);
    }

    @Override
    public void setSupplierOverride(@Nullable Function<Location<Extent>, MushroomType> override) {
        this.override = override;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("Type", (Object)"Mushroom").add("PerChunk", (Object)this.mushroomsPerChunk).toString();
    }
}

