/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.gen.populators;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Objects;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenDeadBush;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.DeadBush;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldGenDeadBush.class})
public abstract class MixinWorldGenDeadBush
extends WorldGenerator
implements DeadBush {
    private VariableAmount count;

    @Inject(method="<init>", at={@At(value="RETURN")})
    public void onConstructed(CallbackInfo ci) {
        this.count = VariableAmount.fixed(128.0);
    }

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.DEAD_BUSH;
    }

    @Override
    public void populate(org.spongepowered.api.world.World worldIn, Extent extent, Random random) {
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        World world = (World)worldIn;
        BlockPos position = new BlockPos(min.getX(), min.getY(), min.getZ());
        int n = (int)Math.ceil((float)this.count.getFlooredAmount(random) / 16.0f);
        for (int i = 0; i < n; ++i) {
            BlockPos pos = position.func_177982_a(random.nextInt(size.getX()), 0, random.nextInt(size.getZ()));
            pos = world.func_175672_r(pos).func_177982_a(0, 1, 0);
            this.func_180709_b(world, random, pos);
        }
    }

    @Override
    public VariableAmount getShrubsPerChunk() {
        return this.count;
    }

    @Override
    public void setShrubsPerChunk(VariableAmount count) {
        this.count = count;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("Type", (Object)"DeadBush").add("PerChunk", (Object)this.count).toString();
    }
}

