/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.gen.populators;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Objects;
import java.util.Random;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenDesertWells;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorObject;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.DesertWell;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldGenDesertWells.class})
public abstract class MixinWorldGenDesertWells
extends WorldGenerator
implements DesertWell,
PopulatorObject {
    @Shadow
    @Final
    private static BlockStateMatcher field_175913_a;
    private double spawnProbability;
    private PopulatorObject obj;

    @Inject(method="<init>()V", at={@At(value="RETURN")})
    public void onConstructed(CallbackInfo ci) {
        this.spawnProbability = 0.001;
        this.obj = this;
    }

    @Override
    public String getId() {
        return "minecraft:desert_well";
    }

    @Override
    public String getName() {
        return "Desert Well";
    }

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.DESERT_WELL;
    }

    @Override
    public void populate(org.spongepowered.api.world.World worldIn, Extent extent, Random random) {
        int z;
        int x;
        BlockPos pos;
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        World world = (World)worldIn;
        BlockPos chunkPos = new BlockPos(min.getX(), min.getY(), min.getZ());
        if (random.nextDouble() < this.spawnProbability && this.obj.canPlaceAt((org.spongepowered.api.world.World)world, (pos = world.func_175672_r(chunkPos.func_177982_a(x = random.nextInt(size.getX()), 0, z = random.nextInt(size.getZ()))).func_177984_a()).func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) {
            this.obj.placeObject((org.spongepowered.api.world.World)world, random, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    @Override
    public double getSpawnProbability() {
        return this.spawnProbability;
    }

    @Override
    public void setSpawnProbability(double p) {
        this.spawnProbability = p;
    }

    @Override
    public PopulatorObject getWellObject() {
        return this.obj;
    }

    @Override
    public void setWellObject(PopulatorObject obj) {
        this.obj = obj;
    }

    @Override
    public boolean canPlaceAt(org.spongepowered.api.world.World world, int x, int y, int z) {
        World worldIn = (World)world;
        BlockPos position = new BlockPos(x, y, z);
        while (worldIn.func_175623_d(position) && position.func_177956_o() > 2) {
            position = position.func_177977_b();
        }
        if (!field_175913_a.apply(worldIn.func_180495_p(position))) {
            return false;
        }
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (!worldIn.func_175623_d(position.func_177982_a(i, -1, j)) || !worldIn.func_175623_d(position.func_177982_a(i, -2, j))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void placeObject(org.spongepowered.api.world.World world, Random random, int x, int y, int z) {
        this.func_180709_b((World)world, random, new BlockPos(x, y, z));
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("Type", (Object)"DesertWell").add("Chance", this.spawnProbability).add("Object", (Object)this.obj).toString();
    }
}

