/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.gen.populators;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Objects;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenDoublePlant;
import org.spongepowered.api.data.type.DoublePlantType;
import org.spongepowered.api.data.type.DoublePlantTypes;
import org.spongepowered.api.util.weighted.TableEntry;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.util.weighted.WeightedObject;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.DoublePlant;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.util.VecHelper;

@Mixin(value={WorldGenDoublePlant.class})
public class MixinWorldGenDoublePlant
implements DoublePlant {
    private WeightedTable<DoublePlantType> types;
    private Function<Location<Extent>, DoublePlantType> override = null;
    private VariableAmount count;
    private Extent currentExtent = null;
    @Shadow
    private BlockDoublePlant.EnumPlantType field_150549_a;

    @Inject(method="<init>()V", at={@At(value="RETURN")})
    public void onConstructed(CallbackInfo ci) {
        this.types = new WeightedTable();
        this.count = VariableAmount.fixed(1.0);
    }

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.DOUBLE_PLANT;
    }

    @Override
    public void populate(org.spongepowered.api.world.World worldIn, Extent extent, Random random) {
        this.currentExtent = extent;
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        World world = (World)worldIn;
        BlockPos chunkPos = new BlockPos(min.getX(), min.getY(), min.getZ());
        int n = (int)Math.ceil((float)this.count.getFlooredAmount(random) / 8.0f);
        for (int i = 0; i < n; ++i) {
            int x = random.nextInt(size.getX());
            int z = random.nextInt(size.getZ());
            int y = this.nextInt(random, world.func_175645_m(chunkPos.func_177982_a(x, 0, z)).func_177956_o() + 32);
            this.func_180709_b(world, random, world.func_175645_m(chunkPos.func_177982_a(x, y, z)));
        }
        this.currentExtent = null;
    }

    private DoublePlantType getType(Vector3i position, Random rand) {
        if (this.override != null && this.currentExtent != null) {
            Location<Extent> pos = new Location<Extent>(this.currentExtent, position);
            return this.override.apply(pos);
        }
        List<DoublePlantType> result = this.types.get(rand);
        if (result.isEmpty()) {
            return DoublePlantTypes.GRASS;
        }
        return result.get(0);
    }

    private int nextInt(Random rand, int i) {
        if (i <= 1) {
            return 0;
        }
        return rand.nextInt(i);
    }

    @Overwrite
    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        boolean flag = false;
        if (this.types.isEmpty()) {
            this.types.add((TableEntry<DoublePlantType>)new WeightedObject<DoublePlantType>((DoublePlantType)this.field_150549_a, 1.0));
        }
        for (int i = 0; i < 8; ++i) {
            BlockPos next = position.func_177982_a(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(8) - rand.nextInt(8));
            if (!worldIn.func_175623_d(next) || worldIn.field_73011_w.func_177495_o() && next.func_177956_o() >= 254 || !Blocks.field_150398_cm.func_176196_c(worldIn, next)) continue;
            DoublePlantType type = this.getType(VecHelper.toVector3i(next), rand);
            Blocks.field_150398_cm.func_176491_a(worldIn, next, (BlockDoublePlant.EnumPlantType)type, 2);
            flag = true;
        }
        return flag;
    }

    @Override
    public WeightedTable<DoublePlantType> getPossibleTypes() {
        return this.types;
    }

    @Override
    public VariableAmount getPlantsPerChunk() {
        return this.count;
    }

    @Override
    public void setPlantsPerChunk(VariableAmount count) {
        this.count = count;
    }

    @Override
    public Optional<Function<Location<Extent>, DoublePlantType>> getSupplierOverride() {
        return Optional.ofNullable(this.override);
    }

    @Override
    public void setSupplierOverride(@Nullable Function<Location<Extent>, DoublePlantType> override) {
        this.override = override;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("Type", (Object)"DoublePlant").add("PerChunk", (Object)this.count).toString();
    }
}

