/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.gen.populators;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Objects;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.spongepowered.api.data.manipulator.mutable.MobSpawnerData;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.weighted.LootTable;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.Dungeon;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.interfaces.world.gen.IWorldGenDungeons;

@Mixin(value={WorldGenDungeons.class})
public abstract class MixinWorldGenDungeons
extends WorldGenerator
implements Dungeon,
IWorldGenDungeons {
    private VariableAmount attempts;
    private MobSpawnerData data;
    private LootTable<ItemStackSnapshot> items;

    @Inject(method="<init>()V", at={@At(value="RETURN")})
    public void onConstructed(CallbackInfo ci) {
        this.attempts = VariableAmount.fixed(8.0);
        this.data = null;
        this.items = new LootTable();
    }

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.DUNGEON;
    }

    @Override
    public void populate(org.spongepowered.api.world.World worldIn, Extent extent, Random random) {
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        World world = (World)worldIn;
        BlockPos chunkPos = new BlockPos(min.getX(), min.getY(), min.getZ());
        int n = this.attempts.getFlooredAmount(random);
        for (int i = 0; i < n; ++i) {
            int x = random.nextInt(size.getX());
            int y = random.nextInt(size.getY());
            int z = random.nextInt(size.getZ());
            this.func_180709_b(world, random, chunkPos.func_177982_a(x, y, z));
        }
    }

    @Override
    public VariableAmount getAttemptsPerChunk() {
        return this.attempts;
    }

    @Override
    public void setAttemptsPerChunk(VariableAmount attempts) {
        this.attempts = attempts;
    }

    @Override
    public MobSpawnerData getSpawnerData() {
        return this.data;
    }

    @Override
    public void setSpawnerData(MobSpawnerData data) {
        this.data = data;
    }

    @Override
    public LootTable<ItemStackSnapshot> getPossibleContents() {
        return this.items;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("Type", (Object)"Dungeon").add("PerChunk", (Object)this.attempts).add("Data", (Object)this.data).toString();
    }
}

