/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.gen.populators;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenFire;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.NetherFire;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldGenFire.class})
public class MixinWorldGenFire
implements NetherFire {
    private VariableAmount count;
    private VariableAmount cluster;

    @Inject(method="<init>()V", at={@At(value="RETURN")})
    public void onConstructed(CallbackInfo ci) {
        this.count = VariableAmount.fixed(10.0);
    }

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.NETHER_FIRE;
    }

    @Override
    public void populate(org.spongepowered.api.world.World worldIn, Extent extent, Random random) {
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        World world = (World)worldIn;
        int n = this.count.getFlooredAmount(random);
        for (int i = 0; i < n; ++i) {
            int x = min.getX() + random.nextInt(size.getX());
            int z = min.getZ() + random.nextInt(size.getZ());
            int y = min.getY() + 4 + random.nextInt(120);
            this.func_180709_b(world, random, new BlockPos(x, y, z));
        }
    }

    @Overwrite
    public boolean func_180709_b(World worldIn, Random rand, BlockPos pos) {
        int n = this.cluster.getFlooredAmount(rand);
        for (int i = 0; i < n; ++i) {
            BlockPos blockpos1 = pos.func_177982_a(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(8) - rand.nextInt(8));
            if (!worldIn.func_175623_d(blockpos1) || worldIn.func_180495_p(blockpos1.func_177977_b()).func_177230_c() != Blocks.field_150424_aL) continue;
            worldIn.func_180501_a(blockpos1, Blocks.field_150480_ab.func_176223_P(), 2);
        }
        return true;
    }

    @Override
    public VariableAmount getFirePerCluster() {
        return this.cluster;
    }

    @Override
    public void setFirePerCluster(VariableAmount count) {
        this.cluster = (VariableAmount)Preconditions.checkNotNull((Object)count);
    }

    @Override
    public VariableAmount getClustersPerChunk() {
        return this.count;
    }

    @Override
    public void setClustersPerChunk(VariableAmount count) {
        this.count = (VariableAmount)Preconditions.checkNotNull((Object)count);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("Type", (Object)"NetherFire").add("PerChunk", (Object)this.count).add("PerCluster", (Object)this.cluster).toString();
    }
}

