/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.gen.populators;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenGlowStone1;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.Glowstone;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.mixin.core.world.gen.populators.MixinWorldGenerator;

@Mixin(value={WorldGenGlowStone1.class})
public abstract class MixinWorldGenGlowstone
extends MixinWorldGenerator
implements Glowstone {
    private VariableAmount clusterheight;
    private VariableAmount height;
    private VariableAmount count;
    private VariableAmount attempts;

    @Inject(method="<init>()V", at={@At(value="RETURN")})
    public void onConstructed(CallbackInfo ci) {
        this.count = VariableAmount.baseWithRandomAddition(1.0, 10.0);
        this.attempts = VariableAmount.fixed(1500.0);
        this.clusterheight = VariableAmount.baseWithRandomAddition(0.0, 12.0);
        this.height = VariableAmount.baseWithRandomAddition(4.0, 120.0);
    }

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.GLOWSTONE;
    }

    @Override
    public void populate(org.spongepowered.api.world.World worldIn, Extent extent, Random random) {
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        World world = (World)worldIn;
        BlockPos position = new BlockPos(min.getX(), min.getY(), min.getZ());
        int n = this.count.getFlooredAmount(random);
        for (int i = 0; i < n; ++i) {
            int x = random.nextInt(size.getX());
            int z = random.nextInt(size.getZ());
            int y = this.height.getFlooredAmount(random);
            this.func_180709_b(world, random, position.func_177982_a(x, y, z));
        }
    }

    @Overwrite
    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        if (!worldIn.func_175623_d(position)) {
            return false;
        }
        if (worldIn.func_180495_p(position.func_177984_a()).func_177230_c() != Blocks.field_150424_aL) {
            return false;
        }
        worldIn.func_180501_a(position, Blocks.field_150426_aN.func_176223_P(), 2);
        int a = this.attempts.getFlooredAmount(rand);
        for (int i = 0; i < a; ++i) {
            BlockPos blockpos1 = position.func_177982_a(rand.nextInt(8) - rand.nextInt(8), this.clusterheight.getFlooredAmount(rand), rand.nextInt(8) - rand.nextInt(8));
            if (!this.isAir(worldIn.func_180495_p(blockpos1), worldIn, blockpos1)) continue;
            int j = 0;
            for (EnumFacing enumfacing : EnumFacing.values()) {
                if (worldIn.func_180495_p(blockpos1.func_177972_a(enumfacing)).func_177230_c() == Blocks.field_150426_aN) {
                    ++j;
                }
                if (j > 1) break;
            }
            if (j != true) continue;
            worldIn.func_180501_a(blockpos1, Blocks.field_150426_aN.func_176223_P(), 2);
        }
        return true;
    }

    @Override
    public VariableAmount getClustersPerChunk() {
        return this.count;
    }

    @Override
    public void setClustersPerChunk(VariableAmount count) {
        this.count = count;
    }

    @Override
    public VariableAmount getAttemptsPerCluster() {
        return this.attempts;
    }

    @Override
    public void setAttemptsPerCluster(VariableAmount attempts) {
        this.attempts = attempts;
    }

    @Override
    public VariableAmount getClusterHeight() {
        return this.clusterheight;
    }

    @Override
    public void setClusterHeight(VariableAmount height) {
        this.clusterheight = height;
    }

    @Override
    public VariableAmount getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(VariableAmount height) {
        this.height = (VariableAmount)Preconditions.checkNotNull((Object)height);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("Type", (Object)"Glowstone").add("PerChunk", (Object)this.count).add("PerCluster", (Object)this.attempts).add("Height", (Object)this.height).add("ClusterHeight", (Object)this.clusterheight).toString();
    }
}

