/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.gen.populators;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Objects;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenIcePath;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.IcePath;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldGenIcePath.class})
public abstract class MixinWorldGenIcePath
implements IcePath {
    private VariableAmount radius;
    private VariableAmount sections;
    @Shadow
    @Final
    private Block field_150555_a;

    @Inject(method="<init>(I)V", at={@At(value="RETURN")})
    public void onConstructed(int radius, CallbackInfo ci) {
        this.radius = VariableAmount.baseWithRandomAddition(2.0, radius > 2 ? (double)(radius - 2) : 1.0);
        this.sections = VariableAmount.fixed(2.0);
    }

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.ICE_PATH;
    }

    @Override
    public void populate(org.spongepowered.api.world.World worldIn, Extent extent, Random random) {
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        World world = (World)worldIn;
        BlockPos chunkPos = new BlockPos(min.getX(), min.getY(), min.getZ());
        int n = this.sections.getFlooredAmount(random);
        for (int i = 0; i < n; ++i) {
            int x = random.nextInt(size.getX());
            int z = random.nextInt(size.getZ());
            this.func_180709_b(world, random, world.func_175645_m(chunkPos.func_177982_a(x, 0, z)));
        }
    }

    @Overwrite
    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        while (worldIn.func_175623_d(position) && position.func_177956_o() > 2) {
            position = position.func_177977_b();
        }
        if (worldIn.func_180495_p(position).func_177230_c() != Blocks.field_150433_aE) {
            return false;
        }
        int i = this.radius.getFlooredAmount(rand);
        int b0 = 1;
        for (int j = position.func_177958_n() - i; j <= position.func_177958_n() + i; ++j) {
            for (int k = position.func_177952_p() - i; k <= position.func_177952_p() + i; ++k) {
                int i1;
                int l = j - position.func_177958_n();
                if (l * l + (i1 = k - position.func_177952_p()) * i1 > i * i) continue;
                for (int j1 = position.func_177956_o() - b0; j1 <= position.func_177956_o() + b0; ++j1) {
                    BlockPos blockpos1 = new BlockPos(j, j1, k);
                    Block block = worldIn.func_180495_p(blockpos1).func_177230_c();
                    if (block != Blocks.field_150346_d && block != Blocks.field_150433_aE && block != Blocks.field_150432_aD) continue;
                    worldIn.func_180501_a(blockpos1, this.field_150555_a.func_176223_P(), 2);
                }
            }
        }
        return true;
    }

    @Override
    public VariableAmount getRadius() {
        return this.radius;
    }

    @Override
    public void setRadius(VariableAmount radius) {
        this.radius = radius;
    }

    @Override
    public VariableAmount getSectionsPerChunk() {
        return this.sections;
    }

    @Override
    public void setSectionsPerChunk(VariableAmount sections) {
        this.sections = sections;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("Type", (Object)"IcePath").add("PerChunk", (Object)this.sections).add("Radius", (Object)this.radius).toString();
    }
}

